/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;
import java.util.Collections;
import java.util.List;

public class TagFilter
implements SamRecordFilter {
    private final String tag;
    private final List<Object> values;
    private Boolean includeReads;

    public TagFilter(String tag, Object value) {
        this(tag, Collections.singletonList(value), null);
    }

    public TagFilter(String tag, List<Object> values) {
        this(tag, values, null);
    }

    public TagFilter(String tag, Object value, Boolean includeReads) {
        this(tag, Collections.singletonList(value), includeReads);
    }

    public TagFilter(String tag, List<Object> values, Boolean includeReads) {
        this.tag = tag;
        this.values = values;
        this.includeReads = includeReads == null ? false : includeReads;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        return this.values.contains(record.getAttribute(this.tag)) != this.includeReads.booleanValue();
    }

    @Override
    public boolean filterOut(SAMRecord first2, SAMRecord second) {
        if (this.includeReads.booleanValue()) {
            return !this.values.contains(first2.getAttribute(this.tag)) && !this.values.contains(second.getAttribute(this.tag));
        }
        return this.values.contains(first2.getAttribute(this.tag)) && this.values.contains(second.getAttribute(this.tag));
    }
}

