/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVReader$;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException$;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$CSVFormat$1$;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry;
import org.broadinstitute.gpp.poolq3.parser.package$;
import org.broadinstitute.gpp.poolq3.reports.GctDialect$;
import org.broadinstitute.gpp.poolq3.reports.PoolQ2Dialect$;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.matching.Regex;

public final class ReferenceData$ {
    public static final ReferenceData$ MODULE$ = new ReferenceData$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.parser.ReferenceData");
    private static final String UnlabeledSampleBarcodes = "Unlabeled Sample Barcodes";
    private static final String UnlabeledColumnBarcodes = "Unlabeled Column Barcodes";
    private static final Regex LineRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?:(?:\"[ACGTacgt:;-]+ *\")|(?:[ACGTacgt:;-]+ *))([\\t,]).*$"));
    private static final Regex DelimiterRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?:[^,\\t]+)([\\t,]).+$"));

    public String UnlabeledSampleBarcodes() {
        return UnlabeledSampleBarcodes;
    }

    public String UnlabeledColumnBarcodes() {
        return UnlabeledColumnBarcodes;
    }

    public String unlabeled(ReportsDialect dialect) {
        ReportsDialect reportsDialect = dialect;
        if (PoolQ2Dialect$.MODULE$.equals(reportsDialect) ? true : GctDialect$.MODULE$.equals(reportsDialect)) {
            return this.UnlabeledSampleBarcodes();
        }
        return this.UnlabeledColumnBarcodes();
    }

    public Regex LineRegex() {
        return LineRegex;
    }

    public char guessDelimiter(BufferedReader br) {
        int n;
        br.mark(1024);
        Iterator iter = br.lines().iterator();
        if (iter.hasNext()) {
            Option<List<String>> option;
            String string = (String)iter.next();
            if (string != null && !(option = DelimiterRegex.unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0) {
                String d = (String)((LinearSeqOps)option.get()).apply(0);
                n = StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(d));
            } else {
                n = 44;
            }
        } else {
            n = 44;
        }
        int ret = n;
        br.reset();
        return (char)ret;
    }

    public ReferenceData apply(Path file, char quote) {
        return (ReferenceData)Using$.MODULE$.resource(new FileInputStream(file.toFile()), (Function1<FileInputStream, ReferenceData> & Serializable)fin -> {
            LazyRef CSVFormat$module = new LazyRef();
            BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)fin)).setByteOrderMarks(ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE).setInclude(false).get();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            char guessedDelimiter = MODULE$.guessDelimiter(br);
            package$.MODULE$.skipHeader(br, MODULE$.LineRegex());
            List<List<String>> rows = CSVReader$.MODULE$.open(br, (CSVFormat)this.CSVFormat$2(CSVFormat$module, guessedDelimiter, quote)).all();
            Object barcodes = rows.map((Function1<List, Option> & Serializable)x0$1 -> {
                List list = x0$1;
                List list2 = list;
                if (list2 instanceof $colon$colon) {
                    $colon$colon $colon$colon = ($colon$colon)list2;
                    String barcodeRaw = (String)$colon$colon.head();
                    List list3 = $colon$colon.next$access$1();
                    if (list3 instanceof $colon$colon) {
                        $colon$colon $colon$colon2 = ($colon$colon)list3;
                        String idRaw = (String)$colon$colon2.head();
                        String barcode = barcodeRaw.trim();
                        String id = idRaw.trim();
                        if (barcode.isEmpty() && id.isEmpty()) {
                            return None$.MODULE$;
                        }
                        if (org.broadinstitute.gpp.poolq3.seq.package$.MODULE$.isReferenceBarcode(barcode)) {
                            return new Some<ReferenceEntry>(new ReferenceEntry(barcode, id));
                        }
                        throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(32).append("Invalid DNA barcode '").append(barcode).append("' for ID '").append(id).append("'").toString());
                    }
                }
                throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(57).append("Incorrect number of columns. At least 2 required, got: ").append(list.length()).append(": ").append(list).toString());
            });
            if (((List)barcodes).isEmpty()) {
                throw InvalidFileException$.MODULE$.apply(file, "Empty reference file");
            }
            return new ReferenceData((Seq)((List)barcodes).flatten(Predef$.MODULE$.$conforms()));
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public char apply$default$2() {
        return '\"';
    }

    public void checkLengths(Seq<ReferenceEntry> mappings) {
        Map barcodesByLength = mappings.groupBy((Function1<ReferenceEntry, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.barcodeLength()));
        if (barcodesByLength.keySet().size() == 1) {
            return;
        }
        Seq examples = (Seq)barcodesByLength.toSeq().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int length = tuple2._1$mcI$sp();
                Seq barcodes = (Seq)tuple2._2();
                return barcodes.headOption().map((Function1<ReferenceEntry, Tuple2> & Serializable)bc -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(length)), bc));
            }
            throw new MatchError(tuple2);
        });
        Seq sortedExamples = (Seq)((IterableOps)examples.sortBy((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToInteger(ReferenceData$.$anonfun$checkLengths$4(x0$2)), Ordering$Int$.MODULE$)).map((Function1<Tuple2, String> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int length = tuple2._1$mcI$sp();
                ReferenceEntry example = (ReferenceEntry)tuple2._2();
                return new StringBuilder(10).append(example.referenceBarcode()).append(" is ").append(length).append(" bases").toString();
            }
            throw new MatchError(tuple2);
        });
        if (log.isErrorEnabled()) {
            log.error(new StringBuilder(10).append("Examples: ").append(sortedExamples.mkString(", ")).toString());
        }
        throw new IllegalArgumentException("Input barcodes must all be of the same length");
    }

    public Function1<String, String> truncator(int newLength) {
        return (Function1<String, String> & Serializable)s -> s.substring(0, newLength);
    }

    private static final /* synthetic */ ReferenceData$CSVFormat$1$ CSVFormat$lzycompute$1(LazyRef CSVFormat$module$1, char guessedDelimiter$1, char quote$1) {
        ReferenceData$CSVFormat$1$ referenceData$CSVFormat$1$;
        LazyRef lazyRef = CSVFormat$module$1;
        synchronized (lazyRef) {
            referenceData$CSVFormat$1$ = CSVFormat$module$1.initialized() ? (ReferenceData$CSVFormat$1$)CSVFormat$module$1.value() : CSVFormat$module$1.initialize(new ReferenceData$CSVFormat$1$(guessedDelimiter$1, quote$1));
        }
        return referenceData$CSVFormat$1$;
    }

    private final ReferenceData$CSVFormat$1$ CSVFormat$2(LazyRef CSVFormat$module$1, char guessedDelimiter$1, char quote$1) {
        if (CSVFormat$module$1.initialized()) {
            return (ReferenceData$CSVFormat$1$)CSVFormat$module$1.value();
        }
        return ReferenceData$.CSVFormat$lzycompute$1(CSVFormat$module$1, guessedDelimiter$1, quote$1);
    }

    public static final /* synthetic */ int $anonfun$checkLengths$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int length = tuple2._1$mcI$sp();
            return length;
        }
        throw new MatchError(tuple2);
    }

    private ReferenceData$() {
    }
}

