/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.control.NonFatal$;

public final class UnexpectedSequenceWriter$ {
    public static final UnexpectedSequenceWriter$ MODULE$ = new UnexpectedSequenceWriter$();
    private static final Logger log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter");

    public Try<BoxedUnit> write(Path outputFile, Path unexpectedSequenceCacheDir, int nSequencesToReport, Reference colReference, Option<Reference> globalReference, int maxMapSize) {
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple2 = this.loadCache(unexpectedSequenceCacheDir, colReference, nSequencesToReport, maxMapSize);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, Map<String, Object>> h = tuple2._1();
        Vector<String> r = tuple2._2();
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple22 = new Tuple2<Map<String, Map<String, Object>>, Vector<String>>(h, r);
        Map<String, Map<String, Object>> h2 = tuple22._1();
        Vector<String> r2 = tuple22._2();
        return Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(outputFile.toFile()), (Function1<PrintWriter, Object> & Serializable)pw -> {
            UnexpectedSequenceWriter$.MODULE$.printUnexpectedCounts(colReference, globalReference, h2, r2, pw);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public int write$default$6() {
        return 10000000;
    }

    public void removeCache(Path unexpectedSequenceCacheDir) {
        Files.list(unexpectedSequenceCacheDir).forEach(p -> this.tryDelete$1((Path)p));
        this.tryDelete$1(unexpectedSequenceCacheDir);
    }

    public Tuple2<Map<String, Map<String, Object>>, Vector<String>> loadCache(Path cacheDir, Reference colReference, int nSequencesToReport, int maxMapSize) {
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple2;
        HashMap rowColBarcodeCounts = new HashMap();
        HashMap allRowBarcodeCounts = new HashMap();
        Queue readers = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            colReference.allBarcodes().foreach((Function1<String, Object> & Serializable)colBc -> {
                Path file = cacheDir.resolve(UnexpectedSequenceTracker$.MODULE$.nameFor((String)colBc));
                if (Files.exists(file, new LinkOption[0])) {
                    UnexpectedSequenceWriter.SourceCachedBarcodes cbc = new UnexpectedSequenceWriter.SourceCachedBarcodes((String)colBc, Source$.MODULE$.fromFile(file.toFile(), Codec$.MODULE$.fallbackSystemCodec()));
                    if (cbc.hasNext()) {
                        return readers.enqueue(cbc);
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            UnexpectedSequenceWriter.BreadthFirstIterator iterator = new UnexpectedSequenceWriter.BreadthFirstIterator(readers);
            while (rowColBarcodeCounts.size() < maxMapSize && iterator.hasNext()) {
                Object object = iterator.next();
                if (object == null) {
                    throw new MatchError(object);
                }
                String rowBc = (String)((Tuple2)object)._1();
                String colBc2 = (String)((Tuple2)object)._2();
                Tuple2<String, String> tuple22 = new Tuple2<String, String>(rowBc, colBc2);
                String rowBc2 = tuple22._1();
                String colBc3 = tuple22._2();
                scala.collection.mutable.Map colBarcodeMap = (scala.collection.mutable.Map)rowColBarcodeCounts.getOrElseUpdate(rowBc2, (Function0<HashMap> & Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
                Option option = colBarcodeMap.updateWith(colBc3, (Function1<Option, Option> & Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return new Some<Integer>(BoxesRunTime.boxToInteger(1));
                    }
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int c = BoxesRunTime.unboxToInt(some.value());
                        return new Some<Integer>(BoxesRunTime.boxToInteger(c + 1));
                    }
                    throw new MatchError(option);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Option option2 = allRowBarcodeCounts.updateWith(rowBc2, (Function1<Option, Option> & Serializable)x0$2 -> {
                    Option option = x0$2;
                    if (None$.MODULE$.equals(option)) {
                        return new Some<Integer>(BoxesRunTime.boxToInteger(1));
                    }
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int c = BoxesRunTime.unboxToInt(some.value());
                        return new Some<Integer>(BoxesRunTime.boxToInteger(c + 1));
                    }
                    throw new MatchError(option);
                });
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            readers.foreach((Function1<UnexpectedSequenceWriter.CachedBarcodes, Object> & Serializable)rdr -> {
                UnexpectedSequenceWriter$.$anonfun$loadCache$5(rowColBarcodeCounts, allRowBarcodeCounts, rdr);
                return BoxedUnit.UNIT;
            });
            Vector mostCommonRowBarcodesRanked = (Vector)((Vector)((Vector)allRowBarcodeCounts.toVector().sortBy((Function1<Tuple2, Object> & Serializable)x$7 -> BoxesRunTime.boxToInteger(UnexpectedSequenceWriter$.$anonfun$loadCache$10(x$7)), (Ordering)Ordering$Int$.MODULE$)).take(nSequencesToReport)).map((Function1<Tuple2, String> & Serializable)x$8 -> (String)x$8._1());
            Set mostCommonRowBarcodes = mostCommonRowBarcodesRanked.toSet();
            tuple2 = new Tuple2<Map<String, Map<String, Object>>, Vector<String>>(((AbstractMap)((Object)rowColBarcodeCounts.filterInPlace((Function2<String, scala.collection.mutable.Map, Object> & Serializable)(x0$5, x1$1) -> BoxesRunTime.boxToBoolean(UnexpectedSequenceWriter$.$anonfun$loadCache$12(mostCommonRowBarcodes, x0$5, x1$1))))).view().mapValues((Function1<scala.collection.mutable.Map, Map> & Serializable)m -> m.toMap($less$colon$less$.MODULE$.refl())).toMap($less$colon$less$.MODULE$.refl()), mostCommonRowBarcodesRanked);
        }
        finally {
            readers.foreach((Function1<UnexpectedSequenceWriter.CachedBarcodes, Object> & Serializable)x$9 -> {
                x$9.close();
                return BoxedUnit.UNIT;
            });
        }
        return tuple2;
    }

    public void printUnexpectedCounts(Reference colReference, Option<Reference> globalReferenceOpt, Map<String, Map<String, Object>> h, Vector<String> rows, PrintWriter pw) {
        Seq colBarcodes = (Seq)colReference.allBarcodes().map((Function1<String, String> & Serializable)dnaBarcode -> colReference.referenceBarcodeForDnaBarcode((String)dnaBarcode));
        pw.println(this.headerText(colBarcodes));
        rows.foreach((Function1<String, Object> & Serializable)rowBc -> {
            UnexpectedSequenceWriter$.$anonfun$printUnexpectedCounts$2(h, globalReferenceOpt, colReference, pw, rowBc);
            return BoxedUnit.UNIT;
        });
    }

    public String headerText(Seq<String> colBarcodes) {
        return new StringBuilder(29).append("Sequence\tTotal\t").append(colBarcodes.mkString("\t")).append("\tPotential IDs").toString();
    }

    private final void tryDelete$1(Path p) {
        try {
            Files.delete(p);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn(new StringBuilder(17).append("Unable to delete ").append(p.toAbsolutePath()).toString());
                }
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$7(String colBc$1, HashMap allRowBarcodeCounts$1, String rowBc$1, scala.collection.mutable.Map colBarcodeMap) {
        Option option = colBarcodeMap.updateWith(colBc$1, (Function1<Option, Option> & Serializable)x0$3 -> {
            Option option = x0$3;
            if (None$.MODULE$.equals(option)) {
                return new Some<Integer>(BoxesRunTime.boxToInteger(1));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                int c = BoxesRunTime.unboxToInt(some.value());
                return new Some<Integer>(BoxesRunTime.boxToInteger(c + 1));
            }
            throw new MatchError(option);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Option option2 = allRowBarcodeCounts$1.updateWith(rowBc$1, (Function1<Option, Option> & Serializable)x0$4 -> {
            Option option = x0$4;
            if (None$.MODULE$.equals(option)) {
                return new Some<Integer>(BoxesRunTime.boxToInteger(1));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                int c = BoxesRunTime.unboxToInt(some.value());
                return new Some<Integer>(BoxesRunTime.boxToInteger(c + 1));
            }
            throw new MatchError(option);
        });
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$loadCache$6(HashMap rowColBarcodeCounts$1, String colBc$1, HashMap allRowBarcodeCounts$1, String rowBc) {
        rowColBarcodeCounts$1.get(rowBc).foreach((Function1<scala.collection.mutable.Map, Object> & Serializable)colBarcodeMap -> {
            UnexpectedSequenceWriter$.$anonfun$loadCache$7(colBc$1, allRowBarcodeCounts$1, rowBc, colBarcodeMap);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadCache$5(HashMap rowColBarcodeCounts$1, HashMap allRowBarcodeCounts$1, UnexpectedSequenceWriter.CachedBarcodes rdr) {
        String colBc = rdr.colBc();
        rdr.foreach((Function1<String, Object> & Serializable)rowBc -> {
            UnexpectedSequenceWriter$.$anonfun$loadCache$6(rowColBarcodeCounts$1, colBc, allRowBarcodeCounts$1, rowBc);
            return BoxedUnit.UNIT;
        });
        rdr.close();
    }

    public static final /* synthetic */ int $anonfun$loadCache$10(Tuple2 x$7) {
        return -x$7._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$loadCache$12(Set mostCommonRowBarcodes$1, String x0$5, scala.collection.mutable.Map x1$1) {
        Tuple2<String, scala.collection.mutable.Map> tuple2 = new Tuple2<String, scala.collection.mutable.Map>(x0$5, x1$1);
        if (tuple2 != null) {
            String rowBc = tuple2._1();
            return mostCommonRowBarcodes$1.apply(rowBc);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ int $anonfun$printUnexpectedCounts$6(Map rowCounts$1, String colBc) {
        return BoxesRunTime.unboxToInt(rowCounts$1.getOrElse(colBc, () -> 0));
    }

    public static final /* synthetic */ void $anonfun$printUnexpectedCounts$2(Map h$2, Option globalReferenceOpt$1, Reference colReference$2, PrintWriter pw$1, String rowBc) {
        Map rowCounts = (Map)h$2.getOrElse(rowBc, (Function0<Map> & Serializable)() -> Predef$.MODULE$.Map().empty());
        String possibleIds = (String)globalReferenceOpt$1.map((Function1<Reference, String> & Serializable)globalReference -> globalReference.idsForBarcode(rowBc).mkString(",")).getOrElse((Function0<String> & Serializable)() -> "");
        Seq counts = (Seq)colReference$2.allBarcodes().map((Function1<String, Object> & Serializable)colBc -> BoxesRunTime.boxToInteger(UnexpectedSequenceWriter$.$anonfun$printUnexpectedCounts$6(rowCounts, colBc)));
        int total = BoxesRunTime.unboxToInt(counts.sum(Numeric$IntIsIntegral$.MODULE$));
        pw$1.println(new StringBuilder(3).append(rowBc).append("\t").append(total).append("\t").append(counts.mkString("\t")).append("\t").append(possibleIds).toString());
    }

    private UnexpectedSequenceWriter$() {
    }
}

