/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.broadinstitute.gpp.poolq3.hist.ReadOnlyHistogram;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.GctDialect$;
import org.broadinstitute.gpp.poolq3.reports.ParsedFilename;
import org.broadinstitute.gpp.poolq3.reports.PoolQ2Dialect$;
import org.broadinstitute.gpp.poolq3.reports.PoolQ3Dialect$;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public void writeRowIdentifiers(Reference rowReference, String rowBc, PrintWriter pw) {
        String rowBarcodeIds = rowReference.idsForBarcode(rowBc).mkString(",");
        String rowInputBarcode = rowReference.referenceBarcodeForDnaBarcode(rowBc);
        pw.print(new StringBuilder(2).append(rowInputBarcode).append("\t").append(rowBarcodeIds).append("\t").toString());
    }

    public String countsHeaderText(ReportsDialect dialect, String colHeadings, int nRows, int nCols) {
        ReportsDialect reportsDialect = dialect;
        if (PoolQ3Dialect$.MODULE$.equals(reportsDialect)) {
            return new StringBuilder(28).append("Row Barcode\tRow Barcode IDs\t").append(colHeadings).toString();
        }
        if (PoolQ2Dialect$.MODULE$.equals(reportsDialect)) {
            return new StringBuilder(32).append("Construct Barcode\tConstruct IDs\t").append(colHeadings).toString();
        }
        if (GctDialect$.MODULE$.equals(reportsDialect)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(48).append("#1.2\n           |").append(nRows).append("\t").append(nCols).append("\n           |NAME\tDescription\t").append(colHeadings).toString()));
        }
        throw new MatchError(reportsDialect);
    }

    public Map<String, Object> getColumnReadCounts(Reference rowReference, Reference colReference, ReadOnlyHistogram<Tuple2<String, String>> hist) {
        return ((IterableOnceOps)colReference.allIds().map((Function1<String, Tuple2> & Serializable)colId -> {
            int readCount = BoxesRunTime.unboxToInt(((IterableOnceOps)colReference.barcodesForId((String)colId).flatMap((Function1<String, Seq> & Serializable)colBarcodeLong -> (Seq)rowReference.allBarcodes().map((Function1<String, Object> & Serializable)rowBarcodeLong -> BoxesRunTime.boxToInteger(hist.count(new Tuple2<String, String>(rowBarcodeLong, colBarcodeLong)))))).sum(Numeric$IntIsIntegral$.MODULE$));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(colId), BoxesRunTime.boxToInteger(readCount));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public ParsedFilename parseFilename(Path p) {
        Tuple2<String, Some<String>> tuple2;
        Tuple2<String, Some<String>> tuple22;
        String nameStr = ((Object)p.getFileName()).toString();
        int lastDotIdx = nameStr.lastIndexOf(46);
        if (lastDotIdx == -1) {
            tuple22 = new Tuple2<String, Some<String>>(nameStr, (Some<String>)((Object)None$.MODULE$));
        } else {
            Tuple2<String, String> tuple23 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(nameStr), lastDotIdx);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            String b = tuple23._1();
            String e = tuple23._2();
            Tuple2<String, String> tuple24 = new Tuple2<String, String>(b, e);
            String b2 = tuple24._1();
            String e2 = tuple24._2();
            tuple22 = tuple2 = new Tuple2<String, Some<String>>(b2, new Some<String>(e2));
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String base = tuple2._1();
        Option ext = tuple2._2();
        Tuple2<String, Option> tuple25 = new Tuple2<String, Option>(base, ext);
        String base2 = tuple25._1();
        Option ext2 = tuple25._2();
        return new ParsedFilename((Path)Option$.MODULE$.apply(p.getParent()).getOrElse((Function0<Path> & Serializable)() -> Paths.get(".", new String[0])), base2, ext2);
    }

    public <A> List<A> topN(Seq<A> xs, int n, Ordering<A> ord) {
        Tuple2 tuple2 = xs.splitAt(n);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq firstN = (Seq)tuple2._1();
        Seq rest = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(firstN, rest);
        Seq firstN2 = tuple22._1();
        Seq rest2 = tuple22._2();
        PriorityQueue minHeap = (PriorityQueue)PriorityQueue$.MODULE$.apply(firstN2, ord.reverse());
        rest2.foreach((Function1<Object, Object> & Serializable)x -> {
            package$.$anonfun$topN$1(minHeap, ord, x);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)minHeap.dequeueAll().reverse()).toList();
    }

    public static final /* synthetic */ void $anonfun$topN$1(PriorityQueue minHeap$1, Ordering ord$1, Object x) {
        Object y = minHeap$1.dequeue();
        minHeap$1.enqueue(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{ord$1.max(x, y)}));
    }

    private package$() {
    }
}

