/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.CRAMReferenceRegion;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CRAMRecordReadFeatures {
    final List<ReadFeature> readFeatures;

    public CRAMRecordReadFeatures() {
        this(Collections.EMPTY_LIST);
    }

    public CRAMRecordReadFeatures(List<ReadFeature> readFeatures) {
        ValidationUtils.nonNull(readFeatures);
        this.readFeatures = readFeatures;
    }

    public CRAMRecordReadFeatures(SAMRecord samRecord, byte[] bamReadBases, byte[] refBases) {
        this.readFeatures = new ArrayList<ReadFeature>();
        List<CigarElement> cigarElements = samRecord.getCigar().getCigarElements();
        int cigarLen = Cigar.getReadLength(cigarElements);
        byte[] readBases = bamReadBases;
        if (readBases.length == 0) {
            readBases = new byte[cigarLen];
            Arrays.fill(readBases, (byte)78);
        }
        byte[] baseQualities = samRecord.getBaseQualities();
        int zeroBasedPositionInRead = 0;
        int alignmentStartOffset = 0;
        for (CigarElement cigarElement : cigarElements) {
            int cigarElementLength = cigarElement.getLength();
            CigarOperator cigarOperator = cigarElement.getOperator();
            switch (cigarOperator) {
                case D: {
                    this.readFeatures.add(new Deletion(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case N: {
                    this.readFeatures.add(new RefSkip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case P: {
                    this.readFeatures.add(new Padding(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case H: {
                    this.readFeatures.add(new HardClip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case S: {
                    this.addSoftClip(zeroBasedPositionInRead, cigarElementLength, readBases);
                    break;
                }
                case I: {
                    this.addInsertion(zeroBasedPositionInRead, cigarElementLength, readBases);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    CRAMRecordReadFeatures.addMismatchReadFeatures(refBases, samRecord.getAlignmentStart(), this.readFeatures, zeroBasedPositionInRead, alignmentStartOffset, cigarElementLength, readBases, baseQualities);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarOperator.consumesReadBases()) {
                zeroBasedPositionInRead += cigarElementLength;
            }
            if (!cigarOperator.consumesReferenceBases()) continue;
            alignmentStartOffset += cigarElementLength;
        }
    }

    public final List<ReadFeature> getReadFeaturesList() {
        return this.readFeatures;
    }

    private void addSoftClip(int zeroBasedPositionInRead, int cigarElementLength, byte[] readBases) {
        byte[] insertedBases = Arrays.copyOfRange(readBases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        this.readFeatures.add(new SoftClip(zeroBasedPositionInRead + 1, insertedBases));
    }

    private void addInsertion(int zeroBasedPositionInRead, int cigarElementLength, byte[] readBases) {
        byte[] insertedBases = Arrays.copyOfRange(readBases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        for (int i = 0; i < insertedBases.length; ++i) {
            InsertBase insertBase = new InsertBase(zeroBasedPositionInRead + 1 + i, insertedBases[i]);
            this.readFeatures.add(insertBase);
        }
    }

    static void addMismatchReadFeatures(byte[] refBases, int alignmentStart, List<ReadFeature> features, int fromPosInRead, int alignmentStartOffset, int nofReadBases, byte[] bases, byte[] baseQualities) {
        int oneBasedPositionInRead = fromPosInRead + 1;
        int refIndex = alignmentStart + alignmentStartOffset - 1;
        int i = 0;
        while (i < nofReadBases) {
            byte readBase = bases[i + fromPosInRead];
            byte refBase = refIndex >= refBases.length ? (byte)78 : refBases[refIndex];
            if (readBase != refBase) {
                boolean isSubstitution;
                boolean bl = isSubstitution = SequenceUtil.isUpperACGTN(readBase) && SequenceUtil.isUpperACGTN(refBase);
                if (isSubstitution) {
                    features.add(new Substitution(oneBasedPositionInRead, readBase, refBase));
                } else {
                    byte score = baseQualities.equals(SAMRecord.NULL_QUALS) ? (byte)-1 : baseQualities[i + fromPosInRead];
                    features.add(new ReadBase(oneBasedPositionInRead, readBase, score));
                }
            }
            ++i;
            ++oneBasedPositionInRead;
            ++refIndex;
        }
    }

    public int getAlignmentEnd(int alignmentStart, int readLength) {
        int alignmentSpan = readLength;
        if (this.readFeatures != null) {
            for (ReadFeature readFeature : this.readFeatures) {
                switch (readFeature.getOperator()) {
                    case 105: {
                        --alignmentSpan;
                        break;
                    }
                    case 73: {
                        alignmentSpan -= ((Insertion)readFeature).getSequence().length;
                        break;
                    }
                    case 83: {
                        alignmentSpan -= ((SoftClip)readFeature).getSequence().length;
                        break;
                    }
                    case 68: {
                        alignmentSpan += ((Deletion)readFeature).getLength();
                        break;
                    }
                    case 78: {
                        alignmentSpan += ((RefSkip)readFeature).getLength();
                        break;
                    }
                }
            }
        }
        return alignmentStart + alignmentSpan - 1;
    }

    public Cigar getCigarForReadFeatures(int readLength) {
        CigarElement cigarElement;
        if (this.readFeatures == null) {
            CigarElement cigarElement2 = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement2));
        }
        ArrayList<CigarElement> list = new ArrayList<CigarElement>();
        CigarOperator lastOperator = CigarOperator.MATCH_OR_MISMATCH;
        int lastOpLen = 0;
        int lastOpPos = 1;
        block10: for (ReadFeature feature : this.readFeatures) {
            int readFeatureLength;
            CigarOperator cigarOperator;
            int gap = feature.getPosition() - (lastOpPos + lastOpLen);
            if (gap > 0) {
                if (lastOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    lastOpPos += lastOpLen;
                    lastOpLen = gap;
                } else {
                    lastOpLen += gap;
                }
                lastOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (feature.getOperator()) {
                case 73: {
                    cigarOperator = CigarOperator.INSERTION;
                    readFeatureLength = ((Insertion)feature).getSequence().length;
                    break;
                }
                case 83: {
                    cigarOperator = CigarOperator.SOFT_CLIP;
                    readFeatureLength = ((SoftClip)feature).getSequence().length;
                    break;
                }
                case 72: {
                    cigarOperator = CigarOperator.HARD_CLIP;
                    readFeatureLength = ((HardClip)feature).getLength();
                    break;
                }
                case 105: {
                    cigarOperator = CigarOperator.INSERTION;
                    readFeatureLength = 1;
                    break;
                }
                case 68: {
                    cigarOperator = CigarOperator.DELETION;
                    readFeatureLength = ((Deletion)feature).getLength();
                    break;
                }
                case 78: {
                    cigarOperator = CigarOperator.SKIPPED_REGION;
                    readFeatureLength = ((RefSkip)feature).getLength();
                    break;
                }
                case 80: {
                    cigarOperator = CigarOperator.PADDING;
                    readFeatureLength = ((Padding)feature).getLength();
                    break;
                }
                case 66: 
                case 88: {
                    cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
                    readFeatureLength = 1;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (lastOperator != cigarOperator) {
                if (lastOpLen > 0) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                }
                lastOperator = cigarOperator;
                lastOpLen = readFeatureLength;
                lastOpPos = feature.getPosition();
            } else {
                lastOpLen += readFeatureLength;
            }
            if (cigarOperator.consumesReadBases()) continue;
            lastOpPos -= readFeatureLength;
        }
        if (lastOperator != null) {
            if (lastOperator != CigarOperator.M) {
                list.add(new CigarElement(lastOpLen, lastOperator));
                if (readLength >= lastOpPos + lastOpLen) {
                    cigarElement = new CigarElement(readLength - (lastOpLen + lastOpPos) + 1, CigarOperator.M);
                    list.add(cigarElement);
                }
            } else if (readLength == 0 || readLength > lastOpPos - 1) {
                cigarElement = readLength == 0 ? new CigarElement(lastOpLen, CigarOperator.M) : new CigarElement(readLength - lastOpPos + 1, CigarOperator.M);
                list.add(cigarElement);
            }
        }
        if (list.isEmpty()) {
            cigarElement = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement));
        }
        return new Cigar(list);
    }

    public static byte[] restoreReadBases(List<ReadFeature> readFeatures, boolean isUnknownBases, int readAlignmentStart, int readLength, CRAMReferenceRegion cramReferenceRegion, SubstitutionMatrix substitutionMatrix) {
        if (isUnknownBases || readLength == 0) {
            return SAMRecord.NULL_SEQUENCE;
        }
        byte[] bases = new byte[readLength];
        int posInRead = 1;
        int posInSeq = 0;
        int alignmentStart = readAlignmentStart - 1;
        int zeroBasedReferenceOffset = cramReferenceRegion.getRegionStart();
        byte[] referenceBases = cramReferenceRegion.getCurrentReferenceBases();
        if (readFeatures == null) {
            if (referenceBases.length + zeroBasedReferenceOffset < alignmentStart + bases.length) {
                Arrays.fill(bases, (byte)78);
                System.arraycopy(referenceBases, alignmentStart - zeroBasedReferenceOffset, bases, 0, Math.min(bases.length, referenceBases.length + zeroBasedReferenceOffset - alignmentStart));
            } else {
                System.arraycopy(referenceBases, alignmentStart - zeroBasedReferenceOffset, bases, 0, bases.length);
            }
            return SequenceUtil.toBamReadBasesInPlace(bases);
        }
        List<ReadFeature> variations = readFeatures;
        block15: for (ReadFeature variation : variations) {
            while (posInRead < variation.getPosition()) {
                int rp = alignmentStart + posInSeq++ - zeroBasedReferenceOffset;
                bases[posInRead - 1] = CRAMRecordReadFeatures.getByteOrDefault(referenceBases, rp, (byte)78);
                ++posInRead;
            }
            switch (variation.getOperator()) {
                case 88: {
                    byte refBase = CRAMRecordReadFeatures.getByteOrDefault(referenceBases, alignmentStart + posInSeq - zeroBasedReferenceOffset, (byte)78);
                    refBase = Utils.normalizeBase(refBase);
                    Substitution substitution = (Substitution)variation;
                    byte base = substitutionMatrix.base(refBase, substitution.getCode());
                    bases[posInRead++ - 1] = base;
                    ++posInSeq;
                    break;
                }
                case 73: {
                    Insertion insertion = (Insertion)variation;
                    for (int i = 0; i < insertion.getSequence().length; ++i) {
                        bases[posInRead++ - 1] = insertion.getSequence()[i];
                    }
                    continue block15;
                }
                case 83: {
                    SoftClip softClip = (SoftClip)variation;
                    for (int i = 0; i < softClip.getSequence().length; ++i) {
                        bases[posInRead++ - 1] = softClip.getSequence()[i];
                    }
                    continue block15;
                }
                case 68: {
                    Deletion deletion = (Deletion)variation;
                    posInSeq += deletion.getLength();
                    break;
                }
                case 105: {
                    InsertBase insert = (InsertBase)variation;
                    bases[posInRead++ - 1] = insert.getBase();
                    break;
                }
                case 78: {
                    posInSeq += ((RefSkip)variation).getLength();
                    break;
                }
                case 66: 
                case 98: {
                    break;
                }
                case 81: 
                case 113: {
                    break;
                }
                case 72: 
                case 80: {
                    break;
                }
                default: {
                    throw new CRAMException(String.format("Unrecognized read feature code: %c", variation.getOperator()));
                }
            }
        }
        if (referenceBases != null) {
            while (posInRead <= readLength && alignmentStart + posInSeq - zeroBasedReferenceOffset < referenceBases.length) {
                bases[posInRead - 1] = referenceBases[alignmentStart + posInSeq - zeroBasedReferenceOffset];
                ++posInRead;
                ++posInSeq;
            }
        }
        for (ReadFeature variation : variations) {
            switch (variation.getOperator()) {
                case 66: {
                    ReadBase readBase = (ReadBase)variation;
                    bases[variation.getPosition() - 1] = readBase.getBase();
                    break;
                }
                case 98: {
                    Bases basesOp = (Bases)variation;
                    System.arraycopy(basesOp.getBases(), 0, bases, variation.getPosition() - 1, basesOp.getBases().length);
                    break;
                }
            }
        }
        return SequenceUtil.toBamReadBasesInPlace(bases);
    }

    private static byte getByteOrDefault(byte[] array, int pos, byte outOfBoundsValue) {
        if (array == null) {
            return outOfBoundsValue;
        }
        return pos >= array.length ? outOfBoundsValue : array[pos];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRAMRecordReadFeatures that = (CRAMRecordReadFeatures)o;
        return this.getReadFeaturesList() != null ? this.getReadFeaturesList().equals(that.getReadFeaturesList()) : that.getReadFeaturesList() == null;
    }

    public int hashCode() {
        return this.getReadFeaturesList() != null ? this.getReadFeaturesList().hashCode() : 0;
    }
}

