/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.ApplyOps$;
import cats.syntax.package$all$;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.hist.ReadOnlyHistogram;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.ParsedFilename;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import org.broadinstitute.gpp.poolq3.reports.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class CountsWriter$ {
    public static final CountsWriter$ MODULE$ = new CountsWriter$();

    public Try<BoxedUnit> write(Path countsFile, Option<Path> umiFileDir, ShardedHistogram<String, Tuple2<String, String>> hist, Reference rowReference, Reference colReference, Option<BarcodeSet> umiBarcodes, ReportsDialect dialect) {
        Option<BarcodeSet> option = umiBarcodes;
        if (None$.MODULE$.equals(option)) {
            return this.write(countsFile, hist, rowReference, colReference, dialect);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            BarcodeSet ub = (BarcodeSet)some.value();
            return this.writeUmi(countsFile, umiFileDir, hist, rowReference, colReference, ub, dialect);
        }
        throw new MatchError(option);
    }

    public Try<BoxedUnit> write(Path countsFile, ReadOnlyHistogram<Tuple2<String, String>> hist, Reference rowReference, Reference colReference, ReportsDialect dialect) {
        return Using$.MODULE$.apply((Function0<PrintWriter> & Serializable)() -> new PrintWriter(countsFile.toFile()), (Function1<PrintWriter, Object> & Serializable)pw -> {
            CountsWriter$.$anonfun$write$2(colReference, dialect, rowReference, hist, pw);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public Try<BoxedUnit> writeUmi(Path countsFile, Option<Path> umiFileDirOpt, ShardedHistogram<String, Tuple2<String, String>> hist, Reference rowReference, Reference colReference, BarcodeSet umiBarcodes, ReportsDialect dialect) {
        ParsedFilename parsedFilename = package$.MODULE$.parseFilename(countsFile);
        Path umiFileDir = (Path)umiFileDirOpt.getOrElse((Function0<Path> & Serializable)() -> countsFile.resolveSibling("umi-counts"));
        String basename = parsedFilename.basename();
        Option<String> extension2 = parsedFilename.extension();
        return ApplyOps$.MODULE$.$times$greater$extension(package$all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(package$all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(package$all$.MODULE$.catsSyntaxApplyOps(this.write(countsFile, hist, rowReference, colReference, dialect)), Try$.MODULE$.apply((Function0<Path> & Serializable)() -> Files.createDirectories(umiFileDir, new FileAttribute[0])), Invariant$.MODULE$.catsInstancesForTry())), this.write(umiFileDir.resolve(new StringBuilder(14).append(basename).append("-UNMATCHED-UMI").append(extension2.getOrElse((Function0<String> & Serializable)() -> "")).toString()), hist.forShard(None$.MODULE$), rowReference, colReference, dialect), Invariant$.MODULE$.catsInstancesForTry())), package$all$.MODULE$.toFoldableOps(umiBarcodes.barcodes().toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1<String, Try> & Serializable)shard -> MODULE$.write(umiFileDir.resolve(new StringBuilder(1).append(basename).append("-").append((String)shard).append(extension2.getOrElse((Function0<String> & Serializable)() -> "")).toString()), hist.forShard(new Some<String>((String)shard)), rowReference, colReference, dialect), Invariant$.MODULE$.catsInstancesForTry()), Invariant$.MODULE$.catsInstancesForTry());
    }

    public static final /* synthetic */ int $anonfun$write$4(Reference colReference$1, ReadOnlyHistogram hist$1, String rowBc$1, String colId) {
        return BoxesRunTime.unboxToInt(((IterableOnceOps)colReference$1.barcodesForId(colId).map((Function1<String, Object> & Serializable)colBc -> BoxesRunTime.boxToInteger(hist$1.count(new Tuple2<String, String>(rowBc$1, colBc))))).sum(Numeric$IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$write$3(Reference rowReference$1, PrintWriter pw$1, Reference colReference$1, ReadOnlyHistogram hist$1, String rowBc) {
        package$.MODULE$.writeRowIdentifiers(rowReference$1, rowBc, pw$1);
        Seq columns = (Seq)colReference$1.allIds().map((Function1<String, Object> & Serializable)colId -> BoxesRunTime.boxToInteger(CountsWriter$.$anonfun$write$4(colReference$1, hist$1, rowBc, colId)));
        pw$1.println(columns.mkString("\t"));
    }

    public static final /* synthetic */ void $anonfun$write$2(Reference colReference$1, ReportsDialect dialect$1, Reference rowReference$1, ReadOnlyHistogram hist$1, PrintWriter pw) {
        String colHeadings = colReference$1.allIds().mkString("\t");
        pw.println(package$.MODULE$.countsHeaderText(dialect$1, colHeadings, rowReference$1.allBarcodes().size(), colReference$1.allIds().size()));
        rowReference$1.allBarcodes().foreach((Function1<String, Object> & Serializable)rowBc -> {
            CountsWriter$.$anonfun$write$3(rowReference$1, pw, colReference$1, hist$1, rowBc);
            return BoxedUnit.UNIT;
        });
    }

    private CountsWriter$() {
    }
}

