/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

class LMProperties
extends Properties {
    private String path;
    private String bits;
    private boolean dirty;

    LMProperties(String string2, Map<String, String> map) {
        this.bits = string2;
        this.path = LibPathIterator.ncbiHome();
        if (this.path != null) {
            this.path = this.path + LibPathIterator.fileSeparator() + "LibManager.properties";
            try {
                FileInputStream fileInputStream = new FileInputStream(this.path);
                this.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object setProperty(String string2, String string3) {
        String string4 = this.getProperty(string2);
        if (string4 != null && string4.equals(string3)) {
            return string4;
        }
        this.dirty = true;
        return super.setProperty(string2, string3);
    }

    String get(String string2) {
        return this.get(string2, Logger.Level.FINE);
    }

    String cfgFilePath() {
        return this.path;
    }

    void setLastSearch(String string2) {
        this.setProperty(this.getLibRoot(string2) + "last-search", Long.toString(new Date().getTime()));
    }

    Date getLastSeach(String string2) {
        String string3 = this.getProperty(this.getLibRoot(string2) + "last-search");
        if (string3 == null) {
            return null;
        }
        return new Date(Long.valueOf(string3));
    }

    void setLatestVersion(String string2, String string3) {
        String string4 = this.getLibRoot(string2);
        this.setProperty(string4 + "latest-version/value", string3);
        this.setProperty(string4 + "latest-version/updated", Long.toString(new Date().getTime()));
    }

    String getLatestVersion(String string2, long l) {
        String string3 = this.getLibRoot(string2);
        String string4 = this.getProperty(string3 + "latest-version/value");
        String string5 = this.getProperty(string3 + "latest-version/updated");
        if (string5 == null || string4 == null) {
            return null;
        }
        if (new Date().getTime() - Long.valueOf(string5) > l) {
            this.remove(string3 + "latest-version/value");
            this.remove(string3 + "latest-version/updated");
            return null;
        }
        return string4;
    }

    void notLoaded(String string2) {
        String string3 = this.getLibRoot(string2);
        this.remove(string3 + "loaded/path");
        this.remove(string3 + "loaded/version");
        this.remove(string3 + "last-search");
        this.dirty = true;
    }

    void loaded(String string2, String string3, String string4) {
        this.set(string2, "loaded", string3, string4);
    }

    void saved(String string2, String string3, String string4) {
        this.set(string2, "saved", string3, string4);
    }

    void store() {
        try {
            if (!this.dirty) {
                return;
            }
            File file = new File(this.cfgFilePath());
            File file2 = file.getParentFile();
            if (file2 == null) {
                Logger.finest("Cannot find parent directory to store properties");
                return;
            }
            if (!file2.exists()) {
                if (!file2.mkdir()) {
                    Logger.finest("Cannot create " + file2.getName());
                    return;
                }
                file2.setExecutable(false, false);
                file2.setReadable(false, false);
                file2.setWritable(false, false);
                file2.setExecutable(true, true);
                file2.setReadable(true, true);
                file2.setWritable(true, true);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.store(fileOutputStream, null);
            fileOutputStream.close();
            this.dirty = false;
        }
        catch (IOException iOException) {
            Logger.finest(iOException);
        }
    }

    private void set(String string2, String string3, String string4, String string5) {
        String string6 = this.getLibRoot(string2) + string3 + "/";
        this.setProperty(string6 + "path", string5);
        this.setProperty(string6 + "version", string4);
    }

    private String get(String string2, Logger.Level level) {
        String string3 = this.get(string2, "loaded", level);
        if (string3 == null) {
            string3 = this.get(string2, "saved", level);
        }
        return string3;
    }

    private String get(String string2, String string3, Logger.Level level) {
        String string4 = this.getLibRoot(string2) + string3 + "/";
        String string5 = this.getProperty(string4 + "version");
        if (string5 != null) {
            String string6 = this.getProperty(string4 + "path");
            if (string6 != null) {
                Logger.log(level, "The version of the most recently loaded " + string2 + " = " + string5);
                return string6;
            }
            this.remove(string4 + "version");
            this.dirty = true;
        }
        return null;
    }

    private String getLibRoot(String string2) {
        return "/dll/" + string2 + "/" + this.bits + "/";
    }
}

