/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import java.util.Arrays;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode$;
import org.broadinstitute.gpp.poolq3.barcode.KmpKnownPrefixPolicy$;
import org.broadinstitute.gpp.poolq3.barcode.KnownPrefixPolicy;
import org.broadinstitute.gpp.poolq3.barcode.KnuthMorrisPratt;
import org.broadinstitute.gpp.poolq3.types.Read;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class KmpKnownPrefixPolicy
implements KnownPrefixPolicy,
Product,
Serializable {
    private final String prefix;
    private final int length;
    private final Option minPrefixStartPos;
    private final Option maxPrefixStartPos;
    private final KnuthMorrisPratt kmp;
    private final int prefixLength;
    private final int minPrefixStartPosInt;
    private final int maxPrefixStartPosInt;

    public static KmpKnownPrefixPolicy apply(String string2, int n, Option<Object> option, Option<Object> option2) {
        return KmpKnownPrefixPolicy$.MODULE$.apply(string2, n, option, option2);
    }

    public static KmpKnownPrefixPolicy fromProduct(Product product) {
        return KmpKnownPrefixPolicy$.MODULE$.fromProduct(product);
    }

    public static KmpKnownPrefixPolicy unapply(KmpKnownPrefixPolicy kmpKnownPrefixPolicy) {
        return KmpKnownPrefixPolicy$.MODULE$.unapply(kmpKnownPrefixPolicy);
    }

    public static Option<Object> $lessinit$greater$default$3() {
        return KmpKnownPrefixPolicy$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return KmpKnownPrefixPolicy$.MODULE$.$lessinit$greater$default$4();
    }

    public KmpKnownPrefixPolicy(String prefix, int length, Option<Object> minPrefixStartPos, Option<Object> maxPrefixStartPos) {
        this.prefix = prefix;
        this.length = length;
        this.minPrefixStartPos = minPrefixStartPos;
        this.maxPrefixStartPos = maxPrefixStartPos;
        this.kmp = new KnuthMorrisPratt(prefix);
        this.prefixLength = prefix.length();
        this.minPrefixStartPosInt = BoxesRunTime.unboxToInt(minPrefixStartPos.getOrElse(KmpKnownPrefixPolicy::$init$$$anonfun$3));
        this.maxPrefixStartPosInt = BoxesRunTime.unboxToInt(maxPrefixStartPos.getOrElse(KmpKnownPrefixPolicy::$init$$$anonfun$4));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.anyHash(this.prefix()));
        n = Statics.mix(n, this.length());
        n = Statics.mix(n, Statics.anyHash(this.minPrefixStartPos()));
        n = Statics.mix(n, Statics.anyHash(this.maxPrefixStartPos()));
        return Statics.finalizeHash(n, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof KmpKnownPrefixPolicy)) return false;
        KmpKnownPrefixPolicy kmpKnownPrefixPolicy = (KmpKnownPrefixPolicy)object;
        if (this.length() != kmpKnownPrefixPolicy.length()) return false;
        String string2 = this.prefix();
        String string3 = kmpKnownPrefixPolicy.prefix();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Option<Object> option = this.minPrefixStartPos();
        Option<Object> option2 = kmpKnownPrefixPolicy.minPrefixStartPos();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxPrefixStartPos();
        Option<Object> option4 = kmpKnownPrefixPolicy.maxPrefixStartPos();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof KmpKnownPrefixPolicy;
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public String productPrefix() {
        return "KmpKnownPrefixPolicy";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToInteger(this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "prefix";
            }
            case 1: {
                return "length";
            }
            case 2: {
                return "minPrefixStartPos";
            }
            case 3: {
                return "maxPrefixStartPos";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public int length() {
        return this.length;
    }

    public Option<Object> minPrefixStartPos() {
        return this.minPrefixStartPos;
    }

    public Option<Object> maxPrefixStartPos() {
        return this.maxPrefixStartPos;
    }

    @Override
    public Option<FoundBarcode> find(Read read) {
        int searchEndPos = package$.MODULE$.min(this.maxPrefixStartPosInt, read.seq().length() - this.length());
        return this.kmp.search(read.seq(), this.minPrefixStartPosInt, searchEndPos).map((Function1<Object, FoundBarcode> & Serializable)prefixStart -> this.find$$anonfun$1(read, BoxesRunTime.unboxToInt(prefixStart)));
    }

    public KmpKnownPrefixPolicy copy(String prefix, int length, Option<Object> minPrefixStartPos, Option<Object> maxPrefixStartPos) {
        return new KmpKnownPrefixPolicy(prefix, length, minPrefixStartPos, maxPrefixStartPos);
    }

    public String copy$default$1() {
        return this.prefix();
    }

    public int copy$default$2() {
        return this.length();
    }

    public Option<Object> copy$default$3() {
        return this.minPrefixStartPos();
    }

    public Option<Object> copy$default$4() {
        return this.maxPrefixStartPos();
    }

    public String _1() {
        return this.prefix();
    }

    public int _2() {
        return this.length();
    }

    public Option<Object> _3() {
        return this.minPrefixStartPos();
    }

    public Option<Object> _4() {
        return this.maxPrefixStartPos();
    }

    private static final int $init$$$anonfun$3() {
        return 0;
    }

    private static final int $init$$$anonfun$4() {
        return Integer.MAX_VALUE;
    }

    private final /* synthetic */ FoundBarcode find$$anonfun$1(Read read$1, int prefixStart) {
        int barcodeStart = prefixStart + this.prefixLength;
        return FoundBarcode$.MODULE$.apply(Arrays.copyOfRange(read$1.seq().toCharArray(), barcodeStart, barcodeStart + this.length()), barcodeStart);
    }
}

