/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.barcode.GeneralTemplatePolicy;
import org.broadinstitute.gpp.poolq3.barcode.GeneralTemplatePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask$;
import org.broadinstitute.gpp.poolq3.barcode.SplitBarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.SplitBarcodePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.TemplatePolicy;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class TemplatePolicy$
implements Mirror.Sum,
Serializable {
    private static final Regex Regex1;
    private static final Regex Regex2;
    public static final TemplatePolicy$ MODULE$;

    private TemplatePolicy$() {
    }

    static {
        MODULE$ = new TemplatePolicy$();
        Regex1 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^:([ACGTRYSWKMBDHVNacgtryswkmbdhvn]+)(?:@(\\d+)?(-\\d+)?)?$"));
        Regex2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([acgt]+)(N+)(n+)([acgt]+)(N+)[acgt]*$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TemplatePolicy$.class);
    }

    public Regex Regex1() {
        return Regex1;
    }

    public Regex Regex2() {
        return Regex2;
    }

    public TemplatePolicy apply(String s, int refBarcodeLength) {
        List<String> list;
        Option<List<String>> option;
        String string2 = s;
        if (string2 != null && !(option = this.Regex1().unapplySeq(string2)).isEmpty() && (list = option.get()).lengthCompare(3) == 0) {
            List<String> list2;
            Option<List<String>> option2;
            String string3 = list.apply(0);
            String string4 = list.apply(1);
            String string5 = list.apply(2);
            String ctx = string3;
            String minStr = string4;
            String maxStr = string5;
            String string6 = ctx;
            if (string6 != null && !(option2 = this.Regex2().unapplySeq(string6)).isEmpty() && (list2 = option2.get()).lengthCompare(5) == 0) {
                String string7 = list2.apply(0);
                String string8 = list2.apply(1);
                String string9 = list2.apply(2);
                String string10 = list2.apply(3);
                String string11 = list2.apply(4);
                String p1 = string7;
                String b1 = string8;
                String gap = string9;
                String p2 = string10;
                String b2 = string11;
                if (b1.length() + b2.length() != refBarcodeLength) {
                    throw new IllegalArgumentException(new StringBuilder(51).append(s).append(" is not compatible with the provided reference file").toString());
                }
                Option<Object> min = Option$.MODULE$.apply(minStr).map((Function1<String, int> & Serializable)_$4 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)_$4)));
                Option<Object> max = Option$.MODULE$.apply(maxStr).map((Function1<String, int> & Serializable)_$5 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString((String)_$5)))));
                return SplitBarcodePolicy$.MODULE$.apply(p1.toUpperCase(), b1.length(), gap.length(), p2.toUpperCase(), b2.length(), min, max);
            }
            KeyMask km = KeyMask$.MODULE$.apply(ctx);
            if (km.keyLengthInBases() != refBarcodeLength) {
                throw new IllegalArgumentException(new StringBuilder(51).append(s).append(" is not compatible with the provided reference file").toString());
            }
            Option<Object> min = Option$.MODULE$.apply(minStr).map((Function1<String, int> & Serializable)_$6 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)_$6)));
            Option<Object> max = Option$.MODULE$.apply(maxStr).map((Function1<String, int> & Serializable)_$7 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString((String)_$7)))));
            return GeneralTemplatePolicy$.MODULE$.apply(km, min, max);
        }
        throw new IllegalArgumentException(new StringBuilder(42).append("Incomprehensible template barcode policy: ").append(s).toString());
    }

    public final boolean compatible(char p, char b) {
        char c = p;
        switch (c) {
            case 'N': {
                return true;
            }
            case 'A': {
                return b == 'A';
            }
            case 'C': {
                return b == 'C';
            }
            case 'G': {
                return b == 'G';
            }
            case 'T': {
                return b == 'T';
            }
            case 'R': {
                return b == 'A' || b == 'G';
            }
            case 'Y': {
                return b == 'C' || b == 'T';
            }
            case 'S': {
                return b == 'G' || b == 'C';
            }
            case 'W': {
                return b == 'A' || b == 'T';
            }
            case 'K': {
                return b == 'G' || b == 'T';
            }
            case 'M': {
                return b == 'A' || b == 'C';
            }
            case 'B': {
                return b == 'C' || b == 'G' || b == 'T';
            }
            case 'D': {
                return b == 'A' || b == 'G' || b == 'T';
            }
            case 'H': {
                return b == 'A' || b == 'C' || b == 'T';
            }
            case 'V': {
                return b == 'A' || b == 'C' || b == 'G';
            }
        }
        return false;
    }

    public final boolean satisfies(char[] template, String seq2, int seqOffset) {
        for (int i = 0; i < template.length; ++i) {
            if (this.compatible(template[i], StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(seq2), seqOffset + i))) continue;
            return false;
        }
        return true;
    }

    public int ordinal(TemplatePolicy x$0) {
        TemplatePolicy templatePolicy = x$0;
        if (templatePolicy instanceof GeneralTemplatePolicy) {
            return 0;
        }
        if (templatePolicy instanceof SplitBarcodePolicy) {
            return 1;
        }
        throw new MatchError(templatePolicy);
    }
}

