/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVReader$;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException$;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$CSVFormat$2$;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry$;
import org.broadinstitute.gpp.poolq3.parser.parser$package$;
import org.broadinstitute.gpp.poolq3.reports.GctDialect$;
import org.broadinstitute.gpp.poolq3.reports.PoolQ2Dialect$;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import org.broadinstitute.gpp.poolq3.seq.seq$package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.matching.Regex;

public final class ReferenceData$
implements Serializable {
    private static final Logger log;
    private static final String UnlabeledSampleBarcodes;
    private static final String UnlabeledColumnBarcodes;
    private static final Regex LineRegex;
    private static final Regex DelimiterRegex;
    public static final ReferenceData$ MODULE$;

    private ReferenceData$() {
    }

    static {
        MODULE$ = new ReferenceData$();
        log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.parser.ReferenceData");
        UnlabeledSampleBarcodes = "Unlabeled Sample Barcodes";
        UnlabeledColumnBarcodes = "Unlabeled Column Barcodes";
        LineRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?:(?:\"[ACGTacgt:;-]+ *\")|(?:[ACGTacgt:;-]+ *))([\\t,]).*$"));
        DelimiterRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?:[^,\\t]+)([\\t,]).+$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ReferenceData$.class);
    }

    public String UnlabeledSampleBarcodes() {
        return UnlabeledSampleBarcodes;
    }

    public String UnlabeledColumnBarcodes() {
        return UnlabeledColumnBarcodes;
    }

    public String unlabeled(ReportsDialect dialect) {
        ReportsDialect reportsDialect = dialect;
        if (PoolQ2Dialect$.MODULE$.equals(reportsDialect) || GctDialect$.MODULE$.equals(reportsDialect)) {
            return this.UnlabeledSampleBarcodes();
        }
        return this.UnlabeledColumnBarcodes();
    }

    public Regex LineRegex() {
        return LineRegex;
    }

    public char guessDelimiter(BufferedReader br) {
        int n;
        br.mark(1024);
        Iterator iter = br.lines().iterator();
        if (iter.hasNext()) {
            List<String> list;
            Option<List<String>> option;
            String string2 = (String)iter.next();
            if (string2 != null && !(option = DelimiterRegex.unapplySeq(string2)).isEmpty() && (list = option.get()).lengthCompare(1) == 0) {
                String string3;
                String d = string3 = list.apply(0);
                n = StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(d));
            } else {
                n = 44;
            }
        } else {
            n = 44;
        }
        int ret = n;
        br.reset();
        return (char)ret;
    }

    public ReferenceData apply(Path file, char quote) {
        return (ReferenceData)Using$.MODULE$.resource(new FileInputStream(file.toFile()), (Function1<FileInputStream, ReferenceData> & Serializable)fin -> {
            LazyRef lazyRef = new LazyRef();
            BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)fin)).setByteOrderMarks(ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE).setInclude(false).get();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            char guessedDelimiter = this.guessDelimiter(br);
            parser$package$.MODULE$.skipHeader(br, this.LineRegex());
            List<List<String>> rows = CSVReader$.MODULE$.open(br, (CSVFormat)this.CSVFormat$1(lazyRef, guessedDelimiter, quote)).all();
            Object barcodes = rows.map((Function1<List, Option> & Serializable)x$1 -> {
                List list = x$1;
                List xs = list;
                List list2 = xs;
                if (list2 instanceof $colon$colon) {
                    $colon$colon $colon$colon = ($colon$colon)list2;
                    List list3 = $colon$colon.next$access$1();
                    String barcodeRaw = (String)$colon$colon.head();
                    if (list3 instanceof $colon$colon) {
                        List list4 = (($colon$colon)list3).next$access$1();
                        String idRaw = (String)(($colon$colon)list3).head();
                        String barcode2 = barcodeRaw.trim();
                        String id = idRaw.trim();
                        if (barcode2.isEmpty() && id.isEmpty()) {
                            return None$.MODULE$;
                        }
                        if (seq$package$.MODULE$.isReferenceBarcode(barcode2)) {
                            return Some$.MODULE$.apply(ReferenceEntry$.MODULE$.apply(barcode2, id));
                        }
                        throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(32).append("Invalid DNA barcode '").append(barcode2).append("' for ID `").append(id).append("`").toString());
                    }
                }
                throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(57).append("Incorrect number of columns. At least 2 required, got: ").append(xs.length()).append(": ").append(xs.mkString("`", "`, `", "`")).toString());
            });
            if (((List)barcodes).isEmpty()) {
                throw InvalidFileException$.MODULE$.apply(file, "Empty reference file");
            }
            return new ReferenceData((Seq)((List)barcodes).flatten(Predef$.MODULE$.$conforms()));
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public char apply$default$2() {
        return '\"';
    }

    public void checkLengths(Seq<ReferenceEntry> mappings) {
        Map barcodesByLength = mappings.groupBy((Function1<ReferenceEntry, int> & Serializable)_$1 -> _$1.barcodeLength());
        if (barcodesByLength.keySet().size() == 1) {
            return;
        }
        Seq examples = (Seq)barcodesByLength.toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int length = BoxesRunTime.unboxToInt(tuple2._1());
                Seq barcodes = (Seq)tuple2._2();
                return barcodes.headOption().map((Function1<ReferenceEntry, Tuple2> & Serializable)bc -> {
                    Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(length));
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, bc);
                });
            }
            throw new MatchError(tuple2);
        });
        Seq sortedExamples = (Seq)((IterableOps)examples.sortBy((Function1<Tuple2, int> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int length = BoxesRunTime.unboxToInt(tuple2._1());
                return length;
            }
            throw new MatchError(tuple2);
        }, Ordering$Int$.MODULE$)).map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int length = BoxesRunTime.unboxToInt(tuple2._1());
                ReferenceEntry example = (ReferenceEntry)tuple2._2();
                return new StringBuilder(10).append(example.referenceBarcode()).append(" is ").append(length).append(" bases").toString();
            }
            throw new MatchError(tuple2);
        });
        Logger Logger_this = log;
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error(new StringBuilder(10).append("Examples: ").append(sortedExamples.mkString(", ")).toString());
        }
        throw new IllegalArgumentException("Input barcodes must all be of the same length");
    }

    public Function1<String, String> truncator(int newLength) {
        return (Function1<String, String> & Serializable)s -> s.substring(0, newLength);
    }

    private final ReferenceData$CSVFormat$2$ CSVFormat$lzyINIT1$1(LazyRef CSVFormat$lzy1$1, char guessedDelimiter$1, char quote$1) {
        ReferenceData$CSVFormat$2$ referenceData$CSVFormat$2$;
        LazyRef lazyRef = CSVFormat$lzy1$1;
        synchronized (lazyRef) {
            referenceData$CSVFormat$2$ = (ReferenceData$CSVFormat$2$)(CSVFormat$lzy1$1.initialized() ? CSVFormat$lzy1$1.value() : CSVFormat$lzy1$1.initialize(new ReferenceData$CSVFormat$2$(guessedDelimiter$1, quote$1)));
        }
        return referenceData$CSVFormat$2$;
    }

    private final ReferenceData$CSVFormat$2$ CSVFormat$1(LazyRef CSVFormat$lzy1$2, char guessedDelimiter$2, char quote$2) {
        return (ReferenceData$CSVFormat$2$)(CSVFormat$lzy1$2.initialized() ? CSVFormat$lzy1$2.value() : this.CSVFormat$lzyINIT1$1(CSVFormat$lzy1$2, guessedDelimiter$2, quote$2));
    }
}

