/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode;
import org.broadinstitute.gpp.poolq3.hist.BasicShardedHistogram;
import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.OpenHashMapHistogram;
import org.broadinstitute.gpp.poolq3.hist.TupleHistogram;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.seq.seq$package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class ScoringConsumer
implements Consumer {
    private final Reference rowReference;
    private final Reference colReference;
    private final boolean countAmbiguous;
    private final boolean alwaysCountColumnBarcodes;
    private final Option<BarcodeSet> umiReference;
    public final Option<UnexpectedSequenceTracker> org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt;
    private final boolean pairedEndMode;
    public final Logger org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log;
    public final ArrayBlockingQueue<Tuple2<char[], char[]>> org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue;
    public volatile boolean org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done;
    private final State state;
    private final Thread unexpectedSequenceTrackerThread;

    public ScoringConsumer(Reference rowReference, Reference colReference, boolean countAmbiguous, boolean alwaysCountColumnBarcodes, Option<BarcodeSet> umiReference, Option<UnexpectedSequenceTracker> unexpectedSequenceTrackerOpt, boolean pairedEndMode) {
        this.rowReference = rowReference;
        this.colReference = colReference;
        this.countAmbiguous = countAmbiguous;
        this.alwaysCountColumnBarcodes = alwaysCountColumnBarcodes;
        this.umiReference = umiReference;
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt = unexpectedSequenceTrackerOpt;
        this.pairedEndMode = pairedEndMode;
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.process.ScoringConsumer");
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue = new ArrayBlockingQueue(1000);
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done = false;
        this.state = new State(new BasicShardedHistogram<String, Tuple2<String, String>>(ScoringConsumer::$init$$$anonfun$1), new OpenHashMapHistogram<String>(), new OpenHashMapHistogram<String>(), new OpenHashMapHistogram<String>());
        this.unexpectedSequenceTrackerThread = new Thread(this){
            private final /* synthetic */ ScoringConsumer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final void run() {
                if (!this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.isDefined()) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                UnexpectedSequenceTracker unexpectedSequenceTracker = this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.get();
                while (!this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done || !this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.isEmpty()) {
                    try {
                        Option$.MODULE$.apply(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.poll(100L, TimeUnit.MILLISECONDS)).foreach(arg_0 -> ScoringConsumer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$anon$1$$_$run$$anonfun$1(unexpectedSequenceTracker, arg_0));
                    }
                    catch (InterruptedException interruptedException) {
                        Logger Logger_this = this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log;
                        if (!Logger_this.isDebugEnabled()) continue;
                        Logger_this.debug(new StringBuilder(37).append("Interrupted. Done = ").append(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done).append("; queue length = ").append(this.$outer.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.size()).toString());
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$anon$1$$_$run$$anonfun$1(org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    @Override
    public State state() {
        return this.state;
    }

    @Override
    public void start() {
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.foreach(_$1 -> this.unexpectedSequenceTrackerThread.start());
    }

    @Override
    public void close() {
        this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.foreach(_$2 -> {
            this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$done = true;
            this.unexpectedSequenceTrackerThread.join();
            this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.foreach(_$3 -> _$3.close());
        });
    }

    @Override
    public void consume(Barcodes parsedBarcode) {
        this.state().reads_$eq(this.state().reads() + 1);
        Tuple3<Option<FoundBarcode>, Option<FoundBarcode>, Option<FoundBarcode>> tuple3 = Tuple3$.MODULE$.apply(parsedBarcode.row(), parsedBarcode.revRow(), parsedBarcode.col());
        if (tuple3 != null) {
            Option<FoundBarcode> option = tuple3._1();
            None$ none$ = tuple3._2();
            Option<FoundBarcode> option2 = tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                FoundBarcode foundBarcode = (FoundBarcode)some.value();
                Some f = some;
                None$ revRowOpt = none$;
                if (None$.MODULE$.equals(option2)) {
                    this.updateRowBarcodePositionStats(f, this.pairedEndMode ? revRowOpt : None$.MODULE$);
                    return;
                }
                FoundBarcode parsedRow = foundBarcode;
                Some f2 = some;
                if (None$.MODULE$.equals(none$) && option2 instanceof Some) {
                    FoundBarcode parsedCol = (FoundBarcode)((Some)option2).value();
                    this.updateRowBarcodePositionStats(f2, None$.MODULE$);
                    if (!this.pairedEndMode) {
                        Seq<MatchedBarcode> rowBc = this.rowReference.find(parsedRow.barcode());
                        Seq<MatchedBarcode> colBc = this.colReference.find(parsedCol.barcode());
                        this.updateColumnBarcodeStats(colBc, parsedCol);
                        rowBc.foreach(row -> colBc.foreach(col -> this.matchedRowAndCol((MatchedBarcode)row, (MatchedBarcode)col, parsedBarcode.umi())));
                        if (this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.isDefined() && colBc.nonEmpty() && rowBc.isEmpty() && !seq$package$.MODULE$.containsN(parsedRow.barcode())) {
                            this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.put(Tuple2$.MODULE$.apply(parsedRow.barcode(), parsedCol.barcode()));
                            return;
                        }
                        return;
                    }
                    return;
                }
                FoundBarcode parsedRow2 = foundBarcode;
                Some f3 = some;
                if (none$ instanceof Some) {
                    Some some2 = (Some)((Object)none$);
                    FoundBarcode parsedRevRow = (FoundBarcode)some2.value();
                    Some r = some2;
                    if (option2 instanceof Some) {
                        FoundBarcode parsedCol = (FoundBarcode)((Some)option2).value();
                        this.updateRowBarcodePositionStats(f3, r);
                        char[] combinedBarcode = (char[])Array$.MODULE$.concat(ScalaRunTime$.MODULE$.wrapRefArray((T[])new char[][]{parsedRow2.barcode(), parsedRevRow.barcode()}), ClassTag$.MODULE$.apply(Character.TYPE));
                        Seq<MatchedBarcode> rowBc = this.rowReference.find(combinedBarcode);
                        Seq<MatchedBarcode> colBc = this.colReference.find(parsedCol.barcode());
                        this.updateColumnBarcodeStats(colBc, parsedCol);
                        rowBc.foreach(row -> colBc.foreach(col -> this.matchedRowAndCol((MatchedBarcode)row, (MatchedBarcode)col, parsedBarcode.umi())));
                        if (this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceTrackerOpt.isDefined() && colBc.nonEmpty() && rowBc.isEmpty() && !seq$package$.MODULE$.containsN(parsedRow2.barcode())) {
                            this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$unexpectedSequenceQueue.put(Tuple2$.MODULE$.apply(parsedRow2.barcode(), parsedCol.barcode()));
                            return;
                        }
                        return;
                    }
                }
            }
            if (None$.MODULE$.equals(option)) {
                None$ r = none$;
                if (None$.MODULE$.equals(option2)) {
                    this.updateRowBarcodePositionStats(None$.MODULE$, r);
                    return;
                }
                None$ r2 = none$;
                if (option2 instanceof Some) {
                    FoundBarcode col = (FoundBarcode)((Some)option2).value();
                    this.updateRowBarcodePositionStats(None$.MODULE$, r2);
                    if (this.alwaysCountColumnBarcodes) {
                        Seq<MatchedBarcode> colBc = this.colReference.find(col.barcode());
                        this.updateColumnBarcodeStats(colBc, col);
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError(tuple3);
    }

    private void matchedRowAndCol(MatchedBarcode row, MatchedBarcode col, Option<FoundBarcode> umi) {
        Option<BarcodeSet> option;
        String r = row.barcode();
        String c = col.barcode();
        Logger Logger_this = this.org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$log;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(29).append("Incrementing state for (").append(r).append(", ").append(c).append("}).").toString());
        }
        if (None$.MODULE$.equals(option = this.umiReference)) {
            int n = this.state().known().increment(None$.MODULE$, Tuple2$.MODULE$.apply(r, c));
        } else if (option instanceof Some) {
            BarcodeSet ref = (BarcodeSet)((Some)option).value();
            this.handleUmi(umi, ref, r, c);
        } else {
            throw new MatchError(option);
        }
        this.state().matches_$eq(this.state().matches() + 1);
        if (row.distance() == 0) {
            this.state().exactMatches_$eq(this.state().exactMatches() + 1);
            return;
        }
    }

    private void handleUmi(Option<FoundBarcode> umi, BarcodeSet ref, String r, String c) {
        Option<FoundBarcode> option = umi;
        if (option instanceof Some) {
            FoundBarcode s = (FoundBarcode)((Some)option).value();
            String u = new String(s.barcode());
            if (ref.isDefined(u)) {
                int n = this.state().known().increment(Some$.MODULE$.apply(u), Tuple2$.MODULE$.apply(r, c));
                return;
            }
            int n = this.state().known().increment(None$.MODULE$, Tuple2$.MODULE$.apply(r, c));
            int n2 = this.state().unknownUmi().increment(u);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.state().umiBarcodeNotFound_$eq(this.state().umiBarcodeNotFound() + 1);
            return;
        }
        throw new MatchError(option);
    }

    private void updateColumnBarcodeStats(Seq<MatchedBarcode> colBc, FoundBarcode col) {
        if (this.countAmbiguous || colBc.lengthCompare(1) == 0) {
            colBc.foreach((Function1<MatchedBarcode, int> & Serializable)mb -> this.state().knownCol().increment(mb.barcode()));
            return;
        }
        if (colBc.isEmpty() && !seq$package$.MODULE$.containsN(col.barcode())) {
            int n = this.state().unknownCol().increment(new String(col.barcode()));
            return;
        }
    }

    private void updateRowBarcodePositionStats(Option<FoundBarcode> row, Option<FoundBarcode> revRow) {
        row.foreach(r -> this.state().rowBarcodeStats().update(r.offset0()));
        revRow.foreach(r -> this.state().revRowBarcodeStats().update(r.offset0()));
        if (row.isEmpty() && revRow.isEmpty()) {
            this.state().neitherRowBarcodeFound_$eq(this.state().neitherRowBarcodeFound() + 1);
            return;
        }
    }

    @Override
    public int readsProcessed() {
        return this.state().reads();
    }

    @Override
    public int matchingReads() {
        return this.state().matches();
    }

    @Override
    public float matchPercent() {
        return (float)this.state().matchPercent();
    }

    private static final Histogram $init$$$anonfun$1() {
        return new TupleHistogram();
    }

    public static final /* synthetic */ void org$broadinstitute$gpp$poolq3$process$ScoringConsumer$$anon$1$$_$run$$anonfun$1(UnexpectedSequenceTracker unexpectedSequenceTracker$1, Tuple2 barcodes) {
        unexpectedSequenceTracker$1.reportUnexpected(barcodes);
    }
}

