/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.process.BarcodeStats;
import scala.Tuple2;

public final class State {
    private final ShardedHistogram known;
    private final Histogram knownCol;
    private final Histogram unknownCol;
    private final Histogram unknownUmi;
    private int reads;
    private int exactMatches;
    private int matches;
    private int neitherRowBarcodeFound;
    private int umiBarcodeNotFound;
    private final BarcodeStats rowBarcodeStats;
    private final BarcodeStats revRowBarcodeStats;

    public State(ShardedHistogram<String, Tuple2<String, String>> known, Histogram<String> knownCol, Histogram<String> unknownCol, Histogram<String> unknownUmi) {
        this.known = known;
        this.knownCol = knownCol;
        this.unknownCol = unknownCol;
        this.unknownUmi = unknownUmi;
        this.reads = 0;
        this.exactMatches = 0;
        this.matches = 0;
        this.neitherRowBarcodeFound = 0;
        this.umiBarcodeNotFound = 0;
        this.rowBarcodeStats = new BarcodeStats();
        this.revRowBarcodeStats = new BarcodeStats();
    }

    public ShardedHistogram<String, Tuple2<String, String>> known() {
        return this.known;
    }

    public Histogram<String> knownCol() {
        return this.knownCol;
    }

    public Histogram<String> unknownCol() {
        return this.unknownCol;
    }

    public Histogram<String> unknownUmi() {
        return this.unknownUmi;
    }

    public int reads() {
        return this.reads;
    }

    public void reads_$eq(int x$1) {
        this.reads = x$1;
    }

    public int exactMatches() {
        return this.exactMatches;
    }

    public void exactMatches_$eq(int x$1) {
        this.exactMatches = x$1;
    }

    public int matches() {
        return this.matches;
    }

    public void matches_$eq(int x$1) {
        this.matches = x$1;
    }

    public int neitherRowBarcodeFound() {
        return this.neitherRowBarcodeFound;
    }

    public void neitherRowBarcodeFound_$eq(int x$1) {
        this.neitherRowBarcodeFound = x$1;
    }

    public int rowBarcodeNotFound() {
        return this.rowBarcodeStats().notFound(this.reads());
    }

    public int revRowBarcodeNotFound() {
        return this.revRowBarcodeStats().notFound(this.reads());
    }

    public int umiBarcodeNotFound() {
        return this.umiBarcodeNotFound;
    }

    public void umiBarcodeNotFound_$eq(int x$1) {
        this.umiBarcodeNotFound = x$1;
    }

    public BarcodeStats rowBarcodeStats() {
        return this.rowBarcodeStats;
    }

    public BarcodeStats revRowBarcodeStats() {
        return this.revRowBarcodeStats;
    }

    public double matchPercent() {
        if (this.reads() < 1) {
            return 0.0;
        }
        return (double)(100L * (long)this.matches()) / (double)this.reads();
    }
}

