/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import cats.Applicative;
import cats.Apply;
import cats.Foldable;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.ApplyOps$;
import cats.syntax.package$all$;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.hist.ReadOnlyHistogram;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.ParsedFilename;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import org.broadinstitute.gpp.poolq3.reports.reports$package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class BarcodeCountsWriter$
implements Serializable {
    public static final BarcodeCountsWriter$ MODULE$ = new BarcodeCountsWriter$();

    private BarcodeCountsWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BarcodeCountsWriter$.class);
    }

    public Try<BoxedUnit> write(Path file, Option<Path> umiFileDir, ShardedHistogram<String, Tuple2<String, String>> hist, Reference rowReference, Reference colReference, Option<BarcodeSet> umiBarcodes, ReportsDialect dialect) {
        Option<BarcodeSet> option = umiBarcodes;
        if (None$.MODULE$.equals(option)) {
            return this.write(file, hist, rowReference, colReference, dialect);
        }
        if (option instanceof Some) {
            BarcodeSet ub = (BarcodeSet)((Some)option).value();
            return this.writeUmi(file, umiFileDir, hist, rowReference, colReference, ub, dialect);
        }
        throw new MatchError(option);
    }

    public Try<BoxedUnit> write(Path barcodeCountsFile, ReadOnlyHistogram<Tuple2<String, String>> hist, Reference rowReference, Reference colReference, ReportsDialect dialect) {
        return Using$.MODULE$.apply(() -> BarcodeCountsWriter$.write$$anonfun$1(barcodeCountsFile), pw -> {
            String colHeadings = ((IterableOnceOps)colReference.allBarcodes().map((Function1<String, String> & Serializable)dnaBarcode -> colReference.referenceBarcodeForDnaBarcode((String)dnaBarcode))).mkString("\t");
            pw.println(reports$package$.MODULE$.countsHeaderText(dialect, colHeadings, rowReference.allBarcodes().size(), colReference.allBarcodes().size()));
            rowReference.allBarcodes().foreach(rowBc -> {
                reports$package$.MODULE$.writeRowIdentifiers(rowReference, (String)rowBc, (PrintWriter)pw);
                Seq columns = (Seq)colReference.allBarcodes().map((Function1<String, int> & Serializable)colBc -> hist.count(Tuple2$.MODULE$.apply(rowBc, colBc)));
                pw.println(columns.mkString("\t"));
            });
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public Try<BoxedUnit> writeUmi(Path barcodeCountsFile, Option<Path> umiFileDirOpt, ShardedHistogram<String, Tuple2<String, String>> hist, Reference rowReference, Reference colReference, BarcodeSet umiBarcodes, ReportsDialect dialect) {
        ParsedFilename parsedFilename = reports$package$.MODULE$.parseFilename(barcodeCountsFile);
        Path umiFileDir = (Path)umiFileDirOpt.getOrElse(() -> BarcodeCountsWriter$.$anonfun$3(barcodeCountsFile));
        String basename = parsedFilename.basename();
        Option<String> extension = parsedFilename.extension();
        Try try_ = (Try)package$all$.MODULE$.catsSyntaxApplyOps(this.write(barcodeCountsFile, hist, rowReference, colReference, dialect));
        Try try_2 = (Try)package$all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(try_, Try$.MODULE$.apply(() -> BarcodeCountsWriter$.writeUmi$$anonfun$1(umiFileDir)), (Apply)((Object)Invariant$.MODULE$.catsInstancesForTry())));
        Try try_3 = (Try)package$all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(try_2, this.write(umiFileDir.resolve(new StringBuilder(14).append(basename).append("-UNMATCHED-UMI").append(extension.getOrElse(BarcodeCountsWriter$::writeUmi$$anonfun$2)).toString()), hist.forShard(None$.MODULE$), rowReference, colReference, dialect), (Apply)((Object)Invariant$.MODULE$.catsInstancesForTry())));
        return (Try)ApplyOps$.MODULE$.$times$greater$extension(try_3, package$all$.MODULE$.toFoldableOps((Object)umiBarcodes.barcodes().toList(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1<String, Try> & Serializable)shard -> MODULE$.write(umiFileDir.resolve(new StringBuilder(1).append(basename).append("-").append((String)shard).append(extension.getOrElse(BarcodeCountsWriter$::writeUmi$$anonfun$3$$anonfun$1)).toString()), hist.forShard(Some$.MODULE$.apply(shard)), rowReference, colReference, dialect), (Applicative)((Object)Invariant$.MODULE$.catsInstancesForTry())), (Apply)((Object)Invariant$.MODULE$.catsInstancesForTry()));
    }

    private static final PrintWriter write$$anonfun$1(Path barcodeCountsFile$1) {
        return new PrintWriter(new FileWriter(barcodeCountsFile$1.toFile()));
    }

    private static final Path $anonfun$3(Path barcodeCountsFile$2) {
        return barcodeCountsFile$2.resolveSibling("umi-barcode-counts");
    }

    private static final Path writeUmi$$anonfun$1(Path umiFileDir$1) {
        return Files.createDirectories(umiFileDir$1, new FileAttribute[0]);
    }

    private static final String writeUmi$$anonfun$2() {
        return "";
    }

    private static final String writeUmi$$anonfun$3$$anonfun$1() {
        return "";
    }
}

