/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibManager;
import gov.nih.nlm.ncbi.ngs.Logger;
import java.io.File;

class LibPathIterator {
    private static final String NCBI_NGS_JAR_NAME = "ngs-java.jar";
    private LibManager mgr;
    private LibManager.Location location;
    private LibManager.Location crnLocation;
    private int iLocation;
    private String[] paths;
    private int iPaths;
    private String separator;
    private String[] filenames;
    private int iFilename;
    private String abspath;
    private boolean parents;

    LibPathIterator(LibManager libManager, String[] stringArray) {
        this(libManager, null, stringArray, false);
    }

    LibPathIterator(LibManager libManager, String[] stringArray, boolean bl) {
        this(libManager, null, stringArray, bl);
    }

    LibPathIterator(LibManager.Location location, String[] stringArray) {
        this(null, location, stringArray, false);
    }

    LibPathIterator(LibManager libManager, LibManager.Location location, String[] stringArray, boolean bl) {
        Logger.finer("Creating LibPathIterator(" + this.toString(stringArray) + ", " + (Object)((Object)location) + ")...");
        if (libManager == null && location == null) {
            throw new NullPointerException();
        }
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.mgr = libManager;
        this.location = location;
        this.filenames = stringArray;
        this.parents = bl;
        this.separator = LibPathIterator.fileSeparator();
        this.reset();
    }

    String nextName() {
        String string2;
        String string3;
        do {
            if (!(this.paths != null && this.iPaths < this.paths.length || this.reset())) {
                return null;
            }
            string3 = this.paths[this.iPaths];
            string2 = null;
            if (this.filenames != null) {
                string2 = this.filenames[this.iFilename];
            }
            if (this.filenames == null) {
                ++this.iPaths;
                continue;
            }
            if (++this.iFilename < this.filenames.length) continue;
            this.iFilename = 0;
            ++this.iPaths;
        } while (string3.length() == 0);
        LibManager.Location location = this.location;
        if (location == null) {
            location = this.crnLocation;
        }
        if (this.separator == null) {
            throw new NullPointerException();
        }
        string3 = string3 + this.separator + string2;
        return string3;
    }

    static boolean list(String string2) {
        return LibPathIterator.iterate(new LibManager(new String[0], new String[0]), string2, false);
    }

    static boolean deleteLibraries(LibManager libManager, String string2) {
        return LibPathIterator.iterate(libManager, string2, true);
    }

    private boolean reset() {
        if (this.location != null) {
            if (this.crnLocation != null) {
                return false;
            }
            this.crnLocation = this.location;
        } else if (this.crnLocation == null) {
            this.iLocation = -1;
        }
        block8: while (true) {
            ++this.iLocation;
            Logger.finest("LibPathIterator.reset() " + this.iLocation);
            if (this.location == null) {
                if (this.iLocation >= this.mgr.locations().length) {
                    return false;
                }
                this.crnLocation = this.mgr.locations()[this.iLocation];
                Logger.finest("LibPathIterator.reset(" + (Object)((Object)this.crnLocation) + ")");
            } else if (this.iLocation > 1) {
                return false;
            }
            this.iPaths = 0;
            String string2 = LibPathIterator.pathSeparator();
            String string3 = null;
            switch (this.crnLocation) {
                case CLASSPATH: {
                    string3 = System.getProperty("java.class.path");
                    Logger.finest("java.class.path = " + string3);
                    if (!this.resetPaths(string3, string2)) continue block8;
                    return true;
                }
                case CWD: {
                    if (!this.resetPaths(System.getProperty("user.dir"), string2)) continue block8;
                    return true;
                }
                case LIBPATH: {
                    string3 = System.getProperty("java.library.path");
                    Logger.finest("java.library.path = " + string3);
                    if (!this.resetPaths(string3, string2)) continue block8;
                    return true;
                }
                case NCBI_HOME: {
                    if (!this.resetPaths(this.ncbiLibHome())) continue block8;
                    return true;
                }
                case NCBI_NGS_JAR_DIR: {
                    string3 = this.findJarDir(string2);
                    if (string3 == null) {
                        Logger.finest("ngs-java.jar was not found");
                        continue block8;
                    }
                    Logger.finest("jar directory is " + string3);
                    this.resetPaths(string3);
                    return true;
                }
                case TMP: {
                    string3 = this.findTmpDirEnv();
                    if (string3 != null) {
                        Logger.fine("Use " + string3 + " as temporary directory");
                        this.resetPaths(string3);
                        return true;
                    }
                    Logger.finest("Temporary directory was not found in environment");
                    if (this.resetPathsToTmpDirs()) {
                        Logger.finest("Found a temporary directory");
                        return true;
                    }
                    Logger.fine("Could not find any temporary directory");
                    continue block8;
                }
            }
        }
    }

    private String findJarDir(String string2) {
        String string3 = System.getProperty("java.class.path");
        Logger.finest("java.class.path = " + string3);
        if (string3 == null) {
            return null;
        }
        String[] stringArray = string3.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            Logger.finest("findJarDir() " + i + " " + stringArray[i]);
            if (!stringArray[i].endsWith(NCBI_NGS_JAR_NAME)) continue;
            File file = new File(stringArray[i]);
            if (!file.exists()) {
                System.err.println("ngs-java.jar from class path does not exist");
                continue;
            }
            Logger.finest("Found NCBI jar file: " + stringArray[i]);
            String string5 = null;
            if (NCBI_NGS_JAR_NAME.equals(stringArray[i])) {
                string5 = System.getProperty("user.dir");
                if (string5 == null) {
                    System.err.println("cannot get directory for ngs-java.jar");
                    continue;
                }
            } else {
                string5 = stringArray[i].substring(0, stringArray[i].length() - NCBI_NGS_JAR_NAME.length());
            }
            if ((string4 = LibPathIterator.fileSeparator()) != null && string4.length() == 1 && string5.length() > 0 && string5.charAt(string5.length() - 1) == string4.charAt(0)) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            return string5;
        }
        return null;
    }

    private String findTmpDirEnv() {
        String string2 = "TMPDIR";
        String string3 = System.getenv(string2);
        if (string3 != null) {
            Logger.finest(string2 + " = " + string3);
            return string3;
        }
        string2 = "TEMP";
        string3 = System.getenv(string2);
        if (string3 != null) {
            Logger.finest(string2 + " = " + string3);
            return string3;
        }
        string2 = "TMP";
        string3 = System.getenv(string2);
        if (string3 != null) {
            Logger.finest(string2 + " = " + string3);
            return string3;
        }
        string2 = "TEMPDIR";
        string3 = System.getenv(string2);
        if (string3 != null) {
            Logger.finest(string2 + " = " + string3);
            return string3;
        }
        return null;
    }

    private boolean resetPathsToTmpDirs() {
        int n = 0;
        String string2 = "/var/tmp";
        File file = new File(string2);
        if (file.exists()) {
            ++n;
        } else {
            file = null;
        }
        String string3 = "/tmp";
        File file2 = new File(string3);
        if (file2.exists()) {
            ++n;
        } else {
            file2 = null;
        }
        if (n == 0) {
            return false;
        }
        if (this.paths == null || this.paths.length != n) {
            this.paths = new String[n];
        }
        int n2 = 0;
        if (file != null) {
            this.paths[n2++] = string2;
        }
        if (file2 != null) {
            this.paths[n2++] = string3;
        }
        return true;
    }

    private boolean resetPaths(String string2) {
        return this.resetPaths(string2, null);
    }

    private boolean resetPaths(String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        if (string3 != null) {
            this.paths = string2.split(string3);
            if (this.crnLocation == LibManager.Location.CLASSPATH) {
                for (int i = 0; i < this.paths.length; ++i) {
                    File file = new File(this.paths[i]);
                    if (!file.isFile()) continue;
                    String string4 = file.getParent();
                    if (string4 == null) {
                        string4 = System.getProperty("user.dir");
                    }
                    if (string4 == null) {
                        System.err.println("cannot get parent directory for " + this.paths[i]);
                        this.paths[i] = ".";
                        continue;
                    }
                    this.paths[i] = string4;
                }
            }
        } else {
            if (this.paths == null || this.paths.length != 1) {
                this.paths = new String[1];
            }
            this.paths[0] = string2;
        }
        return true;
    }

    private boolean mkdir(String string2, boolean bl) {
        File file = new File(string2);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
                return false;
            }
            if (bl) {
                try {
                    file.setExecutable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
                try {
                    file.setReadable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
                try {
                    file.setWritable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
            }
            try {
                file.setExecutable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
            try {
                file.setReadable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
            try {
                file.setWritable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
        }
        return true;
    }

    static String ncbiHome() {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return null;
        }
        return string2 + LibPathIterator.fileSeparator() + ".ncbi";
    }

    private String ncbiLibHome() {
        String string2 = LibPathIterator.ncbiHome();
        if (string2 == null) {
            return null;
        }
        if (this.parents && !this.mkdir(string2, true)) {
            return null;
        }
        string2 = string2 + LibPathIterator.fileSeparator() + "lib";
        switch (LibManager.detectJVM()) {
            case b64: {
                string2 = string2 + "64";
                break;
            }
            case b32: {
                string2 = string2 + "32";
            }
        }
        if (this.parents && !this.mkdir(string2, false)) {
            return null;
        }
        return string2;
    }

    private static String pathSeparator() {
        String string2;
        String string3 = System.getProperty("path.separator");
        if (string3 == null && (string2 = System.getProperty("os.name")) != null && string2.indexOf("win") >= 0) {
            string3 = ";";
        }
        if (string3 == null) {
            string3 = ":";
        }
        return string3;
    }

    private String toString(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        String string2 = "[";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[i];
        }
        string2 = string2 + "]";
        return string2;
    }

    static String fileSeparator() {
        String string2;
        String string3 = System.getProperty("file.separator");
        if (string3 == null && (string2 = System.getProperty("os.name")) != null && string2.indexOf("win") >= 0) {
            string3 = "\\";
        }
        if (string3 == null) {
            string3 = "/";
        }
        return string3;
    }

    private static boolean iterate(LibManager libManager, String string2, boolean bl) {
        boolean bl2 = !bl;
        LibPathIterator libPathIterator = new LibPathIterator(libManager, LibManager.mapLibraryName(string2));
        String string3 = null;
        int n = 0;
        while ((string3 = libPathIterator.nextName()) != null) {
            File file = new File(string3);
            boolean bl3 = file.exists();
            System.err.println("(" + ++n + ") " + string3 + " " + (bl3 ? "+" : "-"));
            if (!bl || !bl3) continue;
            try {
                bl3 = file.delete();
                if (bl3) {
                    bl2 = bl3;
                    continue;
                }
                System.err.println("Cannot delete '" + string3 + "'");
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot delete '" + string3 + "': " + securityException);
            }
        }
        return bl2;
    }
}

