/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Manager;
import gov.nih.nlm.ncbi.ngs.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ngs.ErrorMsg;
import ngs.Package;

class LibVersionChecker {
    LibVersionChecker() {
    }

    static Version getVersion(String string2, String string3, boolean bl) {
        String string4;
        Vector<String> vector = new Vector<String>();
        String string5 = System.getProperty("java.home");
        if (string5 != null) {
            vector.add(string5 + LibPathIterator.fileSeparator() + "bin" + LibPathIterator.fileSeparator() + "java");
            if (!LibVersionChecker.tryJava(vector)) {
                vector.remove(0);
            }
        }
        if (vector.size() == 0) {
            vector.add("java");
            if (!LibVersionChecker.tryJava(vector)) {
                throw new RuntimeException("Failed to check library " + string3 + " version: failed to execute java");
            }
        }
        if ((string4 = System.getProperty("java.class.path")) != null) {
            vector.add("-cp");
            vector.add(string4);
        }
        vector.add(LibVersionChecker.createPropertyString("java.library.path"));
        if (System.getProperty("vdb.log") != null) {
            vector.add(LibVersionChecker.createPropertyString("vdb.log"));
        }
        vector.add("gov.nih.nlm.ncbi.ngs.LibVersionChecker");
        vector.add(string2);
        vector.add(string3);
        if (bl) {
            vector.add("true");
        }
        Logger.finer(">>> RUNNING CHILD ...");
        String string6 = null;
        try {
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = vector.elementAt(i);
            }
            Logger.finest(stringArray);
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string7 = null;
            while ((string7 = bufferedReader2.readLine()) != null) {
                System.err.println(string7);
            }
            bufferedReader2.close();
            while ((string7 = bufferedReader.readLine()) != null) {
                Pattern pattern = Pattern.compile("^LibManager: version='(.*)'$");
                Matcher matcher = pattern.matcher(string7);
                while (matcher.find() && (string6 = matcher.group(1)) == null) {
                }
                if (string6 != null) continue;
                System.out.println(string7);
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            Logger.finest(exception);
        }
        Logger.finer("<<< Done CHILD");
        if (string6 != null) {
            return new Version(string6);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        LibVersionChecker libVersionChecker = new LibVersionChecker();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RuntimeException("Not enough arguments: should be 2 or 3");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        boolean bl = stringArray.length == 3 && stringArray[2].equals("true");
        String string4 = libVersionChecker.checkLib(string2, string3, bl);
        if (string4 != null) {
            System.out.println("LibManager: version='" + string4 + "'");
        }
    }

    private String checkLib(String string2, String string3, boolean bl) {
        Logger.finest("> Checking the version of " + string3 + " library...");
        Logger.finest(">> Loading the library...");
        boolean bl2 = false;
        try {
            if (bl) {
                System.loadLibrary(string3);
            } else {
                System.load(string3);
            }
            bl2 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.finest("<< Failed to load library " + string3);
            Logger.finest(unsatisfiedLinkError);
        }
        String string4 = null;
        if (bl2) {
            Logger.finest(">> Checking current version of the library...");
            string4 = LibVersionChecker.getLoadedVersion(string2);
            Logger.finest("<< The current version of " + string3 + " = " + string4);
        }
        Logger.finest("< Done checking version of the library");
        return string4;
    }

    static String getLoadedVersion(String string2) {
        try {
            if (string2.equals("ncbi-vdb")) {
                return Manager.getPackageVersion();
            }
            if (string2.equals("ngs-sdk")) {
                return Package.getPackageVersion();
            }
            Logger.warning("It is not known how to check the version of " + string2 + " library");
            return null;
        }
        catch (ErrorMsg errorMsg) {
            Logger.finest(errorMsg);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.finest(unsatisfiedLinkError);
        }
        return null;
    }

    private static boolean tryJava(Vector<String> vector) {
        try {
            Process process = Runtime.getRuntime().exec(vector.elementAt(0) + " -?");
            if (process.waitFor() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String createPropertyString(String string2) {
        String string3 = System.getProperty(string2);
        if (string3 == null) {
            throw new RuntimeException("Property " + string2 + " is not defined");
        }
        return "-D" + string2 + "=" + string3 + "";
    }
}

