/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.cram;

import htsjdk.beta.codecs.hapref.fasta.FASTADecoderV1_0;
import htsjdk.beta.exception.HtsjdkException;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsCodec;
import htsjdk.beta.plugin.registry.HtsDefaultRegistry;
import htsjdk.io.IOPath;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class CRAMCodec
implements ReadsCodec {
    protected static final Set<String> extensionMap = new HashSet<String>(Arrays.asList(".cram"));

    @Override
    public String getFileFormat() {
        return "CRAM";
    }

    @Override
    public boolean canDecodeURI(IOPath ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        return extensionMap.stream().anyMatch(ext -> ioPath.hasExtension((String)ext));
    }

    @Override
    public boolean canDecodeSignature(SignatureStream signatureStream, String sourceName) {
        ValidationUtils.nonNull(signatureStream, "signatureStream");
        ValidationUtils.nonNull(sourceName, "sourceName");
        try {
            byte[] signatureBytes = new byte[this.getSignatureLength()];
            int numRead = signatureStream.read(signatureBytes);
            if (numRead < this.getSignatureLength()) {
                throw new HtsjdkIOException(String.format("Failure reading content from stream for %s", sourceName));
            }
            return Arrays.equals(signatureBytes, this.getSignatureString().getBytes());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure reading content from stream for %s", sourceName));
        }
    }

    @Override
    public boolean runVersionUpgrade(HtsVersion sourceCodecVersion, HtsVersion targetCodecVersion) {
        throw new HtsjdkUnsupportedOperationException("Version upgrade not implemented");
    }

    static CRAMReferenceSource getCRAMReferenceSource(IOPath referencePath) {
        ValidationUtils.nonNull(referencePath, "referencePath");
        FASTADecoderV1_0 fastaDecoder = (FASTADecoderV1_0)HtsDefaultRegistry.getHaploidReferenceResolver().getHaploidReferenceDecoder(referencePath);
        if (fastaDecoder == null) {
            throw new HtsjdkException(String.format("Unable to get reference codec for %s", referencePath));
        }
        ReferenceSequenceFile refSeqFile = fastaDecoder.getReferenceSequenceFile();
        return new ReferenceSource(refSeqFile);
    }

    protected abstract String getSignatureString();
}

