/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin;

import htsjdk.utils.ValidationUtils;

public class HtsVersion
implements Comparable<HtsVersion> {
    public static final HtsVersion NEWEST_VERSION = new HtsVersion(-1, -1, -1);
    private static final String FORMAT_STRING = "%d.%d.%d";
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;

    public HtsVersion(int major, int minor, int patch) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.patchVersion = patch;
    }

    public HtsVersion(String versionString) {
        ValidationUtils.nonNull(versionString);
        String[] parts = versionString.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Unable parse version string as major.minor.patch: '%s'", versionString));
        }
        try {
            this.majorVersion = Integer.parseInt(parts[0]);
            this.minorVersion = Integer.parseInt(parts[1]);
            this.patchVersion = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Can't parse version string: '%s'", versionString));
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HtsVersion)) {
            return false;
        }
        HtsVersion codecVersion = (HtsVersion)o;
        if (this.getMajorVersion() != codecVersion.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != codecVersion.getMinorVersion()) {
            return false;
        }
        return this.getPatchVersion() == codecVersion.getPatchVersion();
    }

    public int hashCode() {
        int result = this.getMajorVersion();
        result = 31 * result + this.getMinorVersion();
        result = 31 * result + this.getPatchVersion();
        return result;
    }

    public String toString() {
        return String.format(FORMAT_STRING, this.getMajorVersion(), this.getMinorVersion(), this.getPatchVersion());
    }

    @Override
    public int compareTo(HtsVersion o) {
        ValidationUtils.nonNull(o);
        if (this.majorVersion == o.majorVersion) {
            if (this.minorVersion == o.minorVersion) {
                if (this.patchVersion == o.patchVersion) {
                    return 0;
                }
                return this.patchVersion - o.patchVersion;
            }
            return this.minorVersion - o.minorVersion;
        }
        return this.majorVersion - o.majorVersion;
    }
}

