/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.htsget;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.htsget.HtsgetClass;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetRequest;
import htsjdk.samtools.util.htsget.HtsgetRequestField;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mjson.Json;

public class HtsgetPOSTRequest
extends HtsgetRequest {
    private final List<Locatable> intervals;

    public HtsgetPOSTRequest(URI endpoint) {
        super(endpoint);
        this.intervals = new ArrayList<Locatable>();
    }

    public HtsgetPOSTRequest(HtsgetRequest req) {
        super(req.getEndpoint());
        this.setFormat(req.getFormat());
        this.setDataClass(req.getDataClass());
        this.addFields(req.getFields());
        this.addTags(req.getTags());
        this.addNotags(req.getNoTags());
        this.intervals = new ArrayList<Locatable>();
        if (req.getInterval() != null) {
            this.intervals.add(req.getInterval());
        }
    }

    @Override
    public void setInterval(Locatable interval) {
        this.intervals.clear();
        this.intervals.add(interval);
    }

    public void addInterval(Locatable interval) {
        this.intervals.add(interval);
    }

    public void addIntervals(Collection<Locatable> intervals) {
        this.intervals.addAll(intervals);
    }

    @Override
    public HtsgetPOSTRequest withFormat(HtsgetFormat format) {
        this.format = format;
        return this;
    }

    @Override
    public HtsgetPOSTRequest withDataClass(HtsgetClass dataClass) {
        this.dataClass = dataClass;
        return this;
    }

    @Override
    public HtsgetPOSTRequest withInterval(Locatable interval) {
        this.intervals.add(interval);
        return this;
    }

    public HtsgetPOSTRequest withIntervals(Collection<Locatable> intervals) {
        this.intervals.addAll(intervals);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withField(HtsgetRequestField field2) {
        this.fields.add(field2);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withFields(Collection<HtsgetRequestField> fields) {
        this.fields.addAll(fields);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withTags(Collection<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withNotag(String notag) {
        this.notags.add(notag);
        return this;
    }

    @Override
    public HtsgetPOSTRequest withNotags(Collection<String> notags) {
        this.notags.addAll(notags);
        return this;
    }

    @Override
    public void validateRequest() {
        super.validateRequest();
        if (this.getDataClass() != null && this.getDataClass() == HtsgetClass.header && !this.intervals.isEmpty()) {
            throw new IllegalArgumentException("Invalid request: intervals cannot be specified when class=header");
        }
    }

    @Override
    public URI toURI() {
        return this.getEndpoint();
    }

    public Json queryBody() {
        Json postBody = Json.object();
        if (this.format != null) {
            postBody.set("format", (Object)this.getFormat().toString());
        }
        if (this.dataClass != null) {
            postBody.set("class", (Object)this.getDataClass().toString());
        }
        if (!this.fields.isEmpty()) {
            postBody.set("fields", Json.array(this.getFields().stream().map(Enum::toString).toArray()));
        }
        if (!this.tags.isEmpty()) {
            postBody.set("tags", Json.array(this.getTags().toArray()));
        }
        if (!this.notags.isEmpty()) {
            postBody.set("notags", Json.array(this.getNoTags().toArray()));
        }
        if (!this.intervals.isEmpty()) {
            postBody.set("regions", Json.array(this.intervals.stream().map(interval -> {
                Json intervalJson = Json.object();
                if (interval != null && interval.getContig() != null) {
                    intervalJson.set("referenceName", (Object)interval.getContig());
                    if (!interval.getContig().equals("*")) {
                        intervalJson.set("start", (Object)(interval.getStart() - 1));
                        if (interval.getEnd() != Integer.MAX_VALUE && interval.getEnd() != -1) {
                            intervalJson.set("end", (Object)interval.getEnd());
                        }
                    }
                }
                return intervalJson;
            }).toArray()));
        }
        return postBody;
    }

    @Override
    protected HttpURLConnection getConnection() {
        URI reqURI = this.getEndpoint();
        try {
            HttpURLConnection conn = (HttpURLConnection)reqURI.toURL().openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/vnd.ga4gh.htsget.v1.2.0+json");
            conn.setDoOutput(true);
            byte[] query = this.queryBody().toString().getBytes();
            conn.setRequestProperty("Content-Length", Integer.toString(query.length));
            conn.connect();
            conn.getOutputStream().write(query);
            return conn;
        }
        catch (IOException e) {
            throw new RuntimeIOException("IOException while attempting htsget download, request: " + reqURI, e);
        }
    }
}

