/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode$;
import org.broadinstitute.gpp.poolq3.barcode.GeneralTemplatePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask;
import org.broadinstitute.gpp.poolq3.barcode.KeyRange;
import org.broadinstitute.gpp.poolq3.barcode.TemplatePolicy;
import org.broadinstitute.gpp.poolq3.barcode.TemplatePolicy$;
import org.broadinstitute.gpp.poolq3.types.Read;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class GeneralTemplatePolicy
implements Product,
TemplatePolicy {
    private final KeyMask template;
    private final Option minStartPos;
    private final Option maxStartPos;
    private final int minStartPosInt;
    private final int maxStartPosInt;
    private final int firstKeyBaseOffset;
    private final char[] templateChars;
    private final int contextLength;
    private final int keyLength;
    private final int length;

    public static GeneralTemplatePolicy apply(KeyMask keyMask, Option<Object> option, Option<Object> option2) {
        return GeneralTemplatePolicy$.MODULE$.apply(keyMask, option, option2);
    }

    public static GeneralTemplatePolicy fromProduct(Product product) {
        return GeneralTemplatePolicy$.MODULE$.fromProduct(product);
    }

    public static GeneralTemplatePolicy unapply(GeneralTemplatePolicy generalTemplatePolicy) {
        return GeneralTemplatePolicy$.MODULE$.unapply(generalTemplatePolicy);
    }

    public static Option<Object> $lessinit$greater$default$3() {
        return GeneralTemplatePolicy$.MODULE$.$lessinit$greater$default$3();
    }

    public GeneralTemplatePolicy(KeyMask template, Option<Object> minStartPos, Option<Object> maxStartPos) {
        this.template = template;
        this.minStartPos = minStartPos;
        this.maxStartPos = maxStartPos;
        this.minStartPosInt = BoxesRunTime.unboxToInt(minStartPos.getOrElse(GeneralTemplatePolicy::$init$$$anonfun$5));
        this.maxStartPosInt = BoxesRunTime.unboxToInt(maxStartPos.getOrElse(GeneralTemplatePolicy::$init$$$anonfun$6));
        this.firstKeyBaseOffset = ((KeyRange)template.keyRanges().head()).start0();
        this.templateChars = template.pattern().toUpperCase().toCharArray();
        this.contextLength = template.contextLength();
        this.length = this.keyLength = template.keyLengthInBases();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GeneralTemplatePolicy)) return false;
        GeneralTemplatePolicy generalTemplatePolicy = (GeneralTemplatePolicy)object;
        KeyMask keyMask = this.template();
        KeyMask keyMask2 = generalTemplatePolicy.template();
        if (keyMask == null) {
            if (keyMask2 != null) {
                return false;
            }
        } else if (!keyMask.equals(keyMask2)) return false;
        Option<Object> option = this.minStartPos();
        Option<Object> option2 = generalTemplatePolicy.minStartPos();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxStartPos();
        Option<Object> option4 = generalTemplatePolicy.maxStartPos();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof GeneralTemplatePolicy;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "GeneralTemplatePolicy";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "template";
            }
            case 1: {
                return "minStartPos";
            }
            case 2: {
                return "maxStartPos";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public KeyMask template() {
        return this.template;
    }

    public Option<Object> minStartPos() {
        return this.minStartPos;
    }

    public Option<Object> maxStartPos() {
        return this.maxStartPos;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Option<FoundBarcode> find(Read read) {
        int maxPos = package$.MODULE$.min(read.seq().length() - this.contextLength, this.maxStartPosInt);
        return this.find$1(maxPos, read, this.minStartPosInt).map((Function1<Object, FoundBarcode> & Serializable)i -> this.find$$anonfun$2(read, BoxesRunTime.unboxToInt(i)));
    }

    public FoundBarcode extract(Read read, int i) {
        char[] keyBuf = new char[this.keyLength];
        IntRef offset = IntRef.create(0);
        this.template().keyRanges().foreach(kr -> {
            read.seq().getChars(kr.start0() + i, kr.start0() + i + kr.length(), keyBuf, offset$1.elem);
            offset$1.elem += kr.length();
        });
        return FoundBarcode$.MODULE$.apply(keyBuf, this.firstKeyBaseOffset + i);
    }

    public GeneralTemplatePolicy copy(KeyMask template, Option<Object> minStartPos, Option<Object> maxStartPos) {
        return new GeneralTemplatePolicy(template, minStartPos, maxStartPos);
    }

    public KeyMask copy$default$1() {
        return this.template();
    }

    public Option<Object> copy$default$2() {
        return this.minStartPos();
    }

    public Option<Object> copy$default$3() {
        return this.maxStartPos();
    }

    public KeyMask _1() {
        return this.template();
    }

    public Option<Object> _2() {
        return this.minStartPos();
    }

    public Option<Object> _3() {
        return this.maxStartPos();
    }

    private static final int $init$$$anonfun$5() {
        return 0;
    }

    private static final int $init$$$anonfun$6() {
        return Integer.MAX_VALUE;
    }

    private final Option find$1(int maxPos$1, Read read$2, int i) {
        while (i <= maxPos$1) {
            if (TemplatePolicy$.MODULE$.satisfies(this.templateChars, read$2.seq(), i)) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(i));
            }
            ++i;
        }
        return None$.MODULE$;
    }

    private final /* synthetic */ FoundBarcode find$$anonfun$2(Read read$3, int i) {
        return this.extract(read$3, i);
    }
}

