/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import org.broadinstitute.gpp.poolq3.types.PoolQRunSummary;
import org.broadinstitute.gpp.poolq3.types.PoolQRunSummary$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.util.control.NonFatal$;

public final class PoolQProcess {
    private final Iterator<Barcodes> source;
    public final Consumer org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer;
    public final int org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency;
    public final Logger org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
    public final ArrayBlockingQueue<Barcodes> org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue;
    public volatile boolean org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done;

    public static int $lessinit$greater$default$3() {
        return PoolQProcess$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return PoolQProcess$.MODULE$.$lessinit$greater$default$4();
    }

    public PoolQProcess(Iterator<Barcodes> source, Consumer consumer, int queueSize, int reportFrequency) {
        this.source = source;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer = consumer;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency = reportFrequency;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.process.PoolQProcess");
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue = new ArrayBlockingQueue(queueSize);
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done = false;
    }

    public PoolQRunSummary run() {
        ConsumerThread consumerThread = new ConsumerThread();
        consumerThread.setName("Consumer");
        Logger Logger_this = this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Beginning task processing.");
        }
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.start();
        consumerThread.start();
        this.source.foreach(x$0 -> this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.put((Barcodes)x$0));
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done = true;
        Logger Logger_this2 = this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
        if (Logger_this2.isInfoEnabled()) {
            Logger_this2.info("Shutting down.");
        }
        consumerThread.join();
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.close();
        return PoolQRunSummary$.MODULE$.apply(this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed(), this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchingReads(), this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchPercent(), this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.state());
    }

    public final class ConsumerThread
    extends Thread {
        public ConsumerThread() {
            if (PoolQProcess.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void run() {
            long t0 = System.currentTimeMillis();
            while (!PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done || !PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.isEmpty()) {
                long n;
                try {
                    Option$.MODULE$.apply(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.poll(100L, TimeUnit.MILLISECONDS)).foreach(next -> PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.consume((Barcodes)next));
                }
                catch (InterruptedException interruptedException) {
                    Logger Logger_this = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
                    if (Logger_this.isWarnEnabled()) {
                        Logger_this.warn(new StringBuilder(59).append("Interrupted. Done = ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done).append(" Processed ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()).append(" reads; queue has ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.size()).append(" remaining").toString());
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = option.get();
                        Logger Logger_this = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
                        if (Logger_this.isErrorEnabled()) {
                            Logger_this.error(new StringBuilder(22).append("Error processing read ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()).toString(), e);
                        }
                    }
                    throw throwable;
                }
                if ((n = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()) % (long)PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency != 0L) continue;
                this.logProgress$1(t0, n);
            }
            this.logProgress$1(t0, PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed());
        }

        public final /* synthetic */ PoolQProcess org$broadinstitute$gpp$poolq3$process$PoolQProcess$ConsumerThread$$$outer() {
            return PoolQProcess.this;
        }

        private final void logProgress$1(long t0$1, long n) {
            float nd = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed();
            long dt = System.currentTimeMillis() - t0$1;
            float avg = nd / (float)dt;
            float pct = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchPercent();
            Logger Logger_this = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info(new StringBuilder(66).append("Processed ").append(n).append(" reads in ").append(dt).append(" ms (").append(avg).append(" reads/ms). Match percent: ").append(pct).append("; queue size: ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.size()).toString());
                return;
            }
        }
    }
}

