/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.utils.ValidationUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class Bundle
implements Iterable<BundleResource>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, BundleResource> resources = new LinkedHashMap<String, BundleResource>();
    private final String primaryContentType;

    public Bundle(String primaryContentType, Collection<BundleResource> resources) {
        ValidationUtils.nonNull(primaryContentType, "primary content type");
        ValidationUtils.validateArg(primaryContentType.length() > 0, "A non-zero length primary resource content type must be provided");
        ValidationUtils.nonNull(resources, "resource collection");
        ValidationUtils.nonEmpty(resources, "resource collection");
        resources.forEach(r -> {
            if (null != this.resources.putIfAbsent(r.getContentType(), (BundleResource)r)) {
                throw new IllegalArgumentException(String.format("Attempt to add a duplicate resource for bundle key: %s", r.getContentType()));
            }
        });
        this.primaryContentType = primaryContentType;
        if (!this.resources.containsKey(primaryContentType)) {
            throw new IllegalArgumentException(String.format("Primary resource content type %s is not present in the bundle's resources", primaryContentType));
        }
    }

    public Optional<BundleResource> get(String targetContentType) {
        ValidationUtils.nonNull(targetContentType, "target content string");
        return Optional.ofNullable(this.resources.get(targetContentType));
    }

    public BundleResource getOrThrow(String requiredContentType) {
        ValidationUtils.nonNull(requiredContentType, "target content string");
        return this.get(requiredContentType).orElseThrow(() -> new IllegalArgumentException(String.format("No resource found in bundle %s with content type %s", this, requiredContentType)));
    }

    public String getPrimaryContentType() {
        return this.primaryContentType;
    }

    public BundleResource getPrimaryResource() {
        return this.resources.get(this.primaryContentType);
    }

    public Collection<BundleResource> getResources() {
        return this.resources.values();
    }

    @Override
    public Iterator<BundleResource> iterator() {
        return this.resources.values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle that = (Bundle)o;
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        return this.primaryContentType.equals(that.primaryContentType);
    }

    public int hashCode() {
        int result = this.resources.hashCode();
        result = 31 * result + this.primaryContentType.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s/%d resource(s)", this.primaryContentType, this.resources.size());
    }
}

