/*
 * Decompiled with CFR 0.152.
 */
package ngs.itf;

import ngs.Alignment;
import ngs.AlignmentIterator;
import ngs.ErrorMsg;
import ngs.PileupIterator;
import ngs.Reference;
import ngs.itf.AlignmentIteratorItf;
import ngs.itf.AlignmentItf;
import ngs.itf.PileupIteratorItf;
import ngs.itf.Refcount;

class ReferenceItf
extends Refcount
implements Reference {
    @Override
    public String getCommonName() throws ErrorMsg {
        return this.GetCommonName(this.self);
    }

    @Override
    public String getCanonicalName() throws ErrorMsg {
        return this.GetCanonicalName(this.self);
    }

    @Override
    public boolean getIsCircular() throws ErrorMsg {
        return this.GetIsCircular(this.self);
    }

    @Override
    public long getLength() throws ErrorMsg {
        return this.GetLength(this.self);
    }

    @Override
    public String getReferenceBases(long l) throws ErrorMsg {
        return this.getReferenceBases(l, -1L);
    }

    @Override
    public String getReferenceBases(long l, long l2) throws ErrorMsg {
        return this.GetReferenceBases(this.self, l, l2);
    }

    @Override
    public String getReferenceChunk(long l) throws ErrorMsg {
        return this.getReferenceChunk(l, -1L);
    }

    @Override
    public String getReferenceChunk(long l, long l2) throws ErrorMsg {
        return this.GetReferenceChunk(this.self, l, l2);
    }

    @Override
    public long getAlignmentCount() throws ErrorMsg {
        return this.GetAlignmentCount(this.self, 3);
    }

    @Override
    public long getAlignmentCount(int n) throws ErrorMsg {
        return this.GetAlignmentCount(this.self, n);
    }

    @Override
    public Alignment getAlignment(String string2) throws ErrorMsg {
        long l = this.GetAlignment(this.self, string2);
        try {
            return new AlignmentItf(l);
        }
        catch (Exception exception) {
            ReferenceItf.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public AlignmentIterator getAlignments(int n) throws ErrorMsg {
        long l = this.GetAlignments(this.self, n);
        try {
            return new AlignmentIteratorItf(l);
        }
        catch (Exception exception) {
            ReferenceItf.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public AlignmentIterator getAlignmentSlice(long l, long l2) throws ErrorMsg {
        return this.getAlignmentSlice(l, l2, 3);
    }

    @Override
    public AlignmentIterator getAlignmentSlice(long l, long l2, int n) throws ErrorMsg {
        long l3 = this.GetAlignmentSlice(this.self, l, l2, n);
        try {
            return new AlignmentIteratorItf(l3);
        }
        catch (Exception exception) {
            ReferenceItf.release(l3);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public AlignmentIterator getFilteredAlignmentSlice(long l, long l2, int n, int n2, int n3) throws ErrorMsg {
        long l3 = this.GetFilteredAlignmentSlice(this.self, l, l2, n, n2, n3);
        try {
            return new AlignmentIteratorItf(l3);
        }
        catch (Exception exception) {
            ReferenceItf.release(l3);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public PileupIterator getPileups(int n) throws ErrorMsg {
        long l = this.GetPileups(this.self, n);
        try {
            return new PileupIteratorItf(l);
        }
        catch (Exception exception) {
            ReferenceItf.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public PileupIterator getFilteredPileups(int n, int n2, int n3) throws ErrorMsg {
        long l = this.GetFilteredPileups(this.self, n, n2, n3);
        try {
            return new PileupIteratorItf(l);
        }
        catch (Exception exception) {
            ReferenceItf.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public PileupIterator getPileupSlice(long l, long l2) throws ErrorMsg {
        return this.getPileupSlice(l, l2, 3);
    }

    @Override
    public PileupIterator getPileupSlice(long l, long l2, int n) throws ErrorMsg {
        long l3 = this.GetPileupSlice(this.self, l, l2, n);
        try {
            return new PileupIteratorItf(l3);
        }
        catch (Exception exception) {
            ReferenceItf.release(l3);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public PileupIterator getFilteredPileupSlice(long l, long l2, int n, int n2, int n3) throws ErrorMsg {
        long l3 = this.GetFilteredPileupSlice(this.self, l, l2, n, n2, n3);
        try {
            return new PileupIteratorItf(l3);
        }
        catch (Exception exception) {
            ReferenceItf.release(l3);
            throw new ErrorMsg(exception.toString());
        }
    }

    ReferenceItf(long l) {
        super(l);
    }

    ReferenceItf(Reference reference) throws ErrorMsg {
        super(0L);
        try {
            ReferenceItf referenceItf = (ReferenceItf)reference;
            this.self = referenceItf.duplicate();
        }
        catch (Exception exception) {
            throw new ErrorMsg(exception.toString());
        }
    }

    private native String GetCommonName(long var1) throws ErrorMsg;

    private native String GetCanonicalName(long var1) throws ErrorMsg;

    private native boolean GetIsCircular(long var1) throws ErrorMsg;

    private native long GetLength(long var1) throws ErrorMsg;

    private native String GetReferenceBases(long var1, long var3, long var5) throws ErrorMsg;

    private native String GetReferenceChunk(long var1, long var3, long var5) throws ErrorMsg;

    private native long GetAlignmentCount(long var1, int var3) throws ErrorMsg;

    private native long GetAlignment(long var1, String var3) throws ErrorMsg;

    private native long GetAlignments(long var1, int var3) throws ErrorMsg;

    private native long GetAlignmentSlice(long var1, long var3, long var5, int var7) throws ErrorMsg;

    private native long GetFilteredAlignmentSlice(long var1, long var3, long var5, int var7, int var8, int var9) throws ErrorMsg;

    private native long GetPileups(long var1, int var3) throws ErrorMsg;

    private native long GetFilteredPileups(long var1, int var3, int var4, int var5) throws ErrorMsg;

    private native long GetPileupSlice(long var1, long var3, long var5, int var7) throws ErrorMsg;

    private native long GetFilteredPileupSlice(long var1, long var3, long var5, int var7, int var8, int var9) throws ErrorMsg;
}

