/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.StringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnifiedJEXL {
    private final JexlEngine jexl;
    private final JexlEngine.SoftCache<String, Expression> cache;
    private static final int CACHE_SIZE = 256;
    private static final char IMM_CHAR = '$';
    private static final char DEF_CHAR = '#';

    public UnifiedJEXL(JexlEngine aJexl) {
        this(aJexl, 256);
    }

    public UnifiedJEXL(JexlEngine aJexl, int cacheSize) {
        this.jexl = aJexl;
        JexlEngine jexlEngine = aJexl;
        jexlEngine.getClass();
        this.cache = jexlEngine.new JexlEngine.SoftCache(cacheSize);
    }

    public JexlEngine getEngine() {
        return this.jexl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        JexlEngine.SoftCache<String, Expression> softCache = this.cache;
        synchronized (softCache) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression parse(String expression) {
        Expression stmt;
        block13: {
            Exception xuel = null;
            stmt = null;
            try {
                if (this.cache == null) {
                    stmt = this.parseExpression(expression, null);
                    break block13;
                }
                JexlEngine.SoftCache<String, Expression> softCache = this.cache;
                synchronized (softCache) {
                    stmt = this.cache.get(expression);
                    if (stmt == null) {
                        stmt = this.parseExpression(expression, null);
                        this.cache.put(expression, stmt);
                    }
                }
            }
            catch (JexlException xjexl) {
                xuel = new Exception("failed to parse '" + expression + "'", xjexl);
                return xuel;
            }
            catch (Exception xany) {
                xuel = xany;
                return xuel;
            }
            finally {
                if (xuel == null) break block13;
                if (this.jexl.isSilent()) {
                    this.jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                    return null;
                }
                throw xuel;
            }
        }
        return stmt;
    }

    private Exception createException(String action, Expression expr, java.lang.Exception xany) {
        String causeMsg;
        Throwable cause;
        StringBuilder strb = new StringBuilder("failed to ");
        strb.append(action);
        if (expr != null) {
            strb.append(" '");
            strb.append(expr.toString());
            strb.append("'");
        }
        if ((cause = xany.getCause()) != null && (causeMsg = cause.getMessage()) != null) {
            strb.append(", ");
            strb.append(causeMsg);
        }
        return new Exception(strb.toString(), xany);
    }

    private Expression parseExpression(String expr, JexlEngine.Scope scope) {
        int size = expr.length();
        ExpressionBuilder builder = new ExpressionBuilder(0);
        StringBuilder strb = new StringBuilder(size);
        ParseState state = ParseState.CONST;
        int inner = 0;
        boolean nested = false;
        int inested = -1;
        block8: for (int i = 0; i < size; ++i) {
            char c = expr.charAt(i);
            switch (state) {
                default: {
                    throw new UnsupportedOperationException("unexpected expression type");
                }
                case CONST: {
                    if (c == '$') {
                        state = ParseState.IMMEDIATE0;
                        continue block8;
                    }
                    if (c == '#') {
                        inested = i;
                        state = ParseState.DEFERRED0;
                        continue block8;
                    }
                    if (c == '\\') {
                        state = ParseState.ESCAPE;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case IMMEDIATE0: {
                    ConstantExpression cexpr;
                    if (c == '{') {
                        state = ParseState.IMMEDIATE1;
                        if (strb.length() <= 0) continue block8;
                        cexpr = new ConstantExpression(strb.toString(), null);
                        builder.add(cexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        continue block8;
                    }
                    strb.append('$');
                    strb.append(c);
                    state = ParseState.CONST;
                    continue block8;
                }
                case DEFERRED0: {
                    ConstantExpression cexpr;
                    if (c == '{') {
                        state = ParseState.DEFERRED1;
                        if (strb.length() <= 0) continue block8;
                        cexpr = new ConstantExpression(strb.toString(), null);
                        builder.add(cexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        continue block8;
                    }
                    strb.append('#');
                    strb.append(c);
                    state = ParseState.CONST;
                    continue block8;
                }
                case IMMEDIATE1: {
                    if (c == '}') {
                        ImmediateExpression iexpr = new ImmediateExpression(strb.toString(), this.jexl.parse(strb, null, scope), null);
                        builder.add(iexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        state = ParseState.CONST;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case DEFERRED1: {
                    if (c == '\"' || c == '\'') {
                        strb.append(c);
                        i = StringParser.readString(strb, expr, i + 1, c);
                        continue block8;
                    }
                    if (c == '{') {
                        if (expr.charAt(i - 1) != '$') continue block8;
                        ++inner;
                        strb.deleteCharAt(strb.length() - 1);
                        nested = true;
                        continue block8;
                    }
                    if (c == '}') {
                        if (inner > 0) {
                            --inner;
                            continue block8;
                        }
                        JexlBasedExpression dexpr = null;
                        dexpr = nested ? new NestedExpression(expr.substring(inested, i + 1), this.jexl.parse(strb, null, scope), null) : new DeferredExpression(strb.toString(), this.jexl.parse(strb, null, scope), null);
                        builder.add(dexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        nested = false;
                        state = ParseState.CONST;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case ESCAPE: {
                    if (c == '#') {
                        strb.append('#');
                    } else if (c == '$') {
                        strb.append('$');
                    } else {
                        strb.append('\\');
                        strb.append(c);
                    }
                    state = ParseState.CONST;
                }
            }
        }
        if (state != ParseState.CONST) {
            throw new Exception("malformed expression: " + expr, null);
        }
        if (strb.length() > 0) {
            ConstantExpression cexpr = new ConstantExpression(strb.toString(), null);
            builder.add(cexpr);
        }
        return builder.build(this, null);
    }

    protected int startsWith(CharSequence sequence, CharSequence pattern) {
        int s = 0;
        while (Character.isSpaceChar(sequence.charAt(s))) {
            ++s;
        }
        sequence = sequence.subSequence(s, sequence.length());
        if (pattern.length() <= sequence.length() && sequence.subSequence(0, pattern.length()).equals(pattern)) {
            return s + pattern.length();
        }
        return -1;
    }

    protected List<TemplateBlock> readTemplate(String prefix, Reader source) {
        try {
            int prefixLen = prefix.length();
            ArrayList<TemplateBlock> blocks = new ArrayList<TemplateBlock>();
            BufferedReader reader = source instanceof BufferedReader ? (BufferedReader)source : new BufferedReader(source);
            StringBuilder strb = new StringBuilder();
            BlockType type = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) break;
                if (type == null) {
                    prefixLen = this.startsWith(line, prefix);
                    if (prefixLen >= 0) {
                        type = BlockType.DIRECTIVE;
                        strb.append(line.subSequence(prefixLen, line.length()));
                        continue;
                    }
                    type = BlockType.VERBATIM;
                    strb.append(line.subSequence(0, line.length()));
                    strb.append('\n');
                    continue;
                }
                if (type == BlockType.DIRECTIVE) {
                    prefixLen = this.startsWith(line, prefix);
                    if (prefixLen < 0) {
                        TemplateBlock code = new TemplateBlock(BlockType.DIRECTIVE, strb.toString());
                        strb.delete(0, Integer.MAX_VALUE);
                        blocks.add(code);
                        type = BlockType.VERBATIM;
                        strb.append(line.subSequence(0, line.length()));
                        continue;
                    }
                    strb.append(line.subSequence(prefixLen, line.length()));
                    continue;
                }
                if (type != BlockType.VERBATIM) continue;
                prefixLen = this.startsWith(line, prefix);
                if (prefixLen >= 0) {
                    strb.append('\n');
                    TemplateBlock verbatim = new TemplateBlock(BlockType.VERBATIM, strb.toString());
                    strb.delete(0, Integer.MAX_VALUE);
                    blocks.add(verbatim);
                    type = BlockType.DIRECTIVE;
                    strb.append(line.subSequence(prefixLen, line.length()));
                    continue;
                }
                strb.append(line.subSequence(0, line.length()));
            }
            TemplateBlock block = new TemplateBlock(type, strb.toString());
            blocks.add(block);
            return blocks;
        }
        catch (IOException xio) {
            return null;
        }
    }

    public Template createTemplate(String prefix, Reader source, String ... parms) {
        return new Template(prefix, source, parms);
    }

    public Template createTemplate(String source, String ... parms) {
        return new Template("$$", new StringReader(source), parms);
    }

    public Template createTemplate(String source) {
        return new Template("$$", new StringReader(source), (String[])null);
    }

    public final class TemplateContext
    implements JexlContext,
    NamespaceResolver {
        private final JexlContext wrap;
        private final Expression[] exprs;
        private final Writer writer;
        private final JexlEngine.Frame frame;

        protected TemplateContext(JexlContext jcontext, JexlEngine.Frame jframe, Expression[] expressions, Writer out) {
            this.wrap = jcontext;
            this.frame = jframe;
            this.exprs = expressions;
            this.writer = out;
        }

        public JexlEngine.Frame getFrame() {
            return this.frame;
        }

        public Object get(String name) {
            if ("$jexl".equals(name)) {
                return this.writer;
            }
            return this.wrap.get(name);
        }

        public void set(String name, Object value) {
            this.wrap.set(name, value);
        }

        public boolean has(String name) {
            return this.wrap.has(name);
        }

        public Object resolveNamespace(String ns) {
            if ("jexl".equals(ns)) {
                return this;
            }
            if (this.wrap instanceof NamespaceResolver) {
                return ((NamespaceResolver)((Object)this.wrap)).resolveNamespace(ns);
            }
            return null;
        }

        public void include(Template template, Object ... args) {
            template.evaluate(this.wrap, this.writer, args);
        }

        public void print(int e) {
            if (e < 0 || e >= this.exprs.length) {
                return;
            }
            Expression expr = this.exprs[e];
            if (expr.isDeferred()) {
                expr = expr.prepare(this.wrap);
            }
            if (expr instanceof CompositeExpression) {
                this.printComposite((CompositeExpression)expr);
            } else {
                this.doPrint(expr.evaluate(this));
            }
        }

        protected void printComposite(CompositeExpression composite) {
            Expression[] cexprs = composite.exprs;
            int size = cexprs.length;
            Object value = null;
            for (int e = 0; e < size; ++e) {
                value = cexprs[e].evaluate(this);
                this.doPrint(value);
            }
        }

        private void doPrint(Object arg) {
            try {
                if (arg instanceof CharSequence) {
                    this.writer.write(arg.toString());
                } else if (arg != null) {
                    Object[] value = new Object[]{arg};
                    Uberspect uber = UnifiedJEXL.this.getEngine().getUberspect();
                    JexlMethod method = uber.getMethod(this.writer, "print", value, null);
                    if (method != null) {
                        method.invoke(this.writer, value);
                    } else {
                        this.writer.write(arg.toString());
                    }
                }
            }
            catch (IOException xio) {
                throw UnifiedJEXL.this.createException("call print", null, xio);
            }
            catch (java.lang.Exception xany) {
                throw UnifiedJEXL.this.createException("invoke print", null, xany);
            }
        }
    }

    public final class Template {
        private final String prefix;
        private final TemplateBlock[] source;
        private final ASTJexlScript script;
        private final Expression[] exprs;

        public Template(String directive, Reader reader, String ... parms) {
            TemplateBlock block;
            int b;
            if (directive == null) {
                throw new NullPointerException("null prefix");
            }
            if ("$".equals(directive) || "${".equals(directive) || "#".equals(directive) || "#{".equals(directive)) {
                throw new IllegalArgumentException(directive + ": is not a valid directive pattern");
            }
            if (reader == null) {
                throw new NullPointerException("null input");
            }
            JexlEngine.Scope scope = new JexlEngine.Scope(parms);
            this.prefix = directive;
            List<TemplateBlock> blocks = UnifiedJEXL.this.readTemplate(this.prefix, reader);
            ArrayList<Expression> uexprs = new ArrayList<Expression>();
            StringBuilder strb = new StringBuilder();
            int nuexpr = 0;
            int codeStart = -1;
            for (b = 0; b < blocks.size(); ++b) {
                block = blocks.get(b);
                if (block.type == BlockType.VERBATIM) {
                    strb.append("jexl:print(");
                    strb.append(nuexpr++);
                    strb.append(");");
                    continue;
                }
                if (codeStart < 0) {
                    codeStart = b;
                }
                strb.append(block.body);
            }
            this.script = UnifiedJEXL.this.getEngine().parse(strb.toString(), null, scope);
            scope = this.script.getScope();
            for (b = 0; b < blocks.size(); ++b) {
                block = blocks.get(b);
                if (block.type != BlockType.VERBATIM) continue;
                uexprs.add(UnifiedJEXL.this.parseExpression(block.body, b > codeStart ? scope : null));
            }
            this.source = blocks.toArray(new TemplateBlock[blocks.size()]);
            this.exprs = uexprs.toArray(new Expression[uexprs.size()]);
        }

        private Template(String thePrefix, TemplateBlock[] theSource, ASTJexlScript theScript, Expression[] theExprs) {
            this.prefix = thePrefix;
            this.source = theSource;
            this.script = theScript;
            this.exprs = theExprs;
        }

        public String toString() {
            StringBuilder strb = new StringBuilder();
            for (TemplateBlock block : this.source) {
                if (block.type == BlockType.DIRECTIVE) {
                    strb.append(this.prefix);
                }
                strb.append(block.toString());
                strb.append('\n');
            }
            return strb.toString();
        }

        public String asString() {
            StringBuilder strb = new StringBuilder();
            int e = 0;
            for (int b = 0; b < this.source.length; ++b) {
                TemplateBlock block = this.source[b];
                if (block.type == BlockType.DIRECTIVE) {
                    strb.append(this.prefix);
                    continue;
                }
                this.exprs[e++].asString(strb);
            }
            return strb.toString();
        }

        public Template prepare(JexlContext context) {
            JexlEngine.Frame frame = this.script.createFrame(null);
            TemplateContext tcontext = new TemplateContext(context, frame, this.exprs, null);
            Expression[] immediates = new Expression[this.exprs.length];
            for (int e = 0; e < this.exprs.length; ++e) {
                immediates[e] = this.exprs[e].prepare(tcontext);
            }
            return new Template(this.prefix, this.source, this.script, immediates);
        }

        public void evaluate(JexlContext context, Writer writer) {
            this.evaluate(context, writer, null);
        }

        public void evaluate(JexlContext context, Writer writer, Object ... args) {
            JexlEngine.Frame frame = this.script.createFrame(args);
            TemplateContext tcontext = new TemplateContext(context, frame, this.exprs, writer);
            Interpreter interpreter = UnifiedJEXL.this.jexl.createInterpreter(tcontext, !UnifiedJEXL.this.jexl.isLenient(), false);
            interpreter.setFrame(frame);
            interpreter.interpret(this.script);
        }
    }

    private static final class TemplateBlock {
        private final BlockType type;
        private final String body;

        TemplateBlock(BlockType theType, String theBlock) {
            this.type = theType;
            this.body = theBlock;
        }

        public String toString() {
            return this.body;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BlockType {
        VERBATIM,
        DIRECTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseState {
        CONST,
        IMMEDIATE0,
        DEFERRED0,
        IMMEDIATE1,
        DEFERRED1,
        ESCAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeExpression
    extends Expression {
        private final int meta;
        protected final Expression[] exprs;

        CompositeExpression(int[] counters, ArrayList<Expression> list, Expression src) {
            super(src);
            this.exprs = list.toArray(new Expression[list.size()]);
            this.meta = (counters[ExpressionType.DEFERRED.index] > 0 ? 2 : 0) | (counters[ExpressionType.IMMEDIATE.index] > 0 ? 1 : 0);
        }

        @Override
        public boolean isImmediate() {
            return (this.meta & 2) == 0;
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.COMPOSITE;
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            for (Expression e : this.exprs) {
                e.asString(strb);
            }
            return strb;
        }

        @Override
        public Set<List<String>> getVariables() {
            LinkedHashSet<List<String>> refs = new LinkedHashSet<List<String>>();
            for (Expression expr : this.exprs) {
                expr.getVariables(refs);
            }
            return refs;
        }

        @Override
        protected Expression prepare(Interpreter interpreter) {
            if (this.source != this) {
                return this;
            }
            int size = this.exprs.length;
            ExpressionBuilder builder = new ExpressionBuilder(size);
            boolean eq2 = true;
            for (int e = 0; e < size; ++e) {
                Expression expr = this.exprs[e];
                Expression prepared = expr.prepare(interpreter);
                if (prepared != null) {
                    builder.add(prepared);
                }
                eq2 &= expr == prepared;
            }
            CompositeExpression ready = eq2 ? this : builder.build(UnifiedJEXL.this, this);
            return ready;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            int size = this.exprs.length;
            Object value = null;
            StringBuilder strb = new StringBuilder();
            for (int e = 0; e < size; ++e) {
                value = this.exprs[e].evaluate(interpreter);
                if (value == null) continue;
                strb.append(value.toString());
            }
            value = strb.toString();
            return value;
        }
    }

    private class NestedExpression
    extends JexlBasedExpression {
        NestedExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
            if (this.source != this) {
                throw new IllegalArgumentException("Nested expression can not have a source");
            }
        }

        public StringBuilder asString(StringBuilder strb) {
            strb.append(this.expr);
            return strb;
        }

        public boolean isImmediate() {
            return false;
        }

        ExpressionType getType() {
            return ExpressionType.NESTED;
        }

        protected Expression prepare(Interpreter interpreter) {
            String value = interpreter.interpret(this.node).toString();
            ASTJexlScript dnode = UnifiedJEXL.this.jexl.parse(value, UnifiedJEXL.this.jexl.isDebug() ? this.node.debugInfo() : null, null);
            return new ImmediateExpression(value, dnode, this);
        }

        protected Object evaluate(Interpreter interpreter) {
            return this.prepare(interpreter).evaluate(interpreter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeferredExpression
    extends JexlBasedExpression {
        DeferredExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
        }

        @Override
        public boolean isImmediate() {
            return false;
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.DEFERRED;
        }

        @Override
        protected Expression prepare(Interpreter interpreter) {
            return new ImmediateExpression(this.expr, this.node, this.source);
        }

        @Override
        protected void getVariables(Set<List<String>> refs) {
        }
    }

    private class ImmediateExpression
    extends JexlBasedExpression {
        ImmediateExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
        }

        ExpressionType getType() {
            return ExpressionType.IMMEDIATE;
        }

        protected Expression prepare(Interpreter interpreter) {
            Object value = this.evaluate(interpreter);
            return value != null ? new ConstantExpression(value, this.source) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class JexlBasedExpression
    extends Expression {
        protected final CharSequence expr;
        protected final JexlNode node;

        protected JexlBasedExpression(CharSequence theExpr, JexlNode theNode, Expression theSource) {
            super(theSource);
            this.expr = theExpr;
            this.node = theNode;
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            strb.append(this.isImmediate() ? (char)'$' : '#');
            strb.append("{");
            strb.append(this.expr);
            strb.append("}");
            return strb;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            return interpreter.interpret(this.node);
        }

        @Override
        public Set<List<String>> getVariables() {
            LinkedHashSet<List<String>> refs = new LinkedHashSet<List<String>>();
            this.getVariables(refs);
            return refs;
        }

        @Override
        protected void getVariables(Set<List<String>> refs) {
            UnifiedJEXL.this.jexl.getVariables(this.node, refs, null);
        }
    }

    private class ConstantExpression
    extends Expression {
        private final Object value;

        ConstantExpression(Object val, Expression source) {
            super(source);
            if (val == null) {
                throw new NullPointerException("constant can not be null");
            }
            if (val instanceof String) {
                val = StringParser.buildString((String)val, false);
            }
            this.value = val;
        }

        ExpressionType getType() {
            return ExpressionType.CONSTANT;
        }

        public StringBuilder asString(StringBuilder strb) {
            if (this.value != null) {
                strb.append(this.value.toString());
            }
            return strb;
        }

        protected Object evaluate(Interpreter interpreter) {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Expression {
        protected final Expression source;

        Expression(Expression src) {
            this.source = src != null ? src : this;
        }

        public boolean isImmediate() {
            return true;
        }

        public final boolean isDeferred() {
            return !this.isImmediate();
        }

        abstract ExpressionType getType();

        public String toString() {
            StringBuilder strb = new StringBuilder();
            this.asString(strb);
            if (this.source != this) {
                strb.append(" /*= ");
                strb.append(this.source.toString());
                strb.append(" */");
            }
            return strb.toString();
        }

        public String asString() {
            StringBuilder strb = new StringBuilder();
            this.asString(strb);
            return strb.toString();
        }

        public abstract StringBuilder asString(StringBuilder var1);

        public Set<List<String>> getVariables() {
            return Collections.emptySet();
        }

        protected void getVariables(Set<List<String>> refs) {
        }

        public Expression prepare(JexlContext context) {
            try {
                Interpreter interpreter = new Interpreter(UnifiedJEXL.this.jexl, context, !UnifiedJEXL.this.jexl.isLenient(), UnifiedJEXL.this.jexl.isSilent());
                if (context instanceof TemplateContext) {
                    interpreter.setFrame(((TemplateContext)context).getFrame());
                }
                return this.prepare(interpreter);
            }
            catch (JexlException xjexl) {
                Exception xuel = UnifiedJEXL.this.createException("prepare", this, xjexl);
                if (UnifiedJEXL.this.jexl.isSilent()) {
                    ((UnifiedJEXL)UnifiedJEXL.this).jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                    return null;
                }
                throw xuel;
            }
        }

        public Object evaluate(JexlContext context) {
            try {
                Interpreter interpreter = new Interpreter(UnifiedJEXL.this.jexl, context, !UnifiedJEXL.this.jexl.isLenient(), UnifiedJEXL.this.jexl.isSilent());
                if (context instanceof TemplateContext) {
                    interpreter.setFrame(((TemplateContext)context).getFrame());
                }
                return this.evaluate(interpreter);
            }
            catch (JexlException xjexl) {
                Exception xuel = UnifiedJEXL.this.createException("prepare", this, xjexl);
                if (UnifiedJEXL.this.jexl.isSilent()) {
                    ((UnifiedJEXL)UnifiedJEXL.this).jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                    return null;
                }
                throw xuel;
            }
        }

        public final Expression getSource() {
            return this.source;
        }

        protected Expression prepare(Interpreter interpreter) {
            return this;
        }

        protected abstract Object evaluate(Interpreter var1);
    }

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = -8201402995815975726L;

        public Exception(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class ExpressionBuilder {
        private final int[] counts = new int[]{0, 0, 0};
        private final ArrayList<Expression> expressions;

        ExpressionBuilder(int size) {
            this.expressions = new ArrayList(size <= 0 ? 3 : size);
        }

        void add(Expression expr) {
            int n = expr.getType().index;
            this.counts[n] = this.counts[n] + 1;
            this.expressions.add(expr);
        }

        Expression build(UnifiedJEXL el, Expression source) {
            int sum = 0;
            for (int count : this.counts) {
                sum += count;
            }
            if (this.expressions.size() != sum) {
                StringBuilder error = new StringBuilder("parsing algorithm error, exprs: ");
                error.append(this.expressions.size());
                error.append(", constant:");
                error.append(this.counts[ExpressionType.CONSTANT.index]);
                error.append(", immediate:");
                error.append(this.counts[ExpressionType.IMMEDIATE.index]);
                error.append(", deferred:");
                error.append(this.counts[ExpressionType.DEFERRED.index]);
                throw new IllegalStateException(error.toString());
            }
            if (this.expressions.size() == 1) {
                return this.expressions.get(0);
            }
            UnifiedJEXL unifiedJEXL = el;
            unifiedJEXL.getClass();
            return unifiedJEXL.new CompositeExpression(this.counts, this.expressions, source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpressionType {
        CONSTANT(0),
        IMMEDIATE(1),
        DEFERRED(2),
        NESTED(2),
        COMPOSITE(-1);

        private final int index;

        private ExpressionType(int idx) {
            this.index = idx;
        }
    }
}

