/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.Semigroupal$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.BuildInfo$;
import org.broadinstitute.gpp.poolq3.PoolQConfig;
import org.broadinstitute.gpp.poolq3.PoolQConfig$;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.barcode$package$;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet;
import org.broadinstitute.gpp.poolq3.parser.BarcodeSet$;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.NoOpConsumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import org.broadinstitute.gpp.poolq3.process.ScoringConsumer;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker;
import org.broadinstitute.gpp.poolq3.reference.ExactReference;
import org.broadinstitute.gpp.poolq3.reference.ExactReference$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reference.Reference$;
import org.broadinstitute.gpp.poolq3.reports.BarcodeCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter$;
import org.broadinstitute.gpp.poolq3.reports.CountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.LogNormalizedCountsWriter$;
import org.broadinstitute.gpp.poolq3.reports.QualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.RunInfoWriter$;
import org.broadinstitute.gpp.poolq3.reports.UmiQualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter$;
import org.broadinstitute.gpp.poolq3.types.BarcodeCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.ConditionBarcodeCountsSummaryFileType$;
import org.broadinstitute.gpp.poolq3.types.CountsFileType$;
import org.broadinstitute.gpp.poolq3.types.LogNormalizedCountsFileType$;
import org.broadinstitute.gpp.poolq3.types.OutputFileType;
import org.broadinstitute.gpp.poolq3.types.PoolQRunSummary;
import org.broadinstitute.gpp.poolq3.types.PoolQSummary;
import org.broadinstitute.gpp.poolq3.types.PoolQSummary$;
import org.broadinstitute.gpp.poolq3.types.QualityFileType$;
import org.broadinstitute.gpp.poolq3.types.RunInfoFileType$;
import org.broadinstitute.gpp.poolq3.types.UnexpectedSequencesFileType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class PoolQ$
implements Serializable {
    private static final Logger log;
    private static final Set<OutputFileType> AlwaysWrittenFiles;
    public static final PoolQ$ MODULE$;

    private PoolQ$() {
    }

    static {
        MODULE$ = new PoolQ$();
        log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.PoolQ");
        AlwaysWrittenFiles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new OutputFileType[]{CountsFileType$.MODULE$, QualityFileType$.MODULE$, ConditionBarcodeCountsSummaryFileType$.MODULE$, LogNormalizedCountsFileType$.MODULE$, BarcodeCountsFileType$.MODULE$, RunInfoFileType$.MODULE$}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PoolQ$.class);
    }

    public final void main(String[] args) {
        Option<PoolQConfig> option = PoolQConfig$.MODULE$.parse(args);
        if (None$.MODULE$.equals(option)) {
            System.exit(-1);
            return;
        }
        if (option instanceof Some) {
            PoolQConfig config = (PoolQConfig)((Some)option).value();
            Try<PoolQSummary> try_ = this.run(config);
            if (try_ instanceof Success) {
                return;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                Logger Logger_this = log;
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("PoolQ failed", t);
                }
                System.exit(-1);
                return;
            }
            throw new MatchError(try_);
        }
        throw new MatchError(option);
    }

    public final Try<PoolQSummary> run(PoolQConfig config) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        Logger Logger_this = log;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(15).append("PoolQ version: ").append(BuildInfo$.MODULE$.version()).toString());
        }
        this.logCli(config);
        Logger Logger_this2 = log;
        if (Logger_this2.isInfoEnabled()) {
            Logger_this2.info("Reading row reference data");
        }
        ReferenceData rowReferenceData = ReferenceData$.MODULE$.apply(config.input().rowReference(), ReferenceData$.MODULE$.apply$default$2());
        Logger Logger_this3 = log;
        if (Logger_this3.isInfoEnabled()) {
            Logger_this3.info("Reading column reference data");
        }
        ReferenceData colReferenceData = ReferenceData$.MODULE$.apply(config.input().colReference(), ReferenceData$.MODULE$.apply$default$2()).forColumnBarcodes(config.reportsDialect());
        Option<Path> option = config.input().globalReference();
        Logger Logger_this4 = log;
        if (Logger_this4.isInfoEnabled()) {
            Logger_this4.info("Reading global reference data");
        }
        Option globalReferenceDataOpt = option.map((Function1<Path, ReferenceData> & Serializable)_$1 -> ReferenceData$.MODULE$.apply((Path)_$1, ReferenceData$.MODULE$.apply$default$2()));
        Tuple3<BarcodePolicy, Option<BarcodePolicy>, Object> tuple3 = this.makeRowBarcodePolicy(rowReferenceData, config.rowBarcodePolicyStr(), config.reverseRowBarcodePolicyStr(), config.input().reverseRowReads(), config.skipShortReads());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        BarcodePolicy rowBarcodePolicy = tuple3._1();
        Option<BarcodePolicy> revRowBarcodePolicyOpt = tuple3._2();
        int rowBarcodeLength = BoxesRunTime.unboxToInt(tuple3._3());
        Tuple3<BarcodePolicy, Option<BarcodePolicy>, Integer> tuple32 = Tuple3$.MODULE$.apply(rowBarcodePolicy, revRowBarcodePolicyOpt, BoxesRunTime.boxToInteger(rowBarcodeLength));
        BarcodePolicy rowBarcodePolicy2 = tuple32._1();
        Option<BarcodePolicy> revRowBarcodePolicyOpt2 = tuple32._2();
        int rowBarcodeLength2 = BoxesRunTime.unboxToInt(tuple32._3());
        if (config.isPairedEnd()) {
            Predef$.MODULE$.require(rowReferenceData.barcodeLength() == rowBarcodeLength2, () -> PoolQ$.run$$anonfun$1(rowReferenceData, rowBarcodeLength2));
        }
        Option colBarcodePolicyOpt = config.colBarcodePolicyStr().map((Function1<String, BarcodePolicy> & Serializable)pol -> {
            Integer n = (Integer)package$all$.MODULE$.catsSyntaxOptionId(BoxesRunTime.boxToInteger(colReferenceData.barcodeLength()));
            return BarcodePolicy$.MODULE$.apply((String)pol, OptionIdOps$.MODULE$.some$extension(n), config.skipShortReads());
        });
        Option umiInfo = package$all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(config.input().umiReference(), config.umiBarcodePolicyStr())).mapN((Function2<Path, String, Tuple2> & Serializable)(r, p) -> {
            Logger Logger_this = log;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Reading UMI reference data");
            }
            BarcodeSet ref = BarcodeSet$.MODULE$.apply((Path)r);
            Integer n = (Integer)package$all$.MODULE$.catsSyntaxOptionId(BoxesRunTime.boxToInteger(ref.barcodeLength()));
            BarcodePolicy pol = BarcodePolicy$.MODULE$.apply((String)p, OptionIdOps$.MODULE$.some$extension(n), false);
            return Tuple2$.MODULE$.apply(ref, pol);
        }, Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
        Logger Logger_this5 = log;
        if (Logger_this5.isInfoEnabled()) {
            Logger_this5.info("Building row reference");
        }
        Reference rowReference = Reference$.MODULE$.apply(config.rowMatchFn(), ReferenceData$.MODULE$.truncator(rowBarcodeLength2), config.countAmbiguous(), rowReferenceData.mappings());
        Logger Logger_this6 = log;
        if (Logger_this6.isInfoEnabled()) {
            Logger_this6.info("Building column reference");
        }
        int colBarcodeLength = BoxesRunTime.unboxToInt(colBarcodePolicyOpt.map((Function1<BarcodePolicy, int> & Serializable)_$2 -> _$2.length()).getOrElse(() -> PoolQ$.$anonfun$5(colReferenceData)));
        Reference colReference = Reference$.MODULE$.apply(config.colMatchFn(), ReferenceData$.MODULE$.truncator(colBarcodeLength), config.countAmbiguous(), colReferenceData.mappings());
        Option globalReference = globalReferenceDataOpt.map((Function1<ReferenceData, ExactReference> & Serializable)referenceData -> {
            block0: {
                Logger Logger_this = log;
                if (!Logger_this.isInfoEnabled()) break block0;
                Logger_this.info("Building global reference");
            }
            return ExactReference$.MODULE$.apply(referenceData.mappings(), (Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x), false);
        });
        Either<Object, BarcodePolicy> colBarcodePolicyOrLength = colBarcodePolicyOpt.toRight(() -> PoolQ$.$anonfun$7(colReference));
        CloseableIterable<Barcodes> barcodes = barcode$package$.MODULE$.barcodeSource(config.input(), rowBarcodePolicy2, revRowBarcodePolicyOpt2, colBarcodePolicyOrLength, umiInfo.map((Function1<Tuple2, BarcodePolicy> & Serializable)_$3 -> (BarcodePolicy)_$3._2()));
        Consumer consumer = config.noopConsumer() ? new NoOpConsumer() : new ScoringConsumer(rowReference, colReference, config.countAmbiguous(), config.alwaysCountColumnBarcodes(), umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)_$6 -> (BarcodeSet)_$6._1()), this.unexpectedSequenceTrackerOpt$1(lazyRef2, colReference, lazyRef, config), config.isPairedEnd());
        return this.runProcess(barcodes, consumer).map((Function1<PoolQRunSummary, Tuple3> & Serializable)runSummary -> {
            State state = runSummary.state();
            ShardedHistogram<String, Tuple2<String, String>> counts = state.known();
            return Tuple3$.MODULE$.apply(runSummary, state, counts);
        }).flatMap((Function1<Tuple3, Try> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                PoolQRunSummary runSummary = (PoolQRunSummary)tuple3._1();
                State state = (State)tuple3._2();
                ShardedHistogram counts = (ShardedHistogram)tuple3._3();
                return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
                    PoolQ$.run$$anonfun$3$$anonfun$1(config);
                    return BoxedUnit.UNIT;
                }).flatMap((Function1<BoxedUnit, Try> & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return CountsWriter$.MODULE$.write(config.output().countsFile(), config.output().umiCountsFilesDir(), counts, rowReference, colReference, umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)_$7 -> (BarcodeSet)_$7._1()), config.reportsDialect()).map((Function1<BoxedUnit, Tuple2> & Serializable)x$1 -> {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        BoxedUnit $2$ = boxedUnit2 = BoxedUnit.UNIT;
                        Logger Logger_this = log;
                        if (Logger_this.isInfoEnabled()) {
                            Logger_this.info(new StringBuilder(21).append("Writing quality file ").append(config.output().qualityFile()).toString());
                        }
                        BoxedUnit $3$ = boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit $3$2 = BoxedUnit.UNIT;
                        return Tuple2$.MODULE$.apply($2$, $3$2);
                    }).flatMap((Function1<Tuple2, Try> & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            return QualityWriter$.MODULE$.write(config.output().qualityFile(), config.output().conditionBarcodeCountsSummaryFile(), state, rowReference, colReference, config.isPairedEnd()).flatMap((Function1<BoxedUnit, Try> & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return ((Try)umiInfo.fold(PoolQ$::run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1, (Function1<Tuple2, Try> & Serializable)_$8 -> UmiQualityWriter$.MODULE$.write(config.output().umiQualityFile(), state))).map((Function1<BoxedUnit, Tuple3> & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit;
                                    BoxedUnit boxedUnit2;
                                    BoxedUnit $4$ = boxedUnit2 = BoxedUnit.UNIT;
                                    Logger Logger_this = log;
                                    if (Logger_this.isInfoEnabled()) {
                                        Logger_this.info(new StringBuilder(35).append("Writing log-normalized counts file ").append(config.output().normalizedCountsFile()).toString());
                                    }
                                    BoxedUnit $5$ = boxedUnit = BoxedUnit.UNIT;
                                    BoxedUnit $5$2 = BoxedUnit.UNIT;
                                    Map<String, Map<String, Object>> normalizedCounts = LogNormalizedCountsWriter$.MODULE$.logNormalizedCounts(counts, rowReference, colReference);
                                    return Tuple3$.MODULE$.apply($4$, $5$2, normalizedCounts);
                                }).flatMap((Function1<Tuple3, Try> & Serializable)x$13 -> {
                                    Tuple3 tuple3 = x$13;
                                    if (tuple3 != null) {
                                        Map normalizedCounts = (Map)tuple3._3();
                                        return LogNormalizedCountsWriter$.MODULE$.write(config.output().normalizedCountsFile(), normalizedCounts, rowReference, colReference, config.reportsDialect()).map((Function1<BoxedUnit, Tuple2> & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit;
                                            BoxedUnit boxedUnit2;
                                            BoxedUnit $6$ = boxedUnit2 = BoxedUnit.UNIT;
                                            Logger Logger_this = log;
                                            if (Logger_this.isInfoEnabled()) {
                                                Logger_this.info(new StringBuilder(28).append("Writing barcode counts file ").append(config.output().barcodeCountsFile()).toString());
                                            }
                                            BoxedUnit $7$ = boxedUnit = BoxedUnit.UNIT;
                                            BoxedUnit $7$2 = BoxedUnit.UNIT;
                                            return Tuple2$.MODULE$.apply($6$, $7$2);
                                        }).flatMap((Function1<Tuple2, Try> & Serializable)x$12 -> {
                                            Tuple2 tuple2 = x$12;
                                            if (tuple2 != null) {
                                                return BarcodeCountsWriter$.MODULE$.write(config.output().barcodeCountsFile(), config.output().umiBarcodeCountsFilesDir(), counts, rowReference, colReference, umiInfo.map((Function1<Tuple2, BarcodeSet> & Serializable)_$9 -> (BarcodeSet)_$9._1()), config.reportsDialect()).map((Function1<BoxedUnit, Tuple2> & Serializable)x$1 -> {
                                                    BoxedUnit boxedUnit;
                                                    BoxedUnit boxedUnit2;
                                                    BoxedUnit $8$ = boxedUnit2 = BoxedUnit.UNIT;
                                                    Logger Logger_this = log;
                                                    if (Logger_this.isInfoEnabled()) {
                                                        Logger_this.info(new StringBuilder(25).append("Writing correlation file ").append(config.output().correlationFile()).toString());
                                                    }
                                                    BoxedUnit $9$ = boxedUnit = BoxedUnit.UNIT;
                                                    BoxedUnit $9$2 = BoxedUnit.UNIT;
                                                    return Tuple2$.MODULE$.apply($8$, $9$2);
                                                }).flatMap((Function1<Tuple2, Try> & Serializable)x$1 -> {
                                                    Tuple2 tuple2 = x$1;
                                                    if (tuple2 != null) {
                                                        return CorrelationFileWriter$.MODULE$.write(config.output().correlationFile(), normalizedCounts, rowReference, colReference).flatMap((Function1<Option, Try> & Serializable)cfto -> ((Try)this.unexpectedSequenceCacheDirOpt$1(lazyRef, config).fold(PoolQ$::run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1, (Function1<Path, Try> & Serializable)dir -> {
                                                            Logger Logger_this = log;
                                                            if (Logger_this.isInfoEnabled()) {
                                                                Logger_this.info(new StringBuilder(35).append("Writing unexpected sequence report ").append(config.output().unexpectedSequencesFile()).toString());
                                                            }
                                                            UnexpectedSequencesFileType$ unexpectedSequencesFileType$ = (UnexpectedSequencesFileType$)package$all$.MODULE$.catsSyntaxOptionId(UnexpectedSequencesFileType$.MODULE$);
                                                            Try ret = (Try)package$all$.MODULE$.toFunctorOps((Object)UnexpectedSequenceWriter$.MODULE$.write(config.output().unexpectedSequencesFile(), (Path)dir, config.unexpectedSequencesToReport(), colReference, globalReference, config.unexpectedSequenceMaxSampleSize()), (Functor)Invariant$.MODULE$.catsInstancesForTry()).as(OptionIdOps$.MODULE$.some$extension(unexpectedSequencesFileType$));
                                                            if (config.removeUnexpectedSequenceCache()) {
                                                                Logger Logger_this2 = log;
                                                                if (Logger_this2.isInfoEnabled()) {
                                                                    Logger_this2.info(new StringBuilder(35).append("Removing unexpected sequence cache ").append(config.unexpectedSequenceCacheDir()).toString());
                                                                }
                                                                UnexpectedSequenceWriter$.MODULE$.removeCache((Path)dir);
                                                            }
                                                            return ret;
                                                        })).map((Function1<Option, Tuple2> & Serializable)usfto -> {
                                                            BoxedUnit boxedUnit;
                                                            Logger Logger_this = log;
                                                            if (Logger_this.isInfoEnabled()) {
                                                                Logger_this.info(new StringBuilder(17).append("Writing run info ").append(config.output().unexpectedSequencesFile()).toString());
                                                            }
                                                            BoxedUnit $10$ = boxedUnit = BoxedUnit.UNIT;
                                                            BoxedUnit $10$2 = BoxedUnit.UNIT;
                                                            return Tuple2$.MODULE$.apply(usfto, $10$2);
                                                        }).flatMap((Function1<Tuple2, Try> & Serializable)x$12 -> {
                                                            Tuple2 tuple2 = x$12;
                                                            if (tuple2 != null) {
                                                                Option usfto = (Option)tuple2._1();
                                                                return RunInfoWriter$.MODULE$.write(config.output().runInfoFile(), config).map((Function1<BoxedUnit, Tuple2> & Serializable)x$1 -> {
                                                                    BoxedUnit boxedUnit;
                                                                    BoxedUnit boxedUnit2;
                                                                    BoxedUnit $11$ = boxedUnit2 = BoxedUnit.UNIT;
                                                                    Logger Logger_this = log;
                                                                    if (Logger_this.isInfoEnabled()) {
                                                                        Logger_this.info("PoolQ complete");
                                                                    }
                                                                    BoxedUnit $12$ = boxedUnit = BoxedUnit.UNIT;
                                                                    BoxedUnit $12$2 = BoxedUnit.UNIT;
                                                                    return Tuple2$.MODULE$.apply($11$, $12$2);
                                                                }).map((Function1<Tuple2, PoolQSummary> & Serializable)x$1 -> {
                                                                    Tuple2 tuple2 = x$1;
                                                                    if (tuple2 != null) {
                                                                        return PoolQSummary$.MODULE$.apply(runSummary, (Set)AlwaysWrittenFiles.$plus$plus((IterableOnce)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Option[]{cfto, usfto}))).flatten(Predef$.MODULE$.$conforms())));
                                                                    }
                                                                    throw new MatchError(tuple2);
                                                                });
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }));
                                                    }
                                                    throw new MatchError(tuple2);
                                                });
                                            }
                                            throw new MatchError(tuple2);
                                        });
                                    }
                                    throw new MatchError(tuple3);
                                });
                            });
                        }
                        throw new MatchError(tuple2);
                    });
                });
            }
            throw new MatchError(tuple3);
        });
    }

    public Try<PoolQRunSummary> runProcess(CloseableIterable<Barcodes> barcodes, Consumer consumer) {
        return Using$.MODULE$.apply(() -> PoolQ$.runProcess$$anonfun$1(barcodes), (Function1<CloseableIterator, PoolQRunSummary> & Serializable)iterator -> {
            PoolQProcess process = new PoolQProcess((Iterator<Barcodes>)iterator, consumer, PoolQProcess$.MODULE$.$lessinit$greater$default$3(), PoolQProcess$.MODULE$.$lessinit$greater$default$4());
            return process.run();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public Tuple3<BarcodePolicy, Option<BarcodePolicy>, Object> makeRowBarcodePolicy(ReferenceData rowReferenceData, String rowBarcodePolicyStr, Option<String> reverseRowBarcodePolicyStr, Option<Tuple2<Option<String>, Path>> reverseRowReads, boolean skipShortReads) {
        return (Tuple3)package$all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(reverseRowBarcodePolicyStr, reverseRowReads)).mapN((Function2<String, Tuple2, Tuple3> & Serializable)(revPolicy, _$10) -> {
            Tuple2 tuple2 = rowReferenceData.barcodeLengths().unzip($less$colon$less$.MODULE$.refl());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option forwardRowBcLengthOpt = tuple2._1();
            Option revRowBcLengthOpt = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(forwardRowBcLengthOpt, revRowBcLengthOpt);
            Option<Object> forwardRowBcLengthOpt2 = tuple22._1();
            Option<Object> revRowBcLengthOpt2 = tuple22._2();
            BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(rowBarcodePolicyStr, forwardRowBcLengthOpt2, skipShortReads);
            BarcodePolicy revRowBarcodePolicy = BarcodePolicy$.MODULE$.apply((String)revPolicy, revRowBcLengthOpt2, skipShortReads);
            return Tuple3$.MODULE$.apply(rowBarcodePolicy, Some$.MODULE$.apply(revRowBarcodePolicy), BoxesRunTime.boxToInteger(rowBarcodePolicy.length() + revRowBarcodePolicy.length()));
        }, Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption()).getOrElse(() -> PoolQ$.makeRowBarcodePolicy$$anonfun$2(rowBarcodePolicyStr, rowReferenceData, skipShortReads));
    }

    private void logCli(PoolQConfig config) {
        String logStr = ((AbstractIterable)PoolQConfig$.MODULE$.synthesizeArgs(config).map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                String param2 = string2;
                if ("".equals(string3)) {
                    return new StringBuilder(2).append("--").append(param2).toString();
                }
                String param3 = string2;
                String arg = string3;
                return new StringBuilder(3).append("--").append(param3).append(" ").append(arg).toString();
            }
            throw new MatchError(tuple2);
        })).mkString(" \\\n");
        Logger Logger_this = log;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(29).append("PoolQ command-line settings:\n").append(logStr).toString());
            return;
        }
    }

    private static final Object run$$anonfun$1(ReferenceData rowReferenceData$1, int rowBarcodeLength$1) {
        return new StringBuilder(121).append("In paired-end mode, the length of the barcodes in the reference data must be exactly equal to the length of the barcodes ").append(new StringBuilder(85).append("according to the barcode policies. Reference barcodes have length ").append(rowReferenceData$1.barcodeLength()).append(", policies require ").append(rowBarcodeLength$1).toString()).toString();
    }

    private static final int $anonfun$5(ReferenceData colReferenceData$2) {
        return colReferenceData$2.barcodeLength();
    }

    private static final int $anonfun$7(Reference colReference$1) {
        return colReference$1.barcodeLength();
    }

    private static final Option $anonfun$10() {
        Path ret = Files.createTempDirectory("unexpected-sequence-cache", new FileAttribute[0]);
        return Some$.MODULE$.apply(ret);
    }

    private final Option unexpectedSequenceCacheDirOpt$lzyINIT1$1(LazyRef unexpectedSequenceCacheDirOpt$lzy1$1, PoolQConfig config$2) {
        Option option;
        LazyRef lazyRef = unexpectedSequenceCacheDirOpt$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (unexpectedSequenceCacheDirOpt$lzy1$1.initialized()) {
                object = unexpectedSequenceCacheDirOpt$lzy1$1.value();
            } else {
                Option option2;
                if (config$2.skipUnexpectedSequenceReport()) {
                    option2 = None$.MODULE$;
                } else {
                    Option ret = config$2.unexpectedSequenceCacheDir().map((Function1<Path, Path> & Serializable)_$4 -> Files.createDirectories(_$4, new FileAttribute[0])).orElse(PoolQ$::$anonfun$10);
                    ret.foreach(path -> {
                        Logger Logger_this = log;
                        if (Logger_this.isInfoEnabled()) {
                            Logger_this.info(new StringBuilder(43).append("Writing unexpected sequence cache files to ").append(path).toString());
                            return;
                        }
                    });
                    option2 = ret;
                }
                object = unexpectedSequenceCacheDirOpt$lzy1$1.initialize(option2);
            }
            option = (Option)object;
        }
        return option;
    }

    private final Option unexpectedSequenceCacheDirOpt$1(LazyRef unexpectedSequenceCacheDirOpt$lzy1$2, PoolQConfig config$3) {
        return (Option)(unexpectedSequenceCacheDirOpt$lzy1$2.initialized() ? unexpectedSequenceCacheDirOpt$lzy1$2.value() : this.unexpectedSequenceCacheDirOpt$lzyINIT1$1(unexpectedSequenceCacheDirOpt$lzy1$2, config$3));
    }

    private final Option unexpectedSequenceTrackerOpt$lzyINIT1$1(LazyRef unexpectedSequenceTrackerOpt$lzy1$1, Reference colReference$2, LazyRef unexpectedSequenceCacheDirOpt$lzy1$3, PoolQConfig config$4) {
        Option option;
        LazyRef lazyRef = unexpectedSequenceTrackerOpt$lzy1$1;
        synchronized (lazyRef) {
            option = (Option)(unexpectedSequenceTrackerOpt$lzy1$1.initialized() ? unexpectedSequenceTrackerOpt$lzy1$1.value() : unexpectedSequenceTrackerOpt$lzy1$1.initialize(this.unexpectedSequenceCacheDirOpt$1(unexpectedSequenceCacheDirOpt$lzy1$3, config$4).map((Function1<Path, UnexpectedSequenceTracker> & Serializable)_$5 -> new UnexpectedSequenceTracker((Path)_$5, colReference$2))));
        }
        return option;
    }

    private final Option unexpectedSequenceTrackerOpt$1(LazyRef unexpectedSequenceTrackerOpt$lzy1$2, Reference colReference$4, LazyRef unexpectedSequenceCacheDirOpt$lzy1$4, PoolQConfig config$5) {
        return (Option)(unexpectedSequenceTrackerOpt$lzy1$2.initialized() ? unexpectedSequenceTrackerOpt$lzy1$2.value() : this.unexpectedSequenceTrackerOpt$lzyINIT1$1(unexpectedSequenceTrackerOpt$lzy1$2, colReference$4, unexpectedSequenceCacheDirOpt$lzy1$4, config$5));
    }

    private static final void run$$anonfun$3$$anonfun$1(PoolQConfig config$7) {
        Logger Logger_this = log;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(20).append("Writing counts file ").append(config$7.output().countsFile()).toString());
            return;
        }
    }

    private static final Try run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1() {
        BoxedUnit boxedUnit = (BoxedUnit)package$all$.MODULE$.catsSyntaxApplicativeId(BoxedUnit.UNIT);
        return (Try)ApplicativeIdOps$.MODULE$.pure$extension(boxedUnit, (Applicative)((Object)Invariant$.MODULE$.catsInstancesForTry()));
    }

    private static final Option run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private static final Try run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1() {
        return Try$.MODULE$.apply(PoolQ$::run$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private static final CloseableIterator runProcess$$anonfun$1(CloseableIterable barcodes$1) {
        return barcodes$1.iterator();
    }

    private static final Tuple3 makeRowBarcodePolicy$$anonfun$2(String rowBarcodePolicyStr$2, ReferenceData rowReferenceData$3, boolean skipShortReads$2) {
        Integer n = (Integer)package$all$.MODULE$.catsSyntaxOptionId(BoxesRunTime.boxToInteger(rowReferenceData$3.barcodeLength()));
        BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(rowBarcodePolicyStr$2, OptionIdOps$.MODULE$.some$extension(n), skipShortReads$2);
        return Tuple3$.MODULE$.apply(rowBarcodePolicy, None$.MODULE$, BoxesRunTime.boxToInteger(rowBarcodePolicy.length()));
    }
}

