/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException$;
import org.broadinstitute.gpp.poolq3.parser.parser$package$;
import org.broadinstitute.gpp.poolq3.types.Read;
import org.broadinstitute.gpp.poolq3.types.Read$;

public final class FastqParser
extends CloseableIterable<Read> {
    public final Path org$broadinstitute$gpp$poolq3$parser$FastqParser$$file;

    public FastqParser(Path file) {
        this.org$broadinstitute$gpp$poolq3$parser$FastqParser$$file = file;
    }

    @Override
    public CloseableIterator<Read> iterator() {
        return new FastqIterator(parser$package$.MODULE$.inputStream(this.org$broadinstitute$gpp$poolq3$parser$FastqParser$$file));
    }

    public class FastqIterator
    extends CloseableIterator<Read> {
        private final BufferedReader reader;
        private String line;

        public FastqIterator(InputStream is) {
            if (FastqParser.this == null) {
                throw new NullPointerException();
            }
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.line = this.reader.readLine();
        }

        private final String nextLine() {
            String ret = this.line;
            this.line = this.reader.readLine();
            return ret;
        }

        @Override
        public final Read next() {
            String line0 = this.nextLine();
            String line1 = this.nextLine();
            String line2 = this.nextLine();
            String line3 = this.nextLine();
            if (line0.charAt(0) != '@') {
                throw InvalidFileException$.MODULE$.apply(FastqParser.this.org$broadinstitute$gpp$poolq3$parser$FastqParser$$file, "Corrupt or incorrect FASTQ: field 1 must begin with '@'");
            }
            if (line2.charAt(0) != '+') {
                throw InvalidFileException$.MODULE$.apply(FastqParser.this.org$broadinstitute$gpp$poolq3$parser$FastqParser$$file, "Corrupt or incorrect FASTQ: field 3 must begin with '+'");
            }
            if (line3 == null) {
                throw InvalidFileException$.MODULE$.apply(FastqParser.this.org$broadinstitute$gpp$poolq3$parser$FastqParser$$file, "File contains an incomplete FASTQ read");
            }
            return Read$.MODULE$.apply(line0, line1);
        }

        @Override
        public final boolean hasNext() {
            return this.line != null;
        }

        @Override
        public final void close() {
            this.reader.close();
        }

        public final /* synthetic */ FastqParser org$broadinstitute$gpp$poolq3$parser$FastqParser$FastqIterator$$$outer() {
            return FastqParser.this;
        }
    }
}

