/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reference;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.reference.MatchedBarcode;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;

public abstract class BaseReference
implements Reference {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(BaseReference.class.getDeclaredField("allIds$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BaseReference.class.getDeclaredField("barcodesForIdMap$lzy1"));
    private final Seq allBarcodes;
    private final Object2ObjectMap<String, String> barcodeToInputBarcode;
    private final Object2ObjectMap<String, LinkedHashSet<String>> barcodeEntries;
    private volatile Object barcodesForIdMap$lzy1;
    private volatile Object allIds$lzy1;
    private final int barcodeLength;

    public BaseReference(Seq<String> allBarcodes, Object2ObjectMap<String, String> barcodeToInputBarcode, Object2ObjectMap<String, LinkedHashSet<String>> barcodeEntries) {
        this.allBarcodes = allBarcodes;
        this.barcodeToInputBarcode = barcodeToInputBarcode;
        this.barcodeEntries = barcodeEntries;
        Predef$.MODULE$.require(allBarcodes.nonEmpty(), BaseReference::$init$$$anonfun$1);
        this.barcodeLength = ((String)allBarcodes.head()).length();
    }

    @Override
    public final Seq<String> allBarcodes() {
        return this.allBarcodes;
    }

    @Override
    public final Seq<MatchedBarcode> find(char[] barcode2) {
        return this.find(new String(barcode2));
    }

    @Override
    public final boolean isDefined(String barcode2) {
        return this.find(barcode2).nonEmpty();
    }

    @Override
    public final Seq<String> idsForBarcode(String barcode2) {
        LinkedHashSet ids = (LinkedHashSet)this.barcodeEntries.get(barcode2);
        if (ids == null) {
            return package$.MODULE$.Vector().empty();
        }
        return ids.toVector();
    }

    @Override
    public final Seq<String> barcodesForId(String id) {
        return (Seq)this.barcodesForIdMap().getOrElse(id, BaseReference::barcodesForId$$anonfun$1);
    }

    public final Map<String, List<String>> barcodesForIdMap() {
        Object object = this.barcodesForIdMap$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.barcodesForIdMap$lzyINIT1();
    }

    private Object barcodesForIdMap$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.barcodesForIdMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        HashMap m = (HashMap)HashMap$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
                        this.barcodeEntries.forEach((barcode2, ids) -> ids.foreach((Function1<String, Option> & Serializable)id -> m.put(id, ((List)m.getOrElse(id, BaseReference::barcodesForIdMap$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1)).$colon$colon(barcode2))));
                        map = m.toMap($less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.barcodesForIdMap$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.barcodesForIdMap$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String referenceBarcodeForDnaBarcode(String matchingBarcode) {
        String inputBarcode = (String)this.barcodeToInputBarcode.get(matchingBarcode);
        if (inputBarcode == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown matching barcode ").append(matchingBarcode).toString());
        }
        return inputBarcode;
    }

    @Override
    public final Seq<String> allIds() {
        Object object = this.allIds$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.allIds$lzyINIT1();
    }

    private Object allIds$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.allIds$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Vector vector = null;
                    try {
                        LinkedHashSet ids = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[0]));
                        this.allBarcodes().foreach((Function1<String, LinkedHashSet> & Serializable)barcode2 -> (LinkedHashSet)ids.$plus$plus$eq((IterableOnce)this.barcodeEntries.get(barcode2)));
                        vector = ids.toVector();
                        serializable = vector == null ? LazyVals$NullValue$.MODULE$ : vector;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.allIds$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.allIds$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                        waiting.countDown();
                    }
                    return vector;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final int barcodeLength() {
        return this.barcodeLength;
    }

    private static final Object $init$$$anonfun$1() {
        return "Reference may not be empty";
    }

    private static final List barcodesForId$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final List barcodesForIdMap$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

