/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reference;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.parser.ConflictingBarcodeException;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry;
import org.broadinstitute.gpp.poolq3.reference.ExactReference$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reference.VariantReference$;
import scala.Function1;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class Reference$
implements Serializable {
    public static final Reference$ MODULE$ = new Reference$();

    private Reference$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Reference$.class);
    }

    public Reference apply(String matcher, Function1<String, String> barcodeProcessor, boolean includeAmbiguous, Seq<ReferenceEntry> bs) {
        String string2 = matcher.toLowerCase();
        if ("exact".equals(string2)) {
            return ExactReference$.MODULE$.apply(bs, barcodeProcessor, includeAmbiguous);
        }
        if ("mismatch".equals(string2)) {
            return VariantReference$.MODULE$.apply(bs, barcodeProcessor, includeAmbiguous);
        }
        throw new IllegalArgumentException(new StringBuilder(69).append("Unknown matching function `").append(matcher).append("`. Please choose either exact or mismatch.").toString());
    }

    public Tuple3<Seq<String>, Object2ObjectMap<String, String>, Object2ObjectMap<String, LinkedHashSet<String>>> build(Seq<ReferenceEntry> mappings) {
        LinkedHashSet barcodes = new LinkedHashSet();
        Object2ObjectOpenHashMap barcodeIds = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap barcodeToInputBarcode = new Object2ObjectOpenHashMap();
        mappings.foreach((Function1<ReferenceEntry, LinkedHashSet> & Serializable)referenceEntry -> {
            Object object;
            barcodes.$plus$eq(referenceEntry.dnaBarcode());
            if (barcodeToInputBarcode.containsKey(referenceEntry.dnaBarcode())) {
                String witness;
                String string2 = witness = (String)barcodeToInputBarcode.get(referenceEntry.dnaBarcode());
                String string3 = referenceEntry.referenceBarcode();
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    throw new ConflictingBarcodeException(referenceEntry.referenceBarcode(), referenceEntry.referenceId(), witness);
                }
                object = BoxedUnit.UNIT;
            } else {
                object = barcodeToInputBarcode.put(referenceEntry.dnaBarcode(), referenceEntry.referenceBarcode());
            }
            if (barcodeIds.containsKey(referenceEntry.dnaBarcode())) {
                return (LinkedHashSet)((Growable)barcodeIds.get(referenceEntry.dnaBarcode())).$plus$eq(referenceEntry.referenceId());
            }
            LinkedHashSet set = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[0]));
            set.$plus$eq(referenceEntry.referenceId());
            return barcodeIds.put(referenceEntry.dnaBarcode(), set);
        });
        return Tuple3$.MODULE$.apply(barcodes.toVector(), barcodeToInputBarcode, barcodeIds);
    }

    public Object2ObjectMap<String, List<String>> truncationVariants(Seq<String> barcodes, Function1<String, String> barcodeProcessor, boolean includeAmbiguous) {
        Object2ObjectOpenHashMap<String, List<String>> map = new Object2ObjectOpenHashMap<String, List<String>>();
        map.defaultReturnValue(package$.MODULE$.Nil());
        barcodes.foreach((Function1<String, List> & Serializable)barcode2 -> {
            String variant = (String)barcodeProcessor.apply((String)barcode2);
            List bcs = (List)map.get(variant);
            return map.put(variant, bcs.$colon$colon(barcode2));
        });
        if (!includeAmbiguous) {
            this.pruneAmbiguous(map);
        }
        return map;
    }

    public <S extends Seq<String>> void pruneAmbiguous(Object2ObjectMap<String, S> barcodeVariants) {
        ObjectRef<Nil$> ambiguousVariants = ObjectRef.create(package$.MODULE$.Nil());
        barcodeVariants.forEach((variant, barcodes) -> {
            if (barcodes.size() > 1) {
                ambiguousVariants$1.elem = ((List)ambiguousVariants$1.elem).$colon$colon(variant);
                return;
            }
        });
        ((List)ambiguousVariants.elem).foreach((Function1<Object, Seq> & Serializable)x$0 -> (Seq)barcodeVariants.remove(x$0));
    }
}

