/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.broadinstitute.gpp.poolq3.hist.ReadOnlyHistogram;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.GctDialect$;
import org.broadinstitute.gpp.poolq3.reports.ParsedFilename;
import org.broadinstitute.gpp.poolq3.reports.ParsedFilename$;
import org.broadinstitute.gpp.poolq3.reports.PoolQ2Dialect$;
import org.broadinstitute.gpp.poolq3.reports.PoolQ3Dialect$;
import org.broadinstitute.gpp.poolq3.reports.ReportsDialect;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class reports$package$
implements Serializable {
    public static final reports$package$ MODULE$ = new reports$package$();

    private reports$package$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(reports$package$.class);
    }

    public void writeRowIdentifiers(Reference rowReference, String rowBc, PrintWriter pw) {
        String rowBarcodeIds = rowReference.idsForBarcode(rowBc).mkString(",");
        String rowInputBarcode = rowReference.referenceBarcodeForDnaBarcode(rowBc);
        pw.print(new StringBuilder(2).append(rowInputBarcode).append("\t").append(rowBarcodeIds).append("\t").toString());
    }

    public String countsHeaderText(ReportsDialect dialect, String colHeadings, int nRows, int nCols) {
        ReportsDialect reportsDialect = dialect;
        if (PoolQ3Dialect$.MODULE$.equals(reportsDialect)) {
            return new StringBuilder(28).append("Row Barcode\tRow Barcode IDs\t").append(colHeadings).toString();
        }
        if (PoolQ2Dialect$.MODULE$.equals(reportsDialect)) {
            return new StringBuilder(32).append("Construct Barcode\tConstruct IDs\t").append(colHeadings).toString();
        }
        if (GctDialect$.MODULE$.equals(reportsDialect)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(48).append("#1.2\n           |").append(nRows).append("\t").append(nCols).append("\n           |NAME\tDescription\t").append(colHeadings).toString()));
        }
        throw new MatchError(reportsDialect);
    }

    public Map<String, Object> getColumnReadCounts(Reference rowReference, Reference colReference, ReadOnlyHistogram<Tuple2<String, String>> hist) {
        return ((IterableOnceOps)colReference.allIds().map((Function1<String, Tuple2> & Serializable)colId -> {
            long readCount = BoxesRunTime.unboxToLong(((IterableOnceOps)colReference.barcodesForId((String)colId).flatMap((Function1<String, IterableOnce> & Serializable)colBarcodeLong -> (IterableOnce)rowReference.allBarcodes().map((Function1<String, long> & Serializable)rowBarcodeLong -> hist.count(Tuple2$.MODULE$.apply(rowBarcodeLong, colBarcodeLong))))).sum(Numeric$LongIsIntegral$.MODULE$));
            String string2 = Predef$.MODULE$.ArrowAssoc(colId);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToLong(readCount));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public ParsedFilename parseFilename(Path p) {
        Tuple2<String, Option> tuple2;
        String nameStr = p.getFileName().toString();
        int lastDotIdx = nameStr.lastIndexOf(46);
        if (lastDotIdx == -1) {
            tuple2 = Tuple2$.MODULE$.apply(nameStr, None$.MODULE$);
        } else {
            Tuple2<String, String> tuple22 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(nameStr), lastDotIdx);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            String b = tuple22._1();
            String e = tuple22._2();
            Tuple2<String, String> tuple23 = Tuple2$.MODULE$.apply(b, e);
            String b2 = tuple23._1();
            String e2 = tuple23._2();
            tuple2 = Tuple2$.MODULE$.apply(b2, Some$.MODULE$.apply(e2));
        }
        Tuple2<String, None$> tuple24 = tuple2;
        String base = tuple24._1();
        Option ext = tuple24._2();
        return ParsedFilename$.MODULE$.apply((Path)Option$.MODULE$.apply(p.getParent()).getOrElse(reports$package$::parseFilename$$anonfun$1), base, ext);
    }

    public <A> List<A> topN(Seq<A> xs, int n, Ordering<A> ord) {
        Tuple2 tuple2 = xs.splitAt(n);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq firstN = (Seq)tuple2._1();
        Seq rest = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = Tuple2$.MODULE$.apply(firstN, rest);
        Seq firstN2 = tuple22._1();
        Seq rest2 = tuple22._2();
        PriorityQueue minHeap = (PriorityQueue)PriorityQueue$.MODULE$.apply(firstN2, ord.reverse());
        rest2.foreach(x -> {
            Object y = minHeap.dequeue();
            minHeap.enqueue(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{ord.max(x, y)}));
        });
        return ((IterableOnceOps)minHeap.dequeueAll().reverse()).toList();
    }

    private static final Path parseFilename$$anonfun$1() {
        return Paths.get(".", new String[0]);
    }
}

