/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import ngs.Package;

class Logger {
    private String version;
    private Level level;
    private static Logger logger = new Logger();

    private Logger() {
        String string2 = System.getProperty("vdb.log");
        this.level = string2 == null || string2.equals("WARNING") ? Level.WARNING : (string2.equals("OFF") ? Level.OFF : (string2.equals("INFO") ? Level.INFO : (string2.equals("FINE") ? Level.FINE : (string2.equals("FINER") ? Level.FINER : (string2.equals("FINEST") ? Level.FINEST : Level.FINE)))));
    }

    static void warning(String string2) {
        Logger.log(Level.WARNING, string2);
    }

    static void info(String string2) {
        Logger.log(Level.INFO, string2);
    }

    static void fine(String string2) {
        Logger.log(Level.FINE, string2);
    }

    static void finer(String string2) {
        Logger.log(Level.FINER, string2);
    }

    static void finest(String string2) {
        Logger.log(Level.FINEST, string2);
    }

    static void fine(Throwable throwable) {
        Logger.fine(throwable.toString());
    }

    static void finest(Throwable throwable) {
        Logger.finest(throwable.toString());
    }

    static void finest(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String string2 = null;
        for (String string3 : stringArray) {
            string2 = string2 == null ? "" : string2 + " ";
            string2 = string2 + string3;
        }
        Logger.finest(string2);
    }

    static void log(Level level, String string2) {
        logger.go(level, string2);
    }

    static Level getLevel() {
        return Logger.logger.level;
    }

    static void setLevel(Level level) {
        Logger.logger.level = level;
    }

    private void go(Level level, String string2) {
        if (this.level.id() < level.id()) {
            return;
        }
        String string3 = this.getVersion();
        String string4 = "ngs-java" + (string3 != null ? "." + string3 : "") + ": " + string2;
        System.err.println(string4);
    }

    private String getVersion() {
        if (this.version == null) {
            try {
                this.version = Package.getPackageVersion();
            }
            catch (Throwable throwable) {
                this.version = null;
            }
        }
        return this.version;
    }

    static enum Level {
        OFF(0),
        WARNING(1),
        INFO(2),
        FINE(3),
        FINER(4),
        FINEST(5);

        private final int id;

        private Level(int n2) {
            this.id = n2;
        }

        private int id() {
            return this.id;
        }
    }
}

