/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public final class FileSystem
extends Enum<FileSystem> {
    public static final /* enum */ FileSystem GENERIC = new FileSystem(4096, false, false, 1020, 0x100000, new int[]{0}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem LINUX = new FileSystem(8192, true, true, 255, 4096, new int[]{0, 47}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem MAC_OSX = new FileSystem(4096, true, true, 255, 1024, new int[]{0, 47, 58}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem WINDOWS = new FileSystem(4096, false, true, 255, Short.MAX_VALUE, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b2", "COM\u00b3", "COM\u00b9", "CON", "CONIN$", "CONOUT$", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b2", "LPT\u00b3", "LPT\u00b9", "NUL", "PRN"}, true, true, '\\', NameLengthStrategy.UTF16_CODE_UNITS);
    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final boolean IS_OS_WINDOWS;
    private static final FileSystem CURRENT;
    private final int blockSize;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final int[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;
    private final boolean reservedFileNamesExtensions;
    private final boolean supportsDriveLetter;
    private final char nameSeparator;
    private final char nameSeparatorOther;
    private final NameLengthStrategy nameLengthStrategy;
    private static final /* synthetic */ FileSystem[] $VALUES;

    public static FileSystem[] values() {
        return (FileSystem[])$VALUES.clone();
    }

    public static FileSystem valueOf(String name) {
        return Enum.valueOf(FileSystem.class, name);
    }

    private static FileSystem current() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    public static FileSystem getCurrent() {
        return CURRENT;
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static int indexOfFirstDot(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(46);
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (cs.charAt(i) != '.') continue;
            return i;
        }
        return -1;
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.toUpperCase(Locale.ROOT).startsWith(osNamePrefix.toUpperCase(Locale.ROOT));
    }

    private static String replace(String path, char oldChar, char newChar) {
        return path == null ? null : path.replace(oldChar, newChar);
    }

    private static CharSequence safeTruncate(CharSequence value, int limit) {
        if (value.length() <= limit) {
            return value;
        }
        BreakIterator boundary2 = BreakIterator.getCharacterInstance(Locale.ROOT);
        String text = value.toString();
        boundary2.setText(text);
        int end = boundary2.preceding(limit + 1);
        assert (end != -1);
        if (end == 0) {
            String limitMessage = limit <= 1 ? "1 character" : limit + " characters";
            throw new IllegalArgumentException("The value " + value + " can not be truncated to " + limitMessage + " without breaking the first codepoint or grapheme cluster");
        }
        return text.substring(0, end);
    }

    static CharSequence[] splitExtension(CharSequence value) {
        CharSequence[] charSequenceArray;
        int index = FileSystem.indexOfFirstDot(value);
        if (index < 1) {
            CharSequence[] charSequenceArray2 = new CharSequence[2];
            charSequenceArray2[0] = value;
            charSequenceArray = charSequenceArray2;
            charSequenceArray2[1] = "";
        } else {
            CharSequence[] charSequenceArray3 = new CharSequence[2];
            charSequenceArray3[0] = value.subSequence(0, index);
            charSequenceArray = charSequenceArray3;
            charSequenceArray3[1] = value.subSequence(index, value.length());
        }
        return charSequenceArray;
    }

    static CharSequence trimExtension(CharSequence cs) {
        int index = FileSystem.indexOfFirstDot(cs);
        return index < 1 ? cs : cs.subSequence(0, index);
    }

    private FileSystem(int blockSize, boolean caseSensitive, boolean casePreserving, int maxFileLength, int maxPathLength, int[] illegalFileNameChars, String[] reservedFileNames, boolean reservedFileNamesExtensions, boolean supportsDriveLetter, char nameSeparator, NameLengthStrategy nameLengthStrategy) {
        this.blockSize = blockSize;
        this.maxFileNameLength = maxFileLength;
        this.maxPathLength = maxPathLength;
        this.illegalFileNameChars = Objects.requireNonNull(illegalFileNameChars, "illegalFileNameChars");
        this.reservedFileNames = Objects.requireNonNull(reservedFileNames, "reservedFileNames");
        this.reservedFileNamesExtensions = reservedFileNamesExtensions;
        this.caseSensitive = caseSensitive;
        this.casePreserving = casePreserving;
        this.supportsDriveLetter = supportsDriveLetter;
        this.nameSeparator = nameSeparator;
        this.nameSeparatorOther = FilenameUtils.flipSeparator(nameSeparator);
        this.nameLengthStrategy = nameLengthStrategy;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public char[] getIllegalFileNameChars() {
        char[] chars = new char[this.illegalFileNameChars.length];
        for (int i = 0; i < this.illegalFileNameChars.length; ++i) {
            chars[i] = (char)this.illegalFileNameChars[i];
        }
        return chars;
    }

    public int[] getIllegalFileNameCodePoints() {
        return (int[])this.illegalFileNameChars.clone();
    }

    public int getMaxFileNameLength() {
        return this.maxFileNameLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    NameLengthStrategy getNameLengthStrategy() {
        return this.nameLengthStrategy;
    }

    public char getNameSeparator() {
        return this.nameSeparator;
    }

    public String[] getReservedFileNames() {
        return (String[])this.reservedFileNames.clone();
    }

    public boolean isCasePreserving() {
        return this.casePreserving;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean isIllegalFileNameChar(int c) {
        return Arrays.binarySearch(this.illegalFileNameChars, c) >= 0;
    }

    public boolean isLegalFileName(CharSequence candidate) {
        return this.isLegalFileName(candidate, Charset.defaultCharset());
    }

    public boolean isLegalFileName(CharSequence candidate, Charset charset) {
        return candidate != null && candidate.length() != 0 && this.nameLengthStrategy.isWithinLimit(candidate, this.getMaxFileNameLength(), charset) && !this.isReservedFileName(candidate) && candidate.chars().noneMatch(this::isIllegalFileNameChar);
    }

    public boolean isReservedFileName(CharSequence candidate) {
        CharSequence test = this.reservedFileNamesExtensions ? FileSystem.trimExtension(candidate) : candidate;
        return Arrays.binarySearch(this.reservedFileNames, test) >= 0;
    }

    public String normalizeSeparators(String path) {
        return FileSystem.replace(path, this.nameSeparatorOther, this.nameSeparator);
    }

    public boolean supportsDriveLetter() {
        return this.supportsDriveLetter;
    }

    public String toLegalFileName(CharSequence candidate, char replacement, Charset charset) {
        Objects.requireNonNull(candidate, "candidate");
        if (candidate.length() == 0) {
            throw new IllegalArgumentException("The candidate file name is empty");
        }
        if (this.isIllegalFileNameChar(replacement)) {
            throw new IllegalArgumentException(String.format("The replacement character '%s' cannot be one of the %s illegal characters: %s", replacement == '\u0000' ? "\\0" : Character.valueOf(replacement), this.name(), Arrays.toString(this.illegalFileNameChars)));
        }
        CharSequence truncated = this.nameLengthStrategy.truncate(candidate, this.getMaxFileNameLength(), charset);
        int[] array = truncated.chars().map(i -> this.isIllegalFileNameChar(i) ? replacement : i).toArray();
        return new String(array, 0, array.length);
    }

    public String toLegalFileName(String candidate, char replacement) {
        return this.toLegalFileName(candidate, replacement, Charset.defaultCharset());
    }

    private static /* synthetic */ FileSystem[] $values() {
        return new FileSystem[]{GENERIC, LINUX, MAC_OSX, WINDOWS};
    }

    static {
        $VALUES = FileSystem.$values();
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName(OS_NAME_WINDOWS_PREFIX);
        CURRENT = FileSystem.current();
    }

    static enum NameLengthStrategy {
        BYTES{

            @Override
            int getLength(CharSequence value, Charset charset) {
                CharsetEncoder enc = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                try {
                    return enc.encode(CharBuffer.wrap(value)).remaining();
                }
                catch (CharacterCodingException e) {
                    return Integer.MAX_VALUE;
                }
            }

            @Override
            CharSequence truncate(CharSequence value, int limit, Charset charset) {
                CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                if (!encoder.canEncode(value)) {
                    throw new IllegalArgumentException("The value " + value + " cannot be encoded using " + charset.name());
                }
                if ((double)value.length() <= Math.floor((float)limit / encoder.maxBytesPerChar())) {
                    return value;
                }
                CharSequence[] parts = FileSystem.splitExtension(value);
                int extensionLength = this.getLength(parts[1], charset);
                if (extensionLength > 0 && extensionLength >= limit) {
                    throw new IllegalArgumentException("The extension of " + value + " is too long to fit within " + limit + " bytes");
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(limit - extensionLength);
                CharBuffer charBuffer = CharBuffer.wrap(parts[0]);
                CoderResult cr = encoder.encode(charBuffer, byteBuffer, true);
                if (cr.isUnderflow()) {
                    return value;
                }
                CharSequence truncated = FileSystem.safeTruncate(value, charBuffer.position());
                return extensionLength == 0 ? truncated : truncated.toString() + parts[1];
            }
        }
        ,
        UTF16_CODE_UNITS{

            @Override
            int getLength(CharSequence value, Charset charset) {
                return value.length();
            }

            @Override
            CharSequence truncate(CharSequence value, int limit, Charset charset) {
                if (!StandardCharsets.UTF_16.newEncoder().canEncode(value)) {
                    throw new IllegalArgumentException("The value " + value + " can not be encoded using " + StandardCharsets.UTF_16.name());
                }
                if (value.length() <= limit) {
                    return value;
                }
                CharSequence[] parts = FileSystem.splitExtension(value);
                int extensionLength = parts[1].length();
                if (extensionLength > 0 && extensionLength >= limit) {
                    throw new IllegalArgumentException("The extension of " + value + " is too long to fit within " + limit + " characters");
                }
                CharSequence truncated = FileSystem.safeTruncate(value, limit - extensionLength);
                return extensionLength == 0 ? truncated : truncated.toString() + parts[1];
            }
        };


        abstract int getLength(CharSequence var1, Charset var2);

        final boolean isWithinLimit(CharSequence value, int limit, Charset charset) {
            return this.getLength(value, charset) <= limit;
        }

        abstract CharSequence truncate(CharSequence var1, int var2, Charset var3);
    }
}

