/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.jexl2.internal.introspection.ClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodKey {
    private final int hashCode;
    private final String method;
    private final Class<?>[] params;
    private static final Class<?>[] NOARGS = new Class[0];
    private static final int HASH = 37;
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    private static final Parameters<Method> METHODS = new Parameters<Method>(){

        @Override
        protected Class<?>[] getParameterTypes(Method app) {
            return app.getParameterTypes();
        }
    };
    private static final Parameters<Constructor<?>> CONSTRUCTORS = new Parameters<Constructor<?>>(){

        @Override
        protected Class<?>[] getParameterTypes(Constructor<?> app) {
            return app.getParameterTypes();
        }
    };

    public MethodKey(String aMethod, Object[] args) {
        int size;
        this.method = aMethod;
        int hash2 = this.method.hashCode();
        if (args != null && (size = args.length) > 0) {
            this.params = new Class[size];
            for (int p = 0; p < size; ++p) {
                Object arg = args[p];
                Class parm = arg == null ? Void.class : arg.getClass();
                hash2 = 37 * hash2 + parm.hashCode();
                this.params[p] = parm;
            }
        } else {
            this.params = NOARGS;
        }
        this.hashCode = hash2;
    }

    MethodKey(Method aMethod) {
        this(aMethod.getName(), aMethod.getParameterTypes());
    }

    MethodKey(String aMethod, Class<?>[] args) {
        int size;
        this.method = aMethod.intern();
        int hash2 = this.method.hashCode();
        if (args != null && (size = args.length) > 0) {
            this.params = new Class[size];
            for (int p = 0; p < size; ++p) {
                Class<?> parm = ClassMap.MethodCache.primitiveClass(args[p]);
                hash2 = 37 * hash2 + parm.hashCode();
                this.params[p] = parm;
            }
        } else {
            this.params = NOARGS;
        }
        this.hashCode = hash2;
    }

    String getMethod() {
        return this.method;
    }

    Class<?>[] getParameters() {
        return this.params;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodKey) {
            MethodKey key = (MethodKey)obj;
            return this.method.equals(key.method) && Arrays.equals(this.params, key.params);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.method);
        for (Class<?> c : this.params) {
            builder.append(c == Void.class ? "null" : c.getName());
        }
        return builder.toString();
    }

    public String debugString() {
        StringBuilder builder = new StringBuilder(this.method);
        builder.append('(');
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Void.class == this.params[i] ? "null" : this.params[i].getName());
        }
        builder.append(')');
        return builder.toString();
    }

    public Method getMostSpecificMethod(List<Method> methods) {
        return (Method)((Parameters)MethodKey.METHODS).getMostSpecific(methods, this.params);
    }

    public Constructor<?> getMostSpecificConstructor(List<Constructor<?>> methods) {
        return (Constructor)((Parameters)MethodKey.CONSTRUCTORS).getMostSpecific(methods, this.params);
    }

    public static boolean isInvocationConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (actual != null && formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && actual == Boolean.class) {
                return true;
            }
            if (formal == Character.TYPE && actual == Character.class) {
                return true;
            }
            if (formal == Byte.TYPE && actual == Byte.class) {
                return true;
            }
            if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
        }
        if (possibleVarArg && formal.isArray()) {
            if (actual != null && actual.isArray()) {
                actual = actual.getComponentType();
            }
            return MethodKey.isInvocationConvertible(formal.getComponentType(), actual, false);
        }
        return false;
    }

    public static boolean isStrictInvocationConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Short.TYPE && actual == Byte.TYPE) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Float.TYPE || actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
        }
        if (possibleVarArg && formal.isArray()) {
            if (actual != null && actual.isArray()) {
                actual = actual.getComponentType();
            }
            return MethodKey.isStrictInvocationConvertible(formal.getComponentType(), actual, false);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Parameters<T> {
        private Parameters() {
        }

        protected abstract Class<?>[] getParameterTypes(T var1);

        private T getMostSpecific(List<T> methods, Class<?>[] classes) {
            LinkedList<T> applicables = this.getApplicables(methods, classes);
            if (applicables.isEmpty()) {
                return null;
            }
            if (applicables.size() == 1) {
                return applicables.getFirst();
            }
            LinkedList maximals = new LinkedList();
            for (Object app : applicables) {
                Class<?>[] appArgs = this.getParameterTypes(app);
                boolean lessSpecific = false;
                Iterator maximal = maximals.iterator();
                while (!lessSpecific && maximal.hasNext()) {
                    Object max = maximal.next();
                    switch (this.moreSpecific(appArgs, this.getParameterTypes(max))) {
                        case 0: {
                            maximal.remove();
                            break;
                        }
                        case 1: {
                            lessSpecific = true;
                        }
                    }
                }
                if (lessSpecific) continue;
                maximals.addLast(app);
            }
            if (maximals.size() > 1) {
                throw new AmbiguousException();
            }
            return (T)maximals.getFirst();
        }

        private int moreSpecific(Class<?>[] c1, Class<?>[] c2) {
            boolean c1MoreSpecific = false;
            boolean c2MoreSpecific = false;
            if (c1.length > c2.length) {
                return 0;
            }
            if (c2.length > c1.length) {
                return 1;
            }
            for (int i = 0; i < c1.length; ++i) {
                if (c1[i] == c2[i]) continue;
                boolean last = i == c1.length - 1;
                c1MoreSpecific = c1MoreSpecific || this.isStrictConvertible(c2[i], c1[i], last);
                c2MoreSpecific = c2MoreSpecific || this.isStrictConvertible(c1[i], c2[i], last);
            }
            if (c1MoreSpecific) {
                if (c2MoreSpecific) {
                    return 2;
                }
                return 0;
            }
            if (c2MoreSpecific) {
                return 1;
            }
            int primDiff = 0;
            for (int c = 0; c < c1.length; ++c) {
                if (c1[c].isPrimitive()) {
                    primDiff += 1 << c;
                }
                if (!c2[c].isPrimitive()) continue;
                primDiff -= 1 << c;
            }
            if (primDiff > 0) {
                return 0;
            }
            if (primDiff < 0) {
                return 1;
            }
            return 2;
        }

        private LinkedList<T> getApplicables(List<T> methods, Class<?>[] classes) {
            LinkedList<T> list = new LinkedList<T>();
            for (T method : methods) {
                if (!this.isApplicable(method, classes)) continue;
                list.add(method);
            }
            return list;
        }

        private boolean isApplicable(T method, Class<?>[] classes) {
            Class<?>[] methodArgs = this.getParameterTypes(method);
            if (methodArgs.length == classes.length || methodArgs.length == classes.length + 1 && methodArgs[methodArgs.length - 1].isArray()) {
                for (int i = 0; i < classes.length; ++i) {
                    if (this.isConvertible(methodArgs[i], classes[i], false)) continue;
                    if (i == classes.length - 1 && methodArgs[i].isArray()) {
                        return this.isConvertible(methodArgs[i], classes[i], true);
                    }
                    return false;
                }
                return true;
            }
            if (methodArgs.length > 0) {
                Class<?> lastarg = methodArgs[methodArgs.length - 1];
                if (!lastarg.isArray()) {
                    return false;
                }
                for (int i = 0; i < methodArgs.length - 1; ++i) {
                    if (this.isConvertible(methodArgs[i], classes[i], false)) continue;
                    return false;
                }
                Class<?> vararg = lastarg.getComponentType();
                for (int i = methodArgs.length - 1; i < classes.length; ++i) {
                    if (this.isConvertible(vararg, classes[i], false)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean isConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
            return MethodKey.isInvocationConvertible(formal, actual.equals(Void.class) ? null : actual, possibleVarArg);
        }

        private boolean isStrictConvertible(Class<?> formal, Class<?> actual, boolean possibleVarArg) {
            return MethodKey.isStrictInvocationConvertible(formal, actual.equals(Void.class) ? null : actual, possibleVarArg);
        }
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551664L;
    }
}

