/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.FileCreator;
import gov.nih.nlm.ncbi.ngs.HttpException;
import gov.nih.nlm.ncbi.ngs.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class HttpManager {
    static final int BUF_SZ = 131072;

    HttpManager() {
    }

    static String post(String string2, String string3) throws HttpException {
        Logger.fine(string2 + "?" + string3 + "...");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = HttpManager.getPostInputStream(string2, string3);
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new HttpException(-3);
        }
        try {
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
            throw new HttpException(-4);
        }
    }

    static int post(String string2, String string3, FileCreator fileCreator, String string4) {
        Logger.fine(string2 + "?" + string3 + " -> " + string4 + "...");
        try {
            InputStream inputStream = HttpManager.getPostInputStream(string2, string3);
            if (HttpManager.download(inputStream, fileCreator, string4)) {
                return 200;
            }
            return -3;
        }
        catch (HttpException httpException) {
            return httpException.getResponseCode();
        }
    }

    private static boolean get(String string2, FileCreator fileCreator, String string3) {
        System.err.println(string2 + " ->" + string3 + "...");
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL: " + string2 + ": " + malformedURLException);
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            System.err.println("Cannot download " + string2 + ": " + iOException);
            return false;
        }
        return HttpManager.download(inputStream, fileCreator, string3);
    }

    private static InputStream getPostInputStream(String string2, String string3) throws HttpException {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL: " + string2 + ": " + malformedURLException);
            throw new HttpException(-1);
        }
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream outputStream = uRLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes(string3);
            dataOutputStream.flush();
            dataOutputStream.close();
            inputStream = uRLConnection.getInputStream();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new HttpException(n);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            throw new HttpException(-2);
        }
        return inputStream;
    }

    private static boolean download(InputStream inputStream, FileCreator fileCreator, String string2) {
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = fileCreator.create(string2);
        if (bufferedOutputStream == null) {
            System.err.println("Not possible to create a file for downloading");
            fileCreator.done(bl);
            return bl;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[131072];
        while (true) {
            int n = 0;
            try {
                n = bufferedInputStream.read(byArray, 0, 131072);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                fileCreator.done(bl);
                return bl;
            }
            if (n == -1) break;
            try {
                bufferedOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                fileCreator.done(bl);
                return bl;
            }
        }
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            fileCreator.done(bl);
            return bl;
        }
        bl = true;
        fileCreator.done(bl);
        return bl;
    }
}

