/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.rans.RANS;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class RANSExternalCompressor
extends ExternalCompressor {
    private final RANS.ORDER order;
    private final RANS rans;

    public RANSExternalCompressor(RANS rans) {
        this(RANS.ORDER.ZERO, rans);
    }

    public RANSExternalCompressor(int order2, RANS rans) {
        this(RANS.ORDER.fromInt(order2), rans);
    }

    public RANSExternalCompressor(RANS.ORDER order2, RANS rans) {
        super(BlockCompressionMethod.RANS);
        this.rans = rans;
        this.order = order2;
    }

    @Override
    public byte[] compress(byte[] data) {
        ByteBuffer buffer = this.rans.compress(ByteBuffer.wrap(data), this.order);
        return this.toByteArray(buffer);
    }

    @Override
    public byte[] uncompress(byte[] data) {
        ByteBuffer buf = this.rans.uncompress(ByteBuffer.wrap(data));
        return this.toByteArray(buf);
    }

    public RANS.ORDER getOrder() {
        return this.order;
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", new Object[]{this.getMethod(), this.order});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RANSExternalCompressor that = (RANSExternalCompressor)o;
        return this.order == that.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMethod(), this.order});
    }

    private byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

