/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.index.IndexCreator;
import java.util.LinkedHashMap;

public abstract class TribbleIndexCreator
implements IndexCreator {
    private static final String SEQUENCE_DICTIONARY_PROPERTY_PREDICATE = "DICT:";
    protected LinkedHashMap<String, String> properties = new LinkedHashMap();

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void setIndexSequenceDictionary(SAMSequenceDictionary dict) {
        for (SAMSequenceRecord seq2 : dict.getSequences()) {
            String contig = SEQUENCE_DICTIONARY_PROPERTY_PREDICATE + seq2.getSequenceName();
            String length = String.valueOf(seq2.getSequenceLength());
            this.addProperty(contig, length);
        }
    }
}

