/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlArithmetic {
    protected static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    protected static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    protected static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final int BIGD_SCALE = -1;
    private volatile boolean strict;
    protected final MathContext mathContext;
    protected final int mathScale;

    public JexlArithmetic(boolean lenient) {
        this(lenient, MathContext.DECIMAL128, -1);
    }

    public JexlArithmetic(boolean lenient, MathContext bigdContext, int bigdScale) {
        this.strict = !lenient;
        this.mathContext = bigdContext;
        this.mathScale = bigdScale;
    }

    @Deprecated
    void setLenient(boolean flag) {
        this.strict = !flag;
    }

    public boolean isLenient() {
        return !this.strict;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public int getMathScale() {
        return this.mathScale;
    }

    public BigDecimal roundBigDecimal(BigDecimal number) {
        int mscale = this.getMathScale();
        if (mscale >= 0) {
            return number.setScale(mscale, this.getMathContext().getRoundingMode());
        }
        return number;
    }

    protected Object controlNullNullOperands() {
        if (!this.isLenient()) {
            throw new ArithmeticException("jexl.null");
        }
        return 0;
    }

    protected void controlNullOperand() {
        if (!this.isLenient()) {
            throw new ArithmeticException("jexl.null");
        }
    }

    protected boolean isFloatingPointType(Object left, Object right) {
        return left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double;
    }

    protected boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof String) {
            String string2 = (String)val;
            return string2.indexOf(46) != -1 || string2.indexOf(101) != -1 || string2.indexOf(69) != -1;
        }
        return false;
    }

    protected boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    protected boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }

    protected Number narrowBigInteger(Object lhs, Object rhs, BigInteger bigi) {
        if (!(lhs instanceof BigInteger) && !(rhs instanceof BigInteger) && bigi.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigi.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigi.longValue();
            if (!(lhs instanceof Long) && !(rhs instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
            return l;
        }
        return bigi;
    }

    protected Number narrowBigDecimal(Object lhs, Object rhs, BigDecimal bigd) {
        if (this.isNumberable(lhs) || this.isNumberable(rhs)) {
            try {
                long l = bigd.longValueExact();
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return (int)l;
                }
                return l;
            }
            catch (ArithmeticException xa) {
                // empty catch block
            }
        }
        return bigd;
    }

    protected Object narrowArrayType(Object[] untyped) {
        int size = untyped.length;
        Class<Object> commonClass = null;
        if (size > 0) {
            boolean isNumber = true;
            block2: for (int u = 0; u < size && !Object.class.equals(commonClass); ++u) {
                if (untyped[u] != null) {
                    Class eclass = untyped[u].getClass();
                    if (commonClass == null) {
                        commonClass = eclass;
                        isNumber &= Number.class.isAssignableFrom(commonClass);
                        continue;
                    }
                    if (commonClass.equals(eclass)) continue;
                    if (isNumber && Number.class.isAssignableFrom(eclass)) {
                        commonClass = Number.class;
                        continue;
                    }
                    do {
                        if ((eclass = eclass.getSuperclass()) != null) continue;
                        commonClass = Object.class;
                        continue block2;
                    } while (!commonClass.isAssignableFrom(eclass));
                    continue;
                }
                isNumber = false;
            }
            if (commonClass != null && !Object.class.equals(commonClass)) {
                if (isNumber) {
                    try {
                        Field type = commonClass.getField("TYPE");
                        commonClass = (Class)type.get(null);
                    }
                    catch (Exception xany) {
                        // empty catch block
                    }
                }
                Object typed = Array.newInstance(commonClass, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(typed, i, untyped[i]);
                }
                return typed;
            }
        }
        return untyped;
    }

    protected boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        for (int a = 0; a < args.length; ++a) {
            Object arg = args[a];
            if (!(arg instanceof Number)) continue;
            Number narg = this.narrow((Number)arg);
            if (narg != arg) {
                narrowed = true;
            }
            args[a] = narg;
        }
        return narrowed;
    }

    public Object add(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        try {
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return new Double(l + r);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                BigDecimal result = l.add(r, this.getMathContext());
                return this.narrowBigDecimal(left, right, result);
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            BigInteger result = l.add(r);
            return this.narrowBigInteger(left, right, result);
        }
        catch (NumberFormatException nfe) {
            return this.toString(left).concat(this.toString(right));
        }
    }

    public Object divide(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("/");
            }
            return new Double(l / r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("/");
            }
            BigDecimal result = l.divide(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("/");
        }
        BigInteger result = l.divide(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object mod(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("%");
            }
            return new Double(l % r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("%");
            }
            BigDecimal remainder = l.remainder(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, remainder);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.mod(r);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("%");
        }
        return this.narrowBigInteger(left, right, result);
    }

    public Object multiply(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            return new Double(l * r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            BigDecimal result = l.multiply(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.multiply(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object subtract(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            return new Double(l - r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            BigDecimal result = l.subtract(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.subtract(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object negate(Object val) {
        if (val instanceof Integer) {
            int valueAsInt = (Integer)val;
            return -valueAsInt;
        }
        if (val instanceof Double) {
            double valueAsDouble = (Double)val;
            return new Double(-valueAsDouble);
        }
        if (val instanceof Long) {
            long valueAsLong = -((Long)val).longValue();
            return valueAsLong;
        }
        if (val instanceof BigDecimal) {
            BigDecimal valueAsBigD = (BigDecimal)val;
            return valueAsBigD.negate();
        }
        if (val instanceof BigInteger) {
            BigInteger valueAsBigI = (BigInteger)val;
            return valueAsBigI.negate();
        }
        if (val instanceof Float) {
            float valueAsFloat = ((Float)val).floatValue();
            return new Float(-valueAsFloat);
        }
        if (val instanceof Short) {
            short valueAsShort = (Short)val;
            return -valueAsShort;
        }
        if (val instanceof Byte) {
            byte valueAsByte = (Byte)val;
            return -valueAsByte;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new ArithmeticException("Object negation:(" + val + ")");
    }

    public boolean matches(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        String arg = left.toString();
        if (right instanceof Pattern) {
            return ((Pattern)right).matcher(arg).matches();
        }
        return arg.matches(right.toString());
    }

    public Object bitwiseAnd(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l & r;
    }

    public Object bitwiseOr(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l | r;
    }

    public Object bitwiseXor(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l ^ r;
    }

    public Object bitwiseComplement(Object val) {
        long l = this.toLong(val);
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    protected int compare(Object left, Object right, String operator) {
        if (left != null && right != null) {
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                return l.compareTo(r);
            }
            if (left instanceof BigInteger || right instanceof BigInteger) {
                BigInteger l = this.toBigInteger(left);
                BigInteger r = this.toBigInteger(right);
                return l.compareTo(r);
            }
            if (this.isFloatingPoint(left) || this.isFloatingPoint(right)) {
                double lhs = this.toDouble(left);
                double rhs = this.toDouble(right);
                if (Double.isNaN(lhs)) {
                    if (Double.isNaN(rhs)) {
                        return 0;
                    }
                    return -1;
                }
                if (Double.isNaN(rhs)) {
                    return 1;
                }
                if (lhs < rhs) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
            if (this.isNumberable(left) || this.isNumberable(right)) {
                long rhs;
                long lhs = this.toLong(left);
                if (lhs < (rhs = this.toLong(right))) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
            if (left instanceof String || right instanceof String) {
                return this.toString(left).compareTo(this.toString(right));
            }
            if ("==".equals(operator)) {
                return left.equals(right) ? 0 : -1;
            }
            if (left instanceof Comparable) {
                Comparable comparable = (Comparable)left;
                return comparable.compareTo(right);
            }
            if (right instanceof Comparable) {
                Comparable comparable = (Comparable)right;
                return comparable.compareTo(left);
            }
        }
        throw new ArithmeticException("Object comparison:(" + left + " " + operator + " " + right + ")");
    }

    public boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return this.toBoolean(left) == this.toBoolean(right);
        }
        return this.compare(left, right, "==") == 0;
    }

    public boolean lessThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, "<") < 0;
    }

    public boolean greaterThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, ">") > 0;
    }

    public boolean lessThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, "<=") <= 0;
    }

    public boolean greaterThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, ">=") >= 0;
    }

    public boolean toBoolean(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            double number = this.toDouble(val);
            return !Double.isNaN(number) && number != 0.0;
        }
        if (val instanceof String) {
            String strval = val.toString();
            return strval.length() > 0 && !"false".equals(strval);
        }
        return false;
    }

    public int toInteger(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0;
        }
        if (val instanceof Double) {
            if (!Double.isNaN((Double)val)) {
                return 0;
            }
            return ((Double)val).intValue();
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0;
            }
            return Integer.parseInt((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        throw new ArithmeticException("Integer coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    public long toLong(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0L;
        }
        if (val instanceof Double) {
            if (!Double.isNaN((Double)val)) {
                return 0L;
            }
            return ((Double)val).longValue();
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0L;
            }
            return Long.parseLong((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        throw new ArithmeticException("Long coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    public BigInteger toBigInteger(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return BigInteger.ZERO;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof Double) {
            if (!Double.isNaN((Double)val)) {
                return new BigInteger(val.toString());
            }
            return BigInteger.ZERO;
        }
        if (val instanceof Number) {
            return new BigInteger(val.toString());
        }
        if (val instanceof String) {
            String string2 = (String)val;
            if ("".equals(string2.trim())) {
                return BigInteger.ZERO;
            }
            return new BigInteger(string2);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        throw new ArithmeticException("BigInteger coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    public BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return this.roundBigDecimal((BigDecimal)val);
        }
        if (val == null) {
            this.controlNullOperand();
            return BigDecimal.ZERO;
        }
        if (val instanceof String) {
            String string2 = ((String)val).trim();
            if ("".equals(string2)) {
                return BigDecimal.ZERO;
            }
            return this.roundBigDecimal(new BigDecimal(string2, this.getMathContext()));
        }
        if (val instanceof Double) {
            if (!Double.isNaN((Double)val)) {
                return this.roundBigDecimal(new BigDecimal(val.toString(), this.getMathContext()));
            }
            return BigDecimal.ZERO;
        }
        if (val instanceof Number) {
            return this.roundBigDecimal(new BigDecimal(val.toString(), this.getMathContext()));
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new BigDecimal(i);
        }
        throw new ArithmeticException("BigDecimal coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    public double toDouble(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0.0;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return Double.parseDouble(String.valueOf(val));
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (val instanceof String) {
            String string2 = ((String)val).trim();
            if ("".equals(string2)) {
                return Double.NaN;
            }
            return Double.parseDouble(string2);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return i;
        }
        throw new ArithmeticException("Double coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    public String toString(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return "";
        }
        if (val instanceof Double) {
            Double dval = (Double)val;
            if (Double.isNaN(dval)) {
                return "";
            }
            return dval.toString();
        }
        return val.toString();
    }

    public Number narrow(Number original) {
        return this.narrowNumber(original, null);
    }

    protected boolean narrowAccept(Class<?> narrow, Class<?> source) {
        return narrow == null || narrow.equals(source);
    }

    protected Number narrowNumber(Number original, Class<?> narrow) {
        if (original == null) {
            return original;
        }
        Number result = original;
        if (original instanceof BigDecimal) {
            BigDecimal bigd = (BigDecimal)original;
            if (bigd.compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
                return original;
            }
            try {
                long l = bigd.longValueExact();
                if (this.narrowAccept(narrow, Integer.class) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return (int)l;
                }
                if (this.narrowAccept(narrow, Long.class)) {
                    return l;
                }
            }
            catch (ArithmeticException xa) {
                // empty catch block
            }
        }
        if (original instanceof Double || original instanceof Float || original instanceof BigDecimal) {
            double value = original.doubleValue();
            if (this.narrowAccept(narrow, Float.class) && value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(result.floatValue());
            }
        } else {
            BigInteger bigi;
            if (original instanceof BigInteger && ((bigi = (BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || bigi.compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            if (this.narrowAccept(narrow, Byte.class) && value <= 127L && value >= -128L) {
                result = (byte)value;
            } else if (this.narrowAccept(narrow, Short.class) && value <= 32767L && value >= -32768L) {
                result = (short)value;
            } else if (this.narrowAccept(narrow, Integer.class) && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = (int)value;
            }
        }
        return result;
    }
}

