/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.parser$package$;
import org.broadinstitute.gpp.poolq3.types.Read;
import org.broadinstitute.gpp.poolq3.types.Read$;

public class TextParser
extends CloseableIterable<Read> {
    private final Path file;

    public TextParser(Path file) {
        this.file = file;
    }

    @Override
    public CloseableIterator<Read> iterator() {
        return new TextIterator(parser$package$.MODULE$.inputStream(this.file));
    }

    public class TextIterator
    extends CloseableIterator<Read> {
        private final BufferedReader reader;
        private int lineNo;
        private String line;

        public TextIterator(InputStream is) {
            if (TextParser.this == null) {
                throw new NullPointerException();
            }
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.lineNo = 1;
            this.line = this.reader.readLine();
        }

        @Override
        public final Read next() {
            if (this.line == null) {
                throw new NoSuchElementException();
            }
            Read ret = Read$.MODULE$.apply(new StringBuilder(5).append("Line ").append(this.lineNo).toString(), this.line);
            this.line = this.reader.readLine();
            ++this.lineNo;
            return ret;
        }

        @Override
        public final boolean hasNext() {
            return this.line != null;
        }

        @Override
        public final void close() {
            this.reader.close();
        }

        public final /* synthetic */ TextParser org$broadinstitute$gpp$poolq3$parser$TextParser$TextIterator$$$outer() {
            return TextParser.this;
        }
    }
}

