/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import org.broadinstitute.gpp.poolq3.process.BarcodeStats;
import scala.Tuple2;

public final class State {
    private final ShardedHistogram known;
    private final Histogram knownCol;
    private final Histogram unknownCol;
    private final Histogram unknownUmi;
    private long reads;
    private long exactMatches;
    private long matches;
    private long neitherRowBarcodeFound;
    private long umiBarcodeNotFound;
    private final BarcodeStats rowBarcodeStats;
    private final BarcodeStats revRowBarcodeStats;

    public State(ShardedHistogram<String, Tuple2<String, String>> known, Histogram<String> knownCol, Histogram<String> unknownCol, Histogram<String> unknownUmi) {
        this.known = known;
        this.knownCol = knownCol;
        this.unknownCol = unknownCol;
        this.unknownUmi = unknownUmi;
        this.reads = 0L;
        this.exactMatches = 0L;
        this.matches = 0L;
        this.neitherRowBarcodeFound = 0L;
        this.umiBarcodeNotFound = 0L;
        this.rowBarcodeStats = new BarcodeStats();
        this.revRowBarcodeStats = new BarcodeStats();
    }

    public ShardedHistogram<String, Tuple2<String, String>> known() {
        return this.known;
    }

    public Histogram<String> knownCol() {
        return this.knownCol;
    }

    public Histogram<String> unknownCol() {
        return this.unknownCol;
    }

    public Histogram<String> unknownUmi() {
        return this.unknownUmi;
    }

    public long reads() {
        return this.reads;
    }

    public void reads_$eq(long x$1) {
        this.reads = x$1;
    }

    public long exactMatches() {
        return this.exactMatches;
    }

    public void exactMatches_$eq(long x$1) {
        this.exactMatches = x$1;
    }

    public long matches() {
        return this.matches;
    }

    public void matches_$eq(long x$1) {
        this.matches = x$1;
    }

    public long neitherRowBarcodeFound() {
        return this.neitherRowBarcodeFound;
    }

    public void neitherRowBarcodeFound_$eq(long x$1) {
        this.neitherRowBarcodeFound = x$1;
    }

    public long rowBarcodeNotFound() {
        return this.rowBarcodeStats().notFound(this.reads());
    }

    public long revRowBarcodeNotFound() {
        return this.revRowBarcodeStats().notFound(this.reads());
    }

    public long umiBarcodeNotFound() {
        return this.umiBarcodeNotFound;
    }

    public void umiBarcodeNotFound_$eq(long x$1) {
        this.umiBarcodeNotFound = x$1;
    }

    public BarcodeStats rowBarcodeStats() {
        return this.rowBarcodeStats;
    }

    public BarcodeStats revRowBarcodeStats() {
        return this.revRowBarcodeStats;
    }

    public double matchPercent() {
        if (this.reads() < 1L) {
            return 0.0;
        }
        return (double)(100L * this.matches()) / (double)this.reads();
    }
}

