/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.broadinstitute.gpp.poolq3.numeric.numeric$package$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.types.CorrelationFileType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class CorrelationFileWriter$
implements Serializable {
    private static final Logger log;
    public static final CorrelationFileWriter$ MODULE$;

    private CorrelationFileWriter$() {
    }

    static {
        MODULE$ = new CorrelationFileWriter$();
        log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CorrelationFileWriter$.class);
    }

    public Try<Option<CorrelationFileType$>> write(Path file, Map<String, Map<String, Object>> normalizedCounts, Reference rowReference, Reference colReference) {
        if (colReference.allIds().size() < 2 || rowReference.allBarcodes().size() < 2) {
            Logger Logger_this = log;
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn(new StringBuilder(46).append("Skipping correlation file for trivial dataset ").append(new StringBuilder(20).append("(").append(colReference.allIds().size()).append(" columns and ").append(rowReference.allBarcodes().size()).append(" rows)").toString()).toString());
            }
            return Success$.MODULE$.apply(None$.MODULE$);
        }
        PearsonsCorrelation cor = new PearsonsCorrelation();
        double[][] countsMatrix = this.makeCountsMatrix(normalizedCounts, rowReference, colReference);
        RealMatrix pearsonMatrix = cor.computeCorrelationMatrix(countsMatrix);
        return Using$.MODULE$.apply(() -> CorrelationFileWriter$.write$$anonfun$1(file), (Function1<PrintWriter, Some> & Serializable)pw -> {
            MODULE$.printHeaders(colReference, (PrintWriter)pw);
            colReference.allIds().indices().foreach(i -> {
                pw.print((String)colReference.allIds().apply(i));
                colReference.allIds().indices().foreach(j -> pw.print(new StringBuilder(1).append("\t").append(numeric$package$.MODULE$.Decimal00Format().format(pearsonMatrix.getEntry(i, j))).toString()));
                pw.println();
            });
            return Some$.MODULE$.apply(CorrelationFileType$.MODULE$);
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public void printHeaders(Reference colReference, PrintWriter pw) {
        pw.println(new StringBuilder(1).append("\t").append(colReference.allIds().mkString("\t")).toString());
    }

    private double[][] makeCountsMatrix(Map<String, Map<String, Object>> counts, Reference rowReference, Reference colReference) {
        double[][] matrix = new double[rowReference.allBarcodes().size()][colReference.allIds().size()];
        rowReference.allBarcodes().indices().foreach(i -> {
            String row = (String)rowReference.allBarcodes().apply(i);
            Map rowCounts = (Map)counts.apply(row);
            colReference.allIds().indices().foreach(j -> {
                matrix$2[i$2][j] = BoxesRunTime.unboxToDouble(rowCounts.apply(colReference.allIds().apply(j)));
            });
        });
        return matrix;
    }

    private static final PrintWriter write$$anonfun$1(Path file$1) {
        return new PrintWriter(file$1.toFile());
    }
}

