/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractMap;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.control.NonFatal$;

public final class UnexpectedSequenceWriter$
implements Serializable {
    private static final Logger log;
    public static final UnexpectedSequenceWriter$ MODULE$;

    private UnexpectedSequenceWriter$() {
    }

    static {
        MODULE$ = new UnexpectedSequenceWriter$();
        log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UnexpectedSequenceWriter$.class);
    }

    public Try<BoxedUnit> write(Path outputFile, Path unexpectedSequenceCacheDir, int nSequencesToReport, Reference colReference, Option<Reference> globalReference, int maxMapSize) {
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple2 = this.loadCache(unexpectedSequenceCacheDir, colReference, nSequencesToReport, maxMapSize);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, Map<String, Object>> h = tuple2._1();
        Vector<String> r = tuple2._2();
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple22 = Tuple2$.MODULE$.apply(h, r);
        Map<String, Map<String, Object>> h2 = tuple22._1();
        Vector<String> r2 = tuple22._2();
        return Using$.MODULE$.apply(() -> UnexpectedSequenceWriter$.write$$anonfun$1(outputFile), pw -> MODULE$.printUnexpectedCounts(colReference, globalReference, h2, r2, (PrintWriter)pw), Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public int write$default$6() {
        return 10000000;
    }

    public void removeCache(Path unexpectedSequenceCacheDir) {
        Files.list(unexpectedSequenceCacheDir).forEach(p -> this.tryDelete$1((Path)p));
        this.tryDelete$1(unexpectedSequenceCacheDir);
    }

    public Tuple2<Map<String, Map<String, Object>>, Vector<String>> loadCache(Path cacheDir, Reference colReference, int nSequencesToReport, int maxMapSize) {
        Tuple2<Map<String, Map<String, Object>>, Vector<String>> tuple2;
        HashMap rowColBarcodeCounts = new HashMap();
        Queue readers = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new UnexpectedSequenceWriter.CachedBarcodes[0]));
        try {
            colReference.allBarcodes().foreach(colBc -> {
                Path file = cacheDir.resolve(UnexpectedSequenceTracker$.MODULE$.nameFor((String)colBc));
                if (Files.exists(file, new LinkOption[0])) {
                    UnexpectedSequenceWriter.SourceCachedBarcodes cbc = new UnexpectedSequenceWriter.SourceCachedBarcodes((String)colBc, Source$.MODULE$.fromFile(file.toFile(), Codec$.MODULE$.fallbackSystemCodec()));
                    if (cbc.hasNext()) {
                        readers.enqueue(cbc);
                        return;
                    }
                    return;
                }
            });
            UnexpectedSequenceWriter.BreadthFirstIterator iterator = new UnexpectedSequenceWriter.BreadthFirstIterator(readers);
            while (rowColBarcodeCounts.size() < maxMapSize && iterator.hasNext()) {
                Object object = iterator.next();
                if (object == null) {
                    throw new MatchError(object);
                }
                String rowBc = (String)((Tuple2)object)._1();
                String colBc2 = (String)((Tuple2)object)._2();
                Tuple2<String, String> tuple22 = Tuple2$.MODULE$.apply(rowBc, colBc2);
                String rowBc2 = tuple22._1();
                String colBc3 = tuple22._2();
                scala.collection.mutable.Map colBarcodeMap = (scala.collection.mutable.Map)rowColBarcodeCounts.getOrElseUpdate(rowBc2, UnexpectedSequenceWriter$::$anonfun$1);
                Option option = colBarcodeMap.updateWith(colBc3, (Function1<Option, Option> & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(1));
                    }
                    if (option instanceof Some) {
                        int c = BoxesRunTime.unboxToInt(((Some)option).value());
                        return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(c + 1));
                    }
                    throw new MatchError(option);
                });
            }
            readers.foreach(rdr -> {
                rdr.foreach(rowBc -> rowColBarcodeCounts.get((String)rowBc).foreach(colBarcodeMap -> {
                    Option option = colBarcodeMap.updateWith(rdr.colBc(), (Function1<Option, Option> & Serializable)x$1 -> {
                        Option option = x$1;
                        if (None$.MODULE$.equals(option)) {
                            return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(1));
                        }
                        if (option instanceof Some) {
                            int c = BoxesRunTime.unboxToInt(((Some)option).value());
                            return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(c + 1));
                        }
                        throw new MatchError(option);
                    });
                }));
                rdr.close();
            });
            Ordering<String> stringOrd = package$.MODULE$.Ordering().apply(Ordering$String$.MODULE$);
            LazyRef lazyRef = new LazyRef();
            Vector mostCommonRowBarcodesRanked = (Vector)this.topNBy(rowColBarcodeCounts, nSequencesToReport, (Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
                String string2 = (String)x$1._1();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)x$1._2();
                return Tuple2$.MODULE$.apply(map.values().sum(Numeric$IntIsIntegral$.MODULE$), string2);
            }, package$.MODULE$.Ordering().apply(Ordering$.MODULE$.Tuple2(Ordering$Int$.MODULE$, this.given_Ordering_String$1(lazyRef, stringOrd)))).map((Function1<Tuple2, String> & Serializable)_$1 -> (String)_$1._2());
            Set mostCommonRowBarcodes = mostCommonRowBarcodesRanked.toSet();
            tuple2 = Tuple2$.MODULE$.apply(((AbstractMap)((Object)rowColBarcodeCounts.filterInPlace((Function2<String, scala.collection.mutable.Map, boolean> & Serializable)(x$1, x$2) -> {
                Tuple2<String, scala.collection.mutable.Map> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    String rowBc = tuple2._1();
                    return mostCommonRowBarcodes.apply(rowBc);
                }
                throw new MatchError(tuple2);
            }))).view().mapValues((Function1<scala.collection.mutable.Map, Map> & Serializable)m -> m.toMap($less$colon$less$.MODULE$.refl())).toMap($less$colon$less$.MODULE$.refl()), mostCommonRowBarcodesRanked);
        }
        finally {
            readers.foreach(_$2 -> _$2.close());
        }
        return tuple2;
    }

    public <A, B> Vector<B> topNBy(Iterable<A> xs, int n, Function1<A, B> f, Ordering<B> ord) {
        LazyRef lazyRef = new LazyRef();
        PriorityQueue pq = new PriorityQueue(this.given_Ordering_B$1(lazyRef, ord));
        xs.foreach(x -> {
            pq.addOne(f.apply(x));
            if (pq.size() > n) {
                Object a = pq.dequeue();
                return;
            }
        });
        Vector ret = pq.toVector();
        if (ret.size() > n) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return (Vector)ret.reverse();
    }

    public void printUnexpectedCounts(Reference colReference, Option<Reference> globalReferenceOpt, Map<String, Map<String, Object>> h, Vector<String> rows, PrintWriter pw) {
        Seq colBarcodes = (Seq)colReference.allBarcodes().map((Function1<String, String> & Serializable)dnaBarcode -> colReference.referenceBarcodeForDnaBarcode((String)dnaBarcode));
        pw.println(this.headerText(colBarcodes));
        rows.foreach(rowBc -> {
            Map rowCounts = (Map)h.getOrElse((String)rowBc, UnexpectedSequenceWriter$::$anonfun$5);
            String possibleIds = (String)globalReferenceOpt.map((Function1<Reference, String> & Serializable)globalReference -> globalReference.idsForBarcode((String)rowBc).mkString(",")).getOrElse(UnexpectedSequenceWriter$::$anonfun$7);
            Seq counts = (Seq)colReference.allBarcodes().map((Function1<String, int> & Serializable)colBc -> BoxesRunTime.unboxToInt(rowCounts.getOrElse(colBc, UnexpectedSequenceWriter$::$anonfun$8$$anonfun$1)));
            int total = BoxesRunTime.unboxToInt(counts.sum(Numeric$IntIsIntegral$.MODULE$));
            pw.println(new StringBuilder(3).append((String)rowBc).append("\t").append(total).append("\t").append(counts.mkString("\t")).append("\t").append(possibleIds).toString());
        });
    }

    public String headerText(Seq<String> colBarcodes) {
        return new StringBuilder(29).append("Sequence\tTotal\t").append(colBarcodes.mkString("\t")).append("\tPotential IDs").toString();
    }

    private static final PrintWriter write$$anonfun$1(Path outputFile$1) {
        return new PrintWriter(outputFile$1.toFile());
    }

    private final void tryDelete$1(Path p) {
        try {
            Files.delete(p);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = option.get();
                Logger Logger_this = log;
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn(new StringBuilder(17).append("Unable to delete ").append(p.toAbsolutePath()).toString());
                }
            }
            throw throwable;
        }
    }

    private static final scala.collection.mutable.Map $anonfun$1() {
        return (scala.collection.mutable.Map)HashMap$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    private final Ordering given_Ordering_String$lzyINIT1$1(LazyRef given_Ordering_String$lzy1$1, Ordering stringOrd$1) {
        Ordering ordering;
        LazyRef lazyRef = given_Ordering_String$lzy1$1;
        synchronized (lazyRef) {
            ordering = (Ordering)(given_Ordering_String$lzy1$1.initialized() ? given_Ordering_String$lzy1$1.value() : given_Ordering_String$lzy1$1.initialize(stringOrd$1.reverse()));
        }
        return ordering;
    }

    private final Ordering given_Ordering_String$1(LazyRef given_Ordering_String$lzy1$2, Ordering stringOrd$2) {
        return (Ordering)(given_Ordering_String$lzy1$2.initialized() ? given_Ordering_String$lzy1$2.value() : this.given_Ordering_String$lzyINIT1$1(given_Ordering_String$lzy1$2, stringOrd$2));
    }

    private final Ordering given_Ordering_B$lzyINIT1$1(LazyRef given_Ordering_B$lzy1$1, Ordering ord$1) {
        Ordering ordering;
        LazyRef lazyRef = given_Ordering_B$lzy1$1;
        synchronized (lazyRef) {
            ordering = (Ordering)(given_Ordering_B$lzy1$1.initialized() ? given_Ordering_B$lzy1$1.value() : given_Ordering_B$lzy1$1.initialize(ord$1.reverse()));
        }
        return ordering;
    }

    private final Ordering given_Ordering_B$1(LazyRef given_Ordering_B$lzy1$2, Ordering ord$2) {
        return (Ordering)(given_Ordering_B$lzy1$2.initialized() ? given_Ordering_B$lzy1$2.value() : this.given_Ordering_B$lzyINIT1$1(given_Ordering_B$lzy1$2, ord$2));
    }

    private static final Map $anonfun$5() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final int $anonfun$8$$anonfun$1() {
        return 0;
    }
}

