/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.DownloadManager;
import gov.nih.nlm.ncbi.ngs.FileCreator;
import gov.nih.nlm.ncbi.ngs.LMProperties;
import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.LibVersionChecker;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Version;
import gov.nih.nlm.ncbi.ngs.error.LibraryIncompatibleVersionError;
import gov.nih.nlm.ncbi.ngs.error.LibraryLoadError;
import gov.nih.nlm.ncbi.ngs.error.LibraryNotFoundError;
import gov.nih.nlm.ncbi.ngs.error.cause.ConnectionProblemCause;
import gov.nih.nlm.ncbi.ngs.error.cause.DownloadDisabledCause;
import gov.nih.nlm.ncbi.ngs.error.cause.InvalidLibraryCause;
import gov.nih.nlm.ncbi.ngs.error.cause.JvmErrorCause;
import gov.nih.nlm.ncbi.ngs.error.cause.LibraryLoadCause;
import gov.nih.nlm.ncbi.ngs.error.cause.OutdatedJarCause;
import gov.nih.nlm.ncbi.ngs.error.cause.PrereleaseReqLibCause;
import gov.nih.nlm.ncbi.ngs.error.cause.UnsupportedArchCause;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

class LibManager
implements FileCreator {
    private boolean JUST_DO_SIMPLE_LOAD_LIBRARY = false;
    private boolean SEARCH_FOR_LIBRARY = true;
    private boolean AUTO_DOWNLOAD = true;
    private static final long SEARCH_LIB_FREQUENCY_INTERVAL = 604800000L;
    private static final long CACHE_LATEST_VERSION_INTERVAL = 604800000L;
    private Location[] locations;
    private Map<String, String> libraryVersions = new HashMap<String, String>();
    private HashMap<String, Version> latestVersions = new HashMap();
    private DownloadManager downloadManager;
    private String createdFileName;
    private LMProperties properties;
    boolean mocksEnabled = false;
    Map<Location, Version> mockLocationVersions;
    DownloadManager.DownloadResult mockDownloadStatus;
    Throwable mockLoadException;
    String mockLoadedLibraryVersion;

    LibManager(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null || stringArray == null) {
            throw new RuntimeException("Neither libs nor versions can be null");
        }
        if (stringArray2.length != stringArray.length) {
            throw new RuntimeException("Invalid library versions: must match number of libraries");
        }
        this.checkSystemProperties();
        this.locations = this.generateLocations();
        for (int i = 0; i < stringArray.length; ++i) {
            this.libraryVersions.put(stringArray[i], stringArray2[i]);
        }
        this.properties = new LMProperties(LibManager.detectJVM().intString(), this.libraryVersions);
        if (this.AUTO_DOWNLOAD) {
            this.downloadManager = new DownloadManager(this.properties);
        }
        if (!this.JUST_DO_SIMPLE_LOAD_LIBRARY && System.getProperty("vdb.deleteLibraries") != null) {
            for (String string2 : stringArray) {
                Logger.warning("Deleting all JNI libraries...");
                LibPathIterator.deleteLibraries(this, string2);
            }
        }
    }

    private void checkSystemProperties() {
        String string2;
        String string3 = System.getProperty("vdb.System.loadLibrary");
        if (string3 != null && string3.equals("1")) {
            Logger.warning("Smart DLL search and library download was disabled");
            this.JUST_DO_SIMPLE_LOAD_LIBRARY = true;
            this.AUTO_DOWNLOAD = false;
            this.SEARCH_FOR_LIBRARY = false;
            return;
        }
        String string4 = System.getProperty("vdb.System.noLibraryDownload");
        if (string4 != null && string4.equals("1")) {
            Logger.warning("DLL download was disabled");
            this.AUTO_DOWNLOAD = false;
        }
        if ((string2 = System.getProperty("vdb.System.noLibrarySearch")) != null && string2.equals("1")) {
            Logger.warning("Search of installed DLL was disabled");
            this.SEARCH_FOR_LIBRARY = false;
        }
    }

    private Location[] generateLocations() {
        Location[] locationArray = Location.values();
        TreeSet<Location> treeSet = new TreeSet<Location>();
        if (this.JUST_DO_SIMPLE_LOAD_LIBRARY) {
            treeSet.addAll(Arrays.asList(locationArray));
            treeSet.remove((Object)Location.LIBPATH);
        }
        if (!this.AUTO_DOWNLOAD) {
            treeSet.add(Location.DOWNLOAD);
        }
        if (!this.SEARCH_FOR_LIBRARY) {
            TreeSet<Location> treeSet2 = new TreeSet<Location>(Arrays.asList(Location.CACHE, Location.LIBPATH, Location.DOWNLOAD));
            for (Location location : locationArray) {
                if (treeSet2.contains((Object)location)) continue;
                treeSet.add(location);
            }
        }
        if (treeSet.size() > 0) {
            Logger.info("Disabled locations: " + Arrays.toString(treeSet.toArray()));
        }
        Location[] locationArray2 = new Location[locationArray.length - treeSet.size()];
        int n = 0;
        for (Location location : locationArray) {
            if (treeSet.contains((Object)location)) continue;
            locationArray2[n++] = location;
        }
        assert (n == locationArray2.length);
        return locationArray2;
    }

    Location[] locations() {
        return this.locations;
    }

    @Override
    public BufferedOutputStream create(String string2) {
        this.createdFileName = null;
        int n = 0;
        if (n < 2) {
            Object object;
            String string3;
            Location location = null;
            boolean bl = true;
            switch (n) {
                case 0: {
                    location = Location.NCBI_HOME;
                    bl = false;
                    break;
                }
            }
            LibPathIterator libPathIterator = new LibPathIterator(this, location, LibManager.mapLibraryName(string2, bl), true);
            while (true) {
                if ((string3 = libPathIterator.nextName()) == null) {
                    return null;
                }
                Logger.fine("Trying to create " + string3 + "...");
                File file = new File(string3);
                try {
                    string3 = file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    Logger.warning(string3 + " : cannot getAbsolutePath " + securityException);
                    continue;
                }
                if (file.exists()) {
                    object = string3 + ".bak";
                    File file2 = new File((String)object);
                    String string4 = System.getProperty("os.name");
                    if (string4 != null && string4.startsWith("Win") && file2.exists()) {
                        Logger.fine("Trying to remove " + (String)object + " ...");
                        file2.delete();
                    }
                    Logger.finest("Trying to rename " + string3 + " to " + (String)object + " ...");
                    if (!file.renameTo(file2)) {
                        Logger.warning(string3 + ".renameTo(" + (String)object + ") failed");
                    }
                }
                object = null;
                try {
                    object = new FileOutputStream(string3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.warning("Cannot open " + string3);
                    continue;
                }
                break;
            }
            this.createdFileName = string3;
            Logger.fine("Opened " + string3);
            return new BufferedOutputStream((OutputStream)object, 131072);
        }
        return null;
    }

    @Override
    public void done(boolean bl) {
        if (!bl) {
            this.createdFileName = null;
        }
    }

    void loadLibrary(String string2) {
        Version version = this.getRequiredVersion(string2);
        boolean bl = Arrays.asList(this.locations).contains((Object)Location.CACHE);
        Logger.fine("Searching for " + string2 + " library...");
        try {
            LibSearchResult libSearchResult = this.searchLibrary(string2, version);
            if (libSearchResult.path == null) {
                throw new LibraryNotFoundError(string2, "No installed library was found", libSearchResult.failCause);
            }
            Logger.fine("Found " + string2 + " library");
            String string3 = libSearchResult.path;
            Logger.info("Loading " + string2 + "...");
            try {
                if (!this.mocksEnabled) {
                    if (string3.startsWith(string2)) {
                        System.loadLibrary(string3);
                    } else {
                        System.load(string3);
                    }
                } else if (this.mockLoadException != null) {
                    throw this.mockLoadException;
                }
            }
            catch (Throwable throwable) {
                if (libSearchResult.location != Location.DOWNLOAD) {
                    throw new LibraryLoadError(string2, "Failed to load found library " + string3, new JvmErrorCause(throwable));
                }
                throw new LibraryLoadError(string2, "No installed library was found and downloaded library '" + string3 + "' cannot be loaded", new JvmErrorCause(throwable), "Please install ngs and ncbi-vdb manually: https://github.com/ncbi/ngs/wiki/Downloads or write to \"sra-tools@ncbi.nlm.nih.gov\" if problems persist");
            }
            Logger.fine("Loaded " + string2 + " library");
            Logger.fine("Checking library " + string2 + " version...");
            String string4 = !this.mocksEnabled ? LibVersionChecker.getLoadedVersion(string2) : this.mockLoadedLibraryVersion;
            if (string4 == null) {
                throw new LibraryLoadError(string2, "Failed to retrieve loaded library's version", new InvalidLibraryCause());
            }
            Version version2 = new Version(string4);
            if (version2.compareTo(version) < 0 || !version2.isCompatible(version)) {
                Logger.fine("Library version is not compatible. Required: " + version.toSimpleVersion() + " loaded: " + version2.toSimpleVersion());
                LibraryLoadCause libraryLoadCause = libSearchResult.failCause;
                if (libSearchResult.location == Location.DOWNLOAD || libraryLoadCause == null) {
                    libraryLoadCause = version2.compareTo(version) < 0 ? new PrereleaseReqLibCause() : new OutdatedJarCause();
                }
                throw new LibraryIncompatibleVersionError(string2, "Library is incompatible", string3, libraryLoadCause);
            }
            Logger.fine("Library " + string2 + " was loaded successfully. Version = " + version2.toSimpleVersion());
            if (bl) {
                this.properties.loaded(string2, libSearchResult.version.toSimpleVersion(), string3);
                if (libSearchResult.location != Location.CACHE) {
                    this.properties.setLastSearch(string2);
                }
            }
        }
        catch (LibraryLoadError libraryLoadError) {
            if (bl) {
                this.properties.notLoaded(string2);
            }
            Logger.warning("Loading of " + string2 + " library failed");
            throw libraryLoadError;
        }
        finally {
            if (bl) {
                this.properties.store();
            }
        }
    }

    static String[] mapLibraryName(String string2) {
        return LibManager.mapLibraryName(string2, true);
    }

    static String[] mapLibraryName(String string2, boolean bl) {
        String string3 = string2;
        if (bl) {
            string3 = LibManager.libnameWithDataModel(string2);
        }
        String string4 = System.getProperty("os.name");
        int n = 1;
        if (string4 != null && string4.equals("Mac OS X")) {
            n = 2;
        }
        int n2 = (string3 == null ? 1 : 2) * n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        if (string3 != null) {
            stringArray[n3++] = System.mapLibraryName(string3);
        }
        stringArray[n3++] = System.mapLibraryName(string2);
        if (n == 2) {
            if (string3 != null) {
                stringArray[n3++] = string3 + ".dylib";
            }
            stringArray[n3++] = string2 + ".dylib";
        }
        return stringArray;
    }

    static Bits detectJVM() {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String string3 = System.getProperty(string2);
            Logger.finest(string2 + "=" + string3);
            if (string3 == null) continue;
            int n = string3.indexOf("64") >= 0 ? 64 : 32;
            Logger.finest(n + "-bit JVM");
            return n == 64 ? Bits.b64 : Bits.b32;
        }
        Logger.fine("Unknown-bit JVM");
        return Bits.bUNKNOWN;
    }

    private static String libnameWithDataModel(String string2) {
        String string3 = null;
        switch (LibManager.detectJVM()) {
            case b64: {
                string3 = "-64";
                break;
            }
            case b32: {
                string3 = "-32";
            }
        }
        if (string3 != null) {
            string3 = string2 + string3;
        }
        return string3;
    }

    private static Location[] getLocationProperty() {
        String string2 = System.getProperty("vdb.loadLibraryLocations");
        if (string2 == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if ("PJCLNTWD".indexOf(string2.charAt(i)) < 0) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Location[] locationArray = new Location[n];
        n = 0;
        block11: for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case 'P': {
                    locationArray[n] = Location.CLASSPATH;
                    break;
                }
                case 'J': {
                    locationArray[n] = Location.NCBI_NGS_JAR_DIR;
                    break;
                }
                case 'C': {
                    locationArray[n] = Location.CACHE;
                    break;
                }
                case 'L': {
                    locationArray[n] = Location.LIBPATH;
                    break;
                }
                case 'N': {
                    locationArray[n] = Location.NCBI_HOME;
                    break;
                }
                case 'T': {
                    locationArray[n] = Location.TMP;
                    break;
                }
                case 'W': {
                    locationArray[n] = Location.CWD;
                    break;
                }
                case 'D': {
                    locationArray[n] = Location.DOWNLOAD;
                    break;
                }
                default: {
                    continue block11;
                }
            }
            ++n;
        }
        return locationArray;
    }

    private Version checkLibraryVersion(String string2, String string3, boolean bl) {
        if (!bl && !LibManager.fileExists(string3)) {
            Logger.finer("File " + string3 + " not found");
            return null;
        }
        Version version = LibVersionChecker.getVersion(string2, string3, bl);
        if (version == null) {
            Logger.fine("Cannot load or get library version: " + string3);
        }
        return version;
    }

    private static boolean fileExists(String string2) {
        File file = new File(string2);
        if (file.exists()) {
            return true;
        }
        Logger.finest(string2 + " does not exist");
        return false;
    }

    private Version getRequiredVersion(String string2) {
        String string3 = this.libraryVersions.get(string2);
        if (string3 == null) {
            throw new RuntimeException("Library '" + string2 + "' version was not specified");
        }
        return new Version(string3);
    }

    private Version getLatestVersion(String string2) {
        if (this.latestVersions.containsKey(string2)) {
            return this.latestVersions.get(string2);
        }
        String string3 = this.properties.getLatestVersion(string2, 604800000L);
        if (string3 == null && this.AUTO_DOWNLOAD) {
            string3 = this.downloadManager.getLatestVersion(string2);
            if (string3 != null) {
                this.properties.setLatestVersion(string2, string3);
            }
        } else {
            Logger.fine("Cached LatestVersion (" + string2 + ") = " + string3);
        }
        Version version = null;
        if (string3 != null) {
            version = new Version(string3);
        }
        this.latestVersions.put(string2, version);
        return version;
    }

    private LibSearchResult searchLibrary(String string2, Version version) {
        LibSearchResult libSearchResult = new LibSearchResult();
        block5: for (Location location : this.locations) {
            String string3;
            Object object;
            Logger.info("Checking " + string2 + " from " + (Object)((Object)location) + "...");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            boolean bl2 = !this.JUST_DO_SIMPLE_LOAD_LIBRARY;
            switch (location) {
                case LIBPATH: {
                    arrayList.add(string2);
                    Object object2 = LibManager.libnameWithDataModel(string2);
                    if (object2 != null) {
                        arrayList.add(object2);
                    }
                    bl = true;
                    break;
                }
                case CACHE: {
                    Object object2 = this.properties.get(string2);
                    if (object2 == null) continue block5;
                    object = this.properties.getLastSeach(string2);
                    bl2 = object == null || new Date().getTime() - ((Date)object).getTime() > 604800000L;
                    arrayList.add(object2);
                    bl = object2.startsWith(string2);
                    break;
                }
                case DOWNLOAD: {
                    Object object2;
                    Logger.info("Downloading " + string2 + " from NCBI...");
                    if (!this.mocksEnabled) {
                        object2 = this.download(string2);
                    } else {
                        if (this.mockDownloadStatus == null) {
                            throw new RuntimeException("mockDownloadStatus must be set when mocks enabled");
                        }
                        object2 = new LibDownloadResult();
                        object2.status = this.mockDownloadStatus;
                        object2.savedPath = "/some/path/" + string2;
                    }
                    if (object2.status != DownloadManager.DownloadResult.SUCCESS) {
                        Logger.warning("Failed to download " + string2 + " from NCBI");
                        if (object2.status == DownloadManager.DownloadResult.UNSUPPORTED_OS) {
                            libSearchResult.failCause = new UnsupportedArchCause();
                            continue block5;
                        }
                        libSearchResult.failCause = new ConnectionProblemCause();
                        continue block5;
                    }
                    Logger.info("Downloaded " + string2 + " from NCBI");
                    Logger.fine("Checking " + string2 + " library...");
                    arrayList.add(object2.savedPath);
                    break;
                }
                default: {
                    Object object2 = LibManager.mapLibraryName(string2);
                    Logger.finest("System.mapLibraryName(" + string2 + ") = " + object2[0]);
                    object = new LibPathIterator(location, (String[])object2);
                    while ((string3 = ((LibPathIterator)object).nextName()) != null) {
                        arrayList.add(string3);
                    }
                    break block0;
                }
            }
            boolean bl3 = false;
            object = arrayList.iterator();
            while (object.hasNext()) {
                boolean bl4;
                Version version2;
                string3 = (String)object.next();
                if (!this.mocksEnabled) {
                    version2 = this.checkLibraryVersion(string2, string3, bl);
                } else {
                    if (this.mockLocationVersions == null) {
                        throw new RuntimeException("mockLocationVersions must be set when mocks enabled");
                    }
                    version2 = this.mockLocationVersions.get((Object)location);
                }
                if (version2 == null) continue;
                bl3 = true;
                boolean bl5 = bl4 = version2.isCompatible(version) && version2.compareTo(version) >= 0;
                if (libSearchResult.path == null || bl4 && version2.compareTo(libSearchResult.version) > 0 || !libSearchResult.versionFits) {
                    libSearchResult.versionFits = bl4;
                    libSearchResult.location = location;
                    libSearchResult.version = version2;
                    libSearchResult.path = string3;
                }
                if (!libSearchResult.versionFits || bl2) continue;
                break;
            }
            if (location == Location.DOWNLOAD && (!libSearchResult.versionFits || !bl3 && libSearchResult.path.equals(arrayList.get(0)))) {
                libSearchResult.versionFits = false;
                libSearchResult.location = location;
                libSearchResult.version = null;
                libSearchResult.path = (String)arrayList.get(0);
            }
            if (libSearchResult.version != null && libSearchResult.version.isCompatible(version) && ((object = this.getLatestVersion(string2)) == null && libSearchResult.version.compareTo(version) >= 0 && !bl2 || object != null && libSearchResult.version.compareTo(version) >= 0)) break;
        }
        boolean bl = Arrays.asList(this.locations).contains((Object)Location.DOWNLOAD);
        if (libSearchResult.failCause == null && !bl) {
            libSearchResult.failCause = new DownloadDisabledCause();
        }
        return libSearchResult;
    }

    private LibDownloadResult download(String string2) {
        if (!this.AUTO_DOWNLOAD) {
            throw new RuntimeException("AUTO_DOWNLOAD is disabled. This method should not be called");
        }
        LibDownloadResult libDownloadResult = new LibDownloadResult();
        Version version = this.getLatestVersion(string2);
        if (version == null) {
            libDownloadResult.status = DownloadManager.DownloadResult.FAILED;
            return libDownloadResult;
        }
        libDownloadResult.status = this.downloadManager.downloadLib(this, string2, version);
        if (libDownloadResult.status == DownloadManager.DownloadResult.SUCCESS) {
            libDownloadResult.savedPath = this.createdFileName;
            this.createdFileName = null;
            this.properties.saved(string2, version.toSimpleVersion(), libDownloadResult.savedPath);
        }
        return libDownloadResult;
    }

    private boolean downloadKfg(String string2) {
        Logger.finest("configuration download is disabled");
        return true;
    }

    private class LibDownloadResult {
        String savedPath = null;
        DownloadManager.DownloadResult status;

        private LibDownloadResult() {
        }
    }

    private class LibSearchResult {
        boolean versionFits = false;
        Location location = null;
        String path = null;
        Version version = null;
        LibraryLoadCause failCause = null;

        private LibSearchResult() {
        }
    }

    static enum Bits {
        b32,
        b64,
        bUNKNOWN;


        String intString() {
            switch (this) {
                case b32: {
                    return "32";
                }
            }
            return "64";
        }
    }

    static enum Location {
        CACHE,
        NCBI_HOME,
        LIBPATH,
        NCBI_NGS_JAR_DIR,
        CLASSPATH,
        CWD,
        TMP,
        DOWNLOAD;

    }
}

