/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.samtools.util.Locatable;

public class SequenceRegion
implements Locatable {
    private final int start;
    private final int end;
    private final String contig;
    private Boolean isCircular;
    private int hashCode;

    SequenceRegion(String contig, int start, int end) {
        this(contig, start, end, false);
    }

    SequenceRegion(String contig, int start, int end, boolean isCircular) {
        this.contig = contig;
        this.start = start;
        this.end = end;
        this.isCircular = isCircular;
        this.hashCode = this.computeHashCode();
    }

    void setCircular(boolean isCircular) {
        this.isCircular = isCircular;
        this.hashCode = this.computeHashCode();
    }

    void setCircular() {
        this.setCircular(true);
    }

    @Override
    public String getContig() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SequenceRegion)) {
            return false;
        }
        SequenceRegion otherSequenceRegion = (SequenceRegion)other;
        return otherSequenceRegion.start == this.start && otherSequenceRegion.end == this.end && otherSequenceRegion.contig.equals(this.contig) && otherSequenceRegion.isCircular == this.isCircular;
    }

    private int computeHashCode() {
        int hash2 = this.contig.hashCode();
        hash2 = 31 * hash2 + this.start;
        hash2 = 31 * hash2 + this.end;
        hash2 = 31 * hash2 + this.isCircular.hashCode();
        return hash2;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

