/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.Genotype;
import java.util.HashMap;

public class IntGenotypeFieldAccessors {
    private final HashMap<String, Accessor> intGenotypeFieldEncoders = new HashMap();

    public IntGenotypeFieldAccessors() {
        this.intGenotypeFieldEncoders.put("DP", new DPAccessor());
        this.intGenotypeFieldEncoders.put("AD", new ADAccessor());
        this.intGenotypeFieldEncoders.put("PL", new PLAccessor());
        this.intGenotypeFieldEncoders.put("GQ", new GQAccessor());
    }

    public Accessor getAccessor(String field2) {
        return this.intGenotypeFieldEncoders.get(field2);
    }

    public static class PLAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype g) {
            return g.getPL();
        }
    }

    public static class ADAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype g) {
            return g.getAD();
        }
    }

    public static class DPAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype g) {
            return g.getDP();
        }
    }

    public static class GQAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype g) {
            return Math.min(g.getGQ(), 99);
        }
    }

    private static abstract class AtomicAccessor
    extends Accessor {
        private final int[] singleton = new int[1];

        private AtomicAccessor() {
        }

        @Override
        public int[] getValues(Genotype g) {
            this.singleton[0] = this.getValue(g);
            return this.singleton[0] == -1 ? null : this.singleton;
        }

        public abstract int getValue(Genotype var1);
    }

    public static abstract class Accessor {
        public abstract int[] getValues(Genotype var1);

        public final int getSize(Genotype g) {
            int[] v = this.getValues(g);
            return v == null ? 0 : v.length;
        }
    }
}

