/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.util.control.NonFatal$;

public final class UnexpectedSequenceTracker
implements Closeable {
    private final Path cacheDir;
    private final Logger log;
    private final Map<String, BufferedWriter> outputFileWriters;

    public static String nameFor(String string2) {
        return UnexpectedSequenceTracker$.MODULE$.nameFor(string2);
    }

    public UnexpectedSequenceTracker(Path cacheDir, Reference colReference) {
        this.cacheDir = cacheDir;
        this.log = LoggerFactory.getLogger("org.broadinstitute.gpp.poolq3.process.UnexpectedSequenceTracker");
        Path path = Files.createDirectories(cacheDir, new FileAttribute[0]);
        this.outputFileWriters = ((IterableOnceOps)colReference.allBarcodes().map((Function1<String, Tuple2> & Serializable)barcode2 -> {
            String string2 = Predef$.MODULE$.ArrowAssoc(barcode2);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.newWriterFor((String)barcode2));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public void reportUnexpected(Tuple2<char[], char[]> barcodes) {
        Tuple2<char[], char[]> tuple2 = barcodes;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        char[] rowBarcode = tuple2._1();
        char[] columnBarcode = tuple2._2();
        Tuple2<char[], char[]> tuple22 = Tuple2$.MODULE$.apply(rowBarcode, columnBarcode);
        char[] rowBarcode2 = tuple22._1();
        char[] columnBarcode2 = tuple22._2();
        String rowBc = new String(rowBarcode2);
        String colBc = new String(columnBarcode2);
        BufferedWriter writer = (BufferedWriter)this.outputFileWriters.apply(colBc);
        writer.write(rowBc);
        writer.write("\n");
    }

    @Override
    public void close() {
        this.outputFileWriters.values().foreach(writer -> {
            try {
                writer.close();
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    Logger Logger_this = this.log;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error closing file", e);
                    }
                }
                throw throwable;
            }
        });
    }

    private BufferedWriter newWriterFor(String shard) {
        Path name = this.cacheDir.resolve(UnexpectedSequenceTracker$.MODULE$.nameFor(shard));
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(name, new OpenOption[0])));
    }
}

