/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

class Version
implements Comparable<Version> {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int RELEASE = 2;
    private static final int STAGE = 3;
    private static final int REVISION = 4;
    private int major;
    private int minor;
    private int release;
    private int revision;
    private Stage stage = Stage.FINAL;
    private String version;
    private static int verbose = 0;

    Version(String string2) {
        this.version = string2;
        if (string2 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (n2 == 3) {
                if (c == '.' || c == '-') {
                    n2 = 4;
                    continue;
                }
                if (Character.isDigit(c)) {
                    n2 = 4;
                    n = Character.getNumericValue(c);
                    continue;
                }
            }
            if (c == '.' || c == '-') {
                this.add(n2, n);
                n = 0;
                if (++n2 <= 4) continue;
                break;
            }
            if (c == 'a' || c == 'b' || c == 'r') {
                if (n2 != 3) {
                    this.add(n2, n);
                }
                n = 0;
                if (this.stage == Stage.FINAL) {
                    switch (c) {
                        case 'a': {
                            this.stage = Stage.ALPHA;
                            break;
                        }
                        case 'b': {
                            this.stage = Stage.BETA;
                            break;
                        }
                        case 'r': {
                            this.stage = Stage.RC;
                        }
                    }
                }
                n2 = 3;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            n = n * 10 + Character.getNumericValue(c);
        }
        this.add(n2, n);
    }

    public String toString() {
        return "{ " + Version.s(this.version) + " = " + this.major + "." + this.minor + "." + this.release + (Object)((Object)this.stage) + this.revision + " }";
    }

    public String toSimpleVersion() {
        return this.version == null ? "null" : this.version;
    }

    public boolean isCompatible(Version version) {
        return this.major == version.major;
    }

    public int getMajor() {
        return this.major;
    }

    @Override
    public int compareTo(Version version) {
        int n = 1;
        if (version == null) {
            this.v(version, n, 88);
            return n;
        }
        if (this.major > version.major) {
            this.v(version, n, 93);
            return n;
        }
        if (this.major < version.major) {
            n = -1;
            this.v(version, n, 97);
            return n;
        }
        if (this.minor > version.minor) {
            this.v(version, n, 102);
            return n;
        }
        if (this.minor < version.minor) {
            n = -1;
            this.v(version, n, 106);
            return n;
        }
        if (this.release > version.release) {
            this.v(version, n, 112);
            return n;
        }
        if (this.release < version.release) {
            n = -1;
            this.v(version, n, 116);
            return n;
        }
        if (this.stage.compareTo(version.stage) > 0) {
            this.v(version, n, 121);
            return n;
        }
        if (this.stage.compareTo(version.stage) < 0) {
            n = -1;
            this.v(version, n, 125);
            return n;
        }
        if (this.revision > version.revision) {
            this.v(version, n, 130);
            return n;
        }
        if (this.revision < version.revision) {
            n = -1;
            this.v(version, n, 134);
            return n;
        }
        n = 0;
        this.v(version, n, 140);
        return n;
    }

    private void add(int n, int n2) {
        switch (n) {
            case 0: {
                this.major = n2;
                break;
            }
            case 1: {
                this.minor = n2;
                break;
            }
            case 2: {
                this.release = n2;
                break;
            }
            case 3: 
            case 4: {
                this.revision = n2;
                break;
            }
        }
    }

    private void v(Version version, int n, int n2) {
        if (verbose > 1) {
            Version.l(this + ".compareTo(" + version + ") == " + n + " #" + n2);
        }
    }

    private static String s(String string2) {
        if (string2 == null) {
            return "null";
        }
        return "'" + string2 + "'";
    }

    private static void l(int n) {
        System.out.println(n);
    }

    private static void l(String string2) {
        System.out.println(string2);
    }

    private static void ok(String string2) {
        if (verbose == 0) {
            return;
        }
        Version.l("ok: " + string2);
    }

    private static void ko(String string2) {
        Version.l("KO: " + string2 + " ==========================");
    }

    private static boolean test(String string2, String string3, boolean bl) {
        boolean bl2 = true;
        Version version = new Version(string2);
        Version version2 = new Version(string3);
        int n = version.compareTo(version2);
        if (bl) {
            if (n == 0) {
                Version.ok(Version.s(string2) + " == " + Version.s(string3));
            } else {
                Version.ko(Version.s(string2) + " != " + Version.s(string3));
                bl2 = false;
            }
            if (version2.compareTo(version) != 0) {
                Version.ko(Version.s(string3) + " != " + Version.s(string2));
                bl2 = false;
            }
        } else {
            if (n < 0) {
                Version.ok(Version.s(string2) + " < " + Version.s(string3));
            } else {
                Version.ko(Version.s(string2) + " >= " + Version.s(string3));
                bl2 = false;
            }
            if (version2.compareTo(version) <= 0) {
                Version.ko(Version.s(string3) + " <= " + Version.s(string2));
                bl2 = false;
            }
        }
        if (verbose > 1) {
            Version.l("test(" + string2 + ", " + string3 + ") = " + bl2);
        }
        return bl2;
    }

    private static boolean testeq(String string2, String string3) {
        return Version.test(string2, string3, true);
    }

    private static boolean testlt(String string2, String string3) {
        return Version.test(string2, string3, false);
    }

    public static void main(String[] stringArray) {
        verbose = stringArray.length;
        boolean bl = true;
        bl &= Version.testeq(null, null);
        bl &= Version.testeq(null, "");
        bl &= Version.testeq("", "");
        bl &= Version.testeq("0", "");
        bl &= Version.testeq("0", "0");
        bl &= Version.testlt("0", "1");
        bl &= Version.testlt("2", "9");
        bl &= Version.testlt("9", "11");
        bl &= Version.testlt("08", "9");
        bl &= Version.testeq("080", "80");
        bl &= Version.testeq("0.5", ".5.0");
        bl &= Version.testeq("0.5", ".5.0.");
        bl &= Version.testeq("2.", "2");
        bl &= Version.testlt("1.2", "1.2.1");
        bl &= Version.testlt("1", "1.0.1");
        bl &= Version.testlt("1.0.1", "1.1");
        bl &= Version.testlt("1.2.9", "1.3");
        bl &= Version.testlt("1.2.9", "1.3.");
        bl &= Version.testlt("1.2.9", "1.3.0");
        bl &= Version.testlt("1.1.4a", "1.1.4");
        bl &= Version.testeq("2.3.4-a0", "2.3.4.a0");
        bl &= Version.testeq("2.3.4a", "2.3.4.a0");
        bl &= Version.testlt("2.3.4-a0", "2.3.4b");
        bl &= Version.testlt("2.3.4-a1", "2.3.4b1");
        bl &= Version.testlt("2.3.4a2", "2.3.4-b1");
        bl &= Version.testlt("2.3.4-a0", "2.3.4-b3");
        bl &= Version.testlt("2.3.4-a0", "2.3.4-rc1");
        bl &= Version.testlt("2.3.4-rc1", "2.3.4");
        if (!(bl &= Version.testlt("2.3.4", "2.3.4-2"))) {
            System.exit(1);
        }
    }

    private static enum Stage {
        ALPHA(0),
        BETA(1),
        RC(2),
        FINAL(3);

        private final int id;

        private Stage(int n2) {
            this.id = n2;
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "-a";
                }
                case 1: {
                    return "-b";
                }
                case 2: {
                    return "-rc";
                }
            }
            return "-";
        }
    }
}

