/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.broadinstitute.gpp.poolq3.numeric.numeric$package$;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.BarcodeFrequency;
import org.broadinstitute.gpp.poolq3.reports.BarcodeFrequency$;
import org.broadinstitute.gpp.poolq3.reports.QualityWriter;
import org.broadinstitute.gpp.poolq3.reports.reports$package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric$LongIsIntegral$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class QualityWriter$
implements Serializable {
    public static final QualityWriter$ MODULE$ = new QualityWriter$();

    private QualityWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QualityWriter$.class);
    }

    public Try<BoxedUnit> write(Path qualityFile, Path conditionBarcodeCountsSummaryFile, State state, Reference rowReference, Reference colReference, boolean isPairedEnd) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            QualityWriter$.write$$anonfun$1(qualityFile, conditionBarcodeCountsSummaryFile, isPairedEnd, state, colReference, rowReference);
            return BoxedUnit.UNIT;
        });
    }

    private String decOptFmt(Option<Object> d) {
        return (String)d.map((Function1<Object, String> & Serializable)x$0 -> QualityWriter$.decOptFmt$$anonfun$1(BoxesRunTime.unboxToDouble(x$0))).getOrElse(QualityWriter$::decOptFmt$$anonfun$2);
    }

    private <A> Seq<String> perBarcodeQualityData(State state, Reference rowReference, Reference colReference, String colBarcode) {
        String conditions = colReference.idsForBarcode(colBarcode).mkString(",");
        long matchedRowAndCol = BoxesRunTime.unboxToLong(((IterableOnceOps)rowReference.allBarcodes().map((Function1<String, long> & Serializable)rowBarcode -> state.known().count(Tuple2$.MODULE$.apply(rowBarcode, colBarcode)))).sum(Numeric$LongIsIntegral$.MODULE$));
        long matchedCol = state.knownCol().count(colBarcode);
        double pct = numeric$package$.MODULE$.percent(matchedRowAndCol, matchedCol);
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)colReference.referenceBarcodeForDnaBarcode(colBarcode)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)conditions), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToLong(matchedRowAndCol).toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToLong(matchedCol).toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)numeric$package$.MODULE$.Decimal00Format().format(pct)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)numeric$package$.MODULE$.Decimal000Format().format(numeric$package$.MODULE$.logNormalize(matchedRowAndCol, state.reads()))), Nil$.MODULE$)))))));
    }

    private static final PrintWriter write$$anonfun$1$$anonfun$1(Path conditionBarcodeCountsSummaryFile$2) {
        return new PrintWriter(conditionBarcodeCountsSummaryFile$2.toFile());
    }

    private static final void write$$anonfun$1(Path qualityFile$1, Path conditionBarcodeCountsSummaryFile$1, boolean isPairedEnd$1, State state$1, Reference colReference$1, Reference rowReference$1) {
        Using$.MODULE$.resources(new PrintWriter(qualityFile$1.toFile()), () -> QualityWriter$.write$$anonfun$1$$anonfun$1(conditionBarcodeCountsSummaryFile$1), (x$12, x$2) -> {
            Tuple2<PrintWriter, PrintWriter> tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                PrintWriter qualityWriter = tuple2._1();
                PrintWriter cbcsWriter = tuple2._2();
                String barcodeLocationStats = isPairedEnd$1 ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(487).append("Reads with no construct barcode: ").append(state$1.rowBarcodeNotFound() + state$1.revRowBarcodeNotFound() - state$1.neitherRowBarcodeFound()).append("\n             |\n             |Reads with no forward construct barcode: ").append(state$1.rowBarcodeNotFound()).append("\n             |Max forward construct barcode index: ").append(state$1.rowBarcodeStats().maxPosStr()).append("\n             |Min forward construct barcode index: ").append(state$1.rowBarcodeStats().minPosStr()).append("\n             |Avg forward construct barcode index: ").append(MODULE$.decOptFmt(state$1.rowBarcodeStats().avg())).append("\n             |\n             |Reads with no reverse construct barcode: ").append(state$1.revRowBarcodeNotFound()).append("\n             |Max reverse construct barcode index: ").append(state$1.revRowBarcodeStats().maxPosStr()).append("\n             |Min reverse construct barcode index: ").append(state$1.revRowBarcodeStats().minPosStr()).append("\n             |Avg reverse construct barcode index: ").append(MODULE$.decOptFmt(state$1.revRowBarcodeStats().avg())).toString())) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(165).append("Reads with no construct barcode: ").append(state$1.rowBarcodeNotFound()).append("\n             |Max construct barcode index: ").append(state$1.rowBarcodeStats().maxPosStr()).append("\n             |Min construct barcode index: ").append(state$1.rowBarcodeStats().minPosStr()).append("\n             |Avg construct barcode index: ").append(MODULE$.decOptFmt(state$1.rowBarcodeStats().avg())).toString()));
                String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(160).append("Total reads: ").append(state$1.reads()).append("\n           |Matching reads: ").append(state$1.matches()).append("\n           |1-base mismatch reads: ").append(state$1.matches() - state$1.exactMatches()).append("\n           |\n           |Overall % match: ").append(numeric$package$.MODULE$.Decimal00Format().format(state$1.matchPercent())).append("\n           |\n           |").append(barcodeLocationStats).append("\n           |").toString()));
                qualityWriter.println(header);
                qualityWriter.println("Read counts for sample barcodes with associated conditions:");
                QualityWriter.TeeWriter tw = new QualityWriter.TeeWriter(qualityWriter, cbcsWriter);
                tw.println("Barcode\tCondition\tMatched (Construct+Sample Barcode)\tMatched Sample Barcode\t% Match\tNormalized Match");
                colReference$1.allBarcodes().foreach(colBarcode -> {
                    Seq<String> data = MODULE$.perBarcodeQualityData(state$1, rowReference$1, colReference$1, (String)colBarcode);
                    tw.println(data.mkString("\t"));
                });
                qualityWriter.println();
                qualityWriter.println("Read counts for most common sample barcodes without associated conditions:");
                Seq unepectedBarcodeFrequencies = ((IterableOnceOps)state$1.unknownCol().keys().map((Function1<String, BarcodeFrequency> & Serializable)barcode2 -> BarcodeFrequency$.MODULE$.apply((String)barcode2, state$1.unknownCol().count((String)barcode2)))).toSeq();
                reports$package$.MODULE$.topN(unepectedBarcodeFrequencies, 100, BarcodeFrequency$.MODULE$.ord()).foreach(x$1 -> {
                    BarcodeFrequency barcodeFrequency = x$1;
                    if (barcodeFrequency != null) {
                        BarcodeFrequency barcodeFrequency2 = BarcodeFrequency$.MODULE$.unapply(barcodeFrequency);
                        String string2 = barcodeFrequency2._1();
                        long l = barcodeFrequency2._2();
                        String barcode2 = string2;
                        long count = l;
                        qualityWriter.println(new StringBuilder(1).append(barcode2).append("\t").append(BoxesRunTime.boxToLong(count).toString()).toString());
                        return;
                    }
                    throw new MatchError(barcodeFrequency);
                });
                qualityWriter.println();
                return;
            }
            throw new MatchError(tuple2);
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private static final /* synthetic */ String decOptFmt$$anonfun$1(double x$0) {
        return numeric$package$.MODULE$.Decimal00Format().format(x$0);
    }

    private static final String decOptFmt$$anonfun$2() {
        return "N/A";
    }
}

