/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.FileCreator;
import gov.nih.nlm.ncbi.ngs.HttpException;
import gov.nih.nlm.ncbi.ngs.HttpManager;
import gov.nih.nlm.ncbi.ngs.LMProperties;
import gov.nih.nlm.ncbi.ngs.LibManager;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Version;

class DownloadManager {
    private LMProperties properties;

    DownloadManager(LMProperties lMProperties) {
        this.properties = lMProperties;
    }

    String getLatestVersion(String string2) {
        String string3;
        Logger.finest(">> Checking the latest version of " + string2 + " library...");
        String string4 = "cmd=vers&libname=" + string2;
        SratoolkitCgis sratoolkitCgis = new SratoolkitCgis(this.properties);
        while ((string3 = sratoolkitCgis.nextSpec()) != null) {
            try {
                String string5 = HttpManager.post(string3, string4);
                string5 = string5.trim();
                Logger.info("The latest version of " + string2 + " = " + string5);
                return string5;
            }
            catch (HttpException httpException) {
                Logger.finest(httpException);
            }
        }
        Logger.info("Cannot check the latest version of " + string2);
        return null;
    }

    DownloadResult downloadLib(FileCreator fileCreator, String string2, Version version) {
        String string3;
        String string4 = "cmd=lib&version=1.0&libname=" + string2;
        try {
            string4 = string4 + "&" + this.osProperties();
        }
        catch (Exception exception) {
            Logger.warning("Cannot download library: " + exception.getMessage());
            return DownloadResult.FAILED;
        }
        SratoolkitCgis sratoolkitCgis = new SratoolkitCgis(this.properties);
        while ((string3 = sratoolkitCgis.nextSpec()) != null) {
            int n = HttpManager.post(string3, string4, fileCreator, string2);
            if (n == 200) {
                return DownloadResult.SUCCESS;
            }
            if (n == 412) {
                Logger.warning("Cannot download library: " + n);
                return DownloadResult.UNSUPPORTED_OS;
            }
            Logger.warning("Cannot download library: " + n);
        }
        return DownloadResult.FAILED;
    }

    private String osProperties() throws Exception {
        String string2;
        String string3 = "os_name=";
        String string4 = System.getProperty("os.name");
        if (string4 == null) {
            throw new Exception("Cannot detect OS");
        }
        string3 = string3 + string4 + "&bits=" + LibManager.detectJVM().intString();
        String string5 = System.getProperty("os.arch");
        if (string5 != null) {
            string3 = string3 + "&os_arch=" + string5;
        }
        if ((string2 = System.getProperty("os.version")) != null) {
            string3 = string3 + "&os_version=" + string2;
        }
        return string3;
    }

    private static class SratoolkitCgis {
        private String spec;
        private boolean done;

        private SratoolkitCgis(LMProperties lMProperties) {
            this.spec = lMProperties.getProperty("/servers/sratookit-cgi");
            if (this.spec != null) {
                Logger.warning("Use " + this.spec + " from " + lMProperties.cfgFilePath());
            } else {
                this.spec = "https://trace.ncbi.nlm.nih.gov/Traces/sratoolkit/sratoolkit.cgi";
            }
            this.done = false;
        }

        private String nextSpec() {
            if (!this.done) {
                this.done = true;
                return this.spec;
            }
            return null;
        }
    }

    static enum DownloadResult {
        SUCCESS,
        FAILED,
        UNSUPPORTED_OS;

    }
}

