/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs.error;

import gov.nih.nlm.ncbi.ngs.error.cause.LibraryLoadCause;

public class LibraryLoadError
extends ExceptionInInitializerError {
    String libName;
    LibraryLoadCause cause;
    String errorMessage;
    String recommendation;

    public LibraryLoadError(String string2, String string3, LibraryLoadCause libraryLoadCause) {
        this(string2, string3, libraryLoadCause, libraryLoadCause.getRecommendation());
    }

    public LibraryLoadError(String string2, String string3, LibraryLoadCause libraryLoadCause, String string4) {
        super(LibraryLoadError.generateMsg(string2, string3, libraryLoadCause, string4));
        this.libName = string2;
        this.cause = libraryLoadCause;
        this.errorMessage = LibraryLoadError.generateMsg(string2, string3, libraryLoadCause, null);
        this.recommendation = string4;
    }

    @Override
    public LibraryLoadCause getCause() {
        return this.cause;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    private static String generateMsg(String string2, String string3, LibraryLoadCause libraryLoadCause, String string4) {
        String string5 = "Failed to load '" + string2 + "' - " + string3;
        if (libraryLoadCause != null) {
            string5 = string5 + ", " + libraryLoadCause.getMessage();
            if (string4 != null) {
                string5 = string5 + "\n" + string4;
            }
        }
        return string5;
    }
}

