/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.utils;

import java.util.Collection;
import java.util.function.Supplier;

public class ValidationUtils {
    public static <T> T nonNull(T object) {
        return ValidationUtils.nonNull(object, "object");
    }

    public static <T> T nonNull(T object, String nameOfObject) {
        if (object == null) {
            throw new IllegalArgumentException(nameOfObject + " cannot be null.");
        }
        return object;
    }

    public static <T> T nonNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalArgumentException(message.get());
        }
        return object;
    }

    public static <T extends Collection<?>> T nonEmpty(T collection2, String nameOfObject) {
        ValidationUtils.nonNull(collection2, nameOfObject);
        if (collection2.isEmpty()) {
            throw new IllegalArgumentException(nameOfObject + " cannot be empty");
        }
        return collection2;
    }

    public static boolean isNonEmpty(Collection<?> collection2) {
        return collection2 != null && !collection2.isEmpty();
    }

    public static String nonEmpty(String string2, String nameOfObject) {
        ValidationUtils.nonNull(string2, nameOfObject);
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("The string is empty: " + nameOfObject);
        }
        return string2;
    }

    public static String nonEmpty(String string2) {
        return ValidationUtils.nonEmpty(string2, "string");
    }

    public static <I, T extends Collection<I>> T nonEmpty(T collection2) {
        return ValidationUtils.nonEmpty(collection2, "collection");
    }

    public static void validateArg(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateArg(boolean condition, Supplier<String> msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg.get());
        }
    }
}

