/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import java.util.Arrays;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.FixedOffsetPolicy$;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode;
import org.broadinstitute.gpp.poolq3.barcode.FoundBarcode$;
import org.broadinstitute.gpp.poolq3.barcode.ReadTooShortException$;
import org.broadinstitute.gpp.poolq3.types.Read;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class FixedOffsetPolicy
implements BarcodePolicy,
Product,
Serializable {
    private final int startPos0;
    private final int length;
    private final boolean skipShortReads;
    private final int minLength;
    private final int endPos0;

    public static FixedOffsetPolicy apply(int n, int n2, boolean bl) {
        return FixedOffsetPolicy$.MODULE$.apply(n, n2, bl);
    }

    public static FixedOffsetPolicy apply(String string2, Option<Object> option, boolean bl) {
        return FixedOffsetPolicy$.MODULE$.apply(string2, option, bl);
    }

    public static FixedOffsetPolicy fromProduct(Product product) {
        return FixedOffsetPolicy$.MODULE$.fromProduct(product);
    }

    public static FixedOffsetPolicy unapply(FixedOffsetPolicy fixedOffsetPolicy) {
        return FixedOffsetPolicy$.MODULE$.unapply(fixedOffsetPolicy);
    }

    public FixedOffsetPolicy(int startPos0, int length, boolean skipShortReads) {
        this.startPos0 = startPos0;
        this.length = length;
        this.skipShortReads = skipShortReads;
        this.minLength = startPos0 + length;
        this.endPos0 = startPos0 + length;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.startPos0());
        n = Statics.mix(n, this.length());
        n = Statics.mix(n, this.skipShortReads() ? 1231 : 1237);
        return Statics.finalizeHash(n, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FixedOffsetPolicy)) return false;
        FixedOffsetPolicy fixedOffsetPolicy = (FixedOffsetPolicy)object;
        if (this.startPos0() != fixedOffsetPolicy.startPos0()) return false;
        if (this.length() != fixedOffsetPolicy.length()) return false;
        if (this.skipShortReads() != fixedOffsetPolicy.skipShortReads()) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof FixedOffsetPolicy;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "FixedOffsetPolicy";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger(this._2());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean(this._3());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "startPos0";
            }
            case 1: {
                return "length";
            }
            case 2: {
                return "skipShortReads";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int startPos0() {
        return this.startPos0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public boolean skipShortReads() {
        return this.skipShortReads;
    }

    @Override
    public Option<FoundBarcode> find(Read read) {
        if (read.seq().length() < this.minLength) {
            if (this.skipShortReads()) {
                return None$.MODULE$;
            }
            throw ReadTooShortException$.MODULE$.apply(read.seq(), this.startPos0(), this.minLength);
        }
        return Some$.MODULE$.apply(FoundBarcode$.MODULE$.apply(Arrays.copyOfRange(read.seq().toCharArray(), this.startPos0(), this.endPos0), this.startPos0()));
    }

    public FixedOffsetPolicy copy(int startPos0, int length, boolean skipShortReads) {
        return new FixedOffsetPolicy(startPos0, length, skipShortReads);
    }

    public int copy$default$1() {
        return this.startPos0();
    }

    public int copy$default$2() {
        return this.length();
    }

    public boolean copy$default$3() {
        return this.skipShortReads();
    }

    public int _1() {
        return this.startPos0();
    }

    public int _2() {
        return this.length();
    }

    public boolean _3() {
        return this.skipShortReads();
    }
}

