/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.hist;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.ShardedHistogram;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;

public class BasicShardedHistogram<A, B>
implements ShardedHistogram<A, B> {
    private final Function0<Histogram<B>> make;
    private final Object2ObjectOpenHashMap hs;
    private final Histogram nullShard;

    public BasicShardedHistogram(Function0<Histogram<B>> make) {
        this.make = make;
        this.hs = new Object2ObjectOpenHashMap();
        this.nullShard = make.apply();
    }

    public Object2ObjectOpenHashMap<A, Histogram<B>> hs() {
        return this.hs;
    }

    public Histogram<B> nullShard() {
        return this.nullShard;
    }

    @Override
    public Histogram<B> forShard(Option<A> shard) {
        Option<A> option = shard;
        if (None$.MODULE$.equals(option)) {
            return this.nullShard();
        }
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return this.hs().compute(s, (_$1, h) -> {
                if (h == null) {
                    return this.make.apply();
                }
                return h;
            });
        }
        throw new MatchError(option);
    }

    @Override
    public long increment(Option<A> shard, B k) {
        return this.forShard(shard).increment(k);
    }

    @Override
    public Set<A> shards() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.hs().keySet()).asScala().toSet();
    }

    @Override
    public Set<B> keys(Option<A> shard) {
        return this.forShard(shard).keys();
    }

    @Override
    public Set<B> keys() {
        HashSet keys = new HashSet();
        keys.addAll(this.nullShard().keys());
        this.hs().forEach((_$2, h) -> keys.addAll(h.keys()));
        return keys.toSet();
    }
}

